#include "Gait.h"


Gait::Gait(Tripod tripod_1, Tripod tripod_2) :

    group_1(tripod_1),
    group_2(tripod_2)

{

}

void Gait::time_1(void)

{
    tripod_2_timeout.attach(this, &Gait::time_2, 0.4);
    group_1.gait_smooth();

}


void Gait::time_2(void)

{
    tripod_1_timeout.attach(this, &Gait::time_1, 0.4);
    group_2.gait_smooth();

}


void Gait::start(int group)

{
    switch(group) {
        case 1:
            tripod_1_timeout.attach(this, &Gait::time_1, 1);
            break;
        case 2:
            tripod_2_timeout.attach(this, &Gait::time_2, 1);
            break;
        default:
            break;
    }
}


void Gait::stop(void)

{

    tripod_2_timeout.detach();
    tripod_1_timeout.detach();

}

