#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "SRF02.h"
#include "N5110.h"
#include "main.h"

int main()
{
    PHY_PowerDown();
    lcd.init(); // initialise display
    lcd.printString("Ultrasonic", 13,1);    // print string on row 1
    lcd.printString("Sensor", 25,2);    // print string on row 2
    lcd.printString("Adrian Wong", 9,4);    // print string on row 4
    lcd.drawRect(1,1,81,45,0);    // transparent, just outline
    lcd.drawRect(5,26,28,2,1);    // filled black rectangle
    lcd.drawRect(51,26,28,2,1);  // filled black rectangle
    lcd.printString("X", 40,3); // print string on row 3
    lcd.drawCircle(37,27,1,1);  // x,y,radius,black fill
    lcd.drawCircle(47,27,1,1);  // x,y,radius,black fill
    wait(1);
    lcd.clear(); // Clear all pixels off display
    serial.baud(9600); // set baud rate
    unit.rise(&uPressed); // call ISR on rising edge (button pressed)
    display.rise(&dPressed); // call ISR on rising edge (button pressed)
    timer1.attach(&timer1Expired,1); // 1s timer
    timer2.attach(&timer2Expired,0.8); // 0.8s timer
    timer3.attach(&timer3Expired,0.6); // 0.6s timer
    timer4.attach(&timer4Expired,0.3); // 0.3s timer
    timer5.attach(&timer5Expired,0.1); // 0.1s timer
    serial.attach(&serialISR); // attach serial ISR
    char buffer[30]; // buffer used to store information
    char buffer1[14]; // buffer used to store distance for LCD
    char buffer2[14]; // buffer used to store time for LCD
    char buffer3[14]; // buffer used to store month/date for LCD
    led1 = 1;

    while(1)  {
        lcd.normalMode();      // normal colour mode
        lcd.setBrightness(0.5); // put LED backlight on 50%
        led2 = 0;   // resets led2
        buzzer = 0; // resets buzzer
        buzzer.period(0.001);   // sets buzzer pwm period
        float distance = measureDistance(); // get the distance
        time_t seconds = time(NULL); // get current time
// format time into a string (time and date)
        strftime(buffer, 30 , "%b %d, %X", localtime(&seconds));    // set buffer to store time and date
        strftime(buffer2, 14 , "%X", localtime(&seconds));  // set buffer2 to store time
        strftime(buffer3, 14 , "%b %d", localtime(&seconds));   // set buffer3 to store date and month
        
        writeDataToFile(buffer, distance); // write current value to disk
        
        lcd.clear();    // clear display
        lcd.init(); // initialise display
        if (distance<30) {
            if (timer5Flag) {
                timer5Flag = 0; // resets timer flag
                timer4Flag = 0; // resets timer flag
                timer3Flag = 0; // resets timer flag
                timer2Flag = 0; // resets timer flag
                timer1Flag = 0; // resets timer flag
                if (uFlag) {
                    float mdistance = distance/100; // get distance in metres
                    serial.printf("%s, %.2f m\n",buffer, mdistance);    // print time then distance in metres
                    float length = sprintf(buffer1,"D = %.2f m",mdistance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);   // print on row 4
                                    lcd.printString(buffer3,24,3);   // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,84,48,1);  // filled black rectangle
                    }
                } else {
                    serial.printf("%s, %.0f cm\n",buffer, distance);    // print time then distance in centimetres
                    float length = sprintf(buffer1,"D = %.2f cm",distance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);  // print on row 4
                                    lcd.printString(buffer3,24,3);  // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,84,48,1);  // filled black rectangle
                    }
                }
                serial.printf("Rate = 0.1\n");
                warning();
            }
        } else if (distance<60) {
            if (timer4Flag) {
                timer5Flag = 0; // resets timer flag
                timer4Flag = 0; // resets timer flag
                timer3Flag = 0; // resets timer flag
                timer2Flag = 0; // resets timer flag
                timer1Flag = 0; // resets timer flag
                if (uFlag) {
                    float mdistance = distance/100; // get distance in metres
                    serial.printf("%s, %.2f m\n",buffer, mdistance);    // print time then distance in metres
                    float length = sprintf(buffer1,"D = %.2f m",mdistance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);   // print on row 4
                                    lcd.printString(buffer3,24,3);   // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,64,48,1);  // filled black rectangle
                    }
                } else {
                    serial.printf("%s, %.0f cm\n",buffer, distance);    // print time then distance in centimetres
                    float length = sprintf(buffer1,"D = %.2f cm",distance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);  // print on row 4
                                    lcd.printString(buffer3,24,3);  // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,64,48,1);  // filled black rectangle
                    }
                }
                serial.printf("Rate = 0.3\n");
                warning();
            }
        } else if (distance<90) {
            if (timer3Flag) {
                timer5Flag = 0; // resets timer flag
                timer4Flag = 0; // resets timer flag
                timer3Flag = 0; // resets timer flag
                timer2Flag = 0; // resets timer flag
                timer1Flag = 0; // resets timer flag
                if (uFlag) {
                    float mdistance = distance/100; // get distance in metres
                    serial.printf("%s, %.2f m\n",buffer, mdistance);    // print time then distance in metres
                    float length = sprintf(buffer1,"D = %.2f m",mdistance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);   // print on row 4
                                    lcd.printString(buffer3,24,3);   // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,44,48,1);  // filled black rectangle
                    }
                } else {
                    serial.printf("%s, %.0f cm\n",buffer, distance);    // print time then distance in centimetres
                    float length = sprintf(buffer1,"D = %.2f cm",distance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);  // print on row 4
                                    lcd.printString(buffer3,24,3);  // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,44,48,1);  // filled black rectangle
                    }
                }
                serial.printf("Rate = 0.6\n");
                warning();
            }
        } else if (distance<120) {
            if (timer2Flag) {
                timer5Flag = 0; // resets timer flag
                timer4Flag = 0; // resets timer flag
                timer3Flag = 0; // resets timer flag
                timer2Flag = 0; // resets timer flag
                timer1Flag = 0; // resets timer flag
                if (uFlag) {
                    float mdistance = distance/100; // get distance in metres
                    serial.printf("%s, %.2f m\n",buffer, mdistance);    // print time then distance in metres
                    float length = sprintf(buffer1,"D = %.2f m",mdistance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);   // print on row 4
                                    lcd.printString(buffer3,24,3);   // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,24,48,1);  // filled black rectangle
                    }
                } else {
                    serial.printf("%s, %.0f cm\n",buffer, distance);    // print time then distance in centimetres
                    float length = sprintf(buffer1,"D = %.2f cm",distance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);  // print on row 4
                                    lcd.printString(buffer3,24,3);  // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,24,48,1);  // filled black rectangle
                    }
                }
                serial.printf("Rate = 0.8\n");
                warning();
            }
        } else {
            if (timer1Flag) {
                timer5Flag = 0; // resets timer flag
                timer4Flag = 0; // resets timer flag
                timer3Flag = 0; // resets timer flag
                timer2Flag = 0; // resets timer flag
                timer1Flag = 0; // resets timer flag
                if (uFlag) {
                    float mdistance = distance/100; // get distance in metres
                    serial.printf("%s, %.2f m\n",buffer, mdistance);    // print time then distance in metres
                    float length = sprintf(buffer1,"D = %.2f m",mdistance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);   // print on row 4
                                    lcd.printString(buffer3,24,3);   // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,4,48,1);  // filled black rectangle
                    }
                } else {
                    serial.printf("%s, %.0f cm\n",buffer, distance);    // print time then distance in centimetres
                    float length = sprintf(buffer1,"D = %.2f cm",distance); // print distance on lcd
                    float length1 = sprintf(buffer2,"%s",buffer2);  // print time
                    float length2 = sprintf(buffer3,"%s",buffer3);  // print date and month
                    if (dFlag) {
                        if (length <= 14) {
                            if (length1 <= 14) {
                                if (length2 <= 14) {
                                    lcd.printString(buffer1,3,1);   // print on row 1
                                    lcd.printString(buffer2,18,4);  // print on row 4
                                    lcd.printString(buffer3,24,3);  // print on row 3
                                }
                            }
                        }
                    } else {
                        lcd.drawRect(1,1,4,48,1);  // filled black rectangle
                    }
                }
                serial.printf("Rate = 1\n");
                warning();
            }
        }
        if (setTimeFlag) { // if updated time has been sent
            setTimeFlag = 0; // clear flag
            setTime(); // update time
        }
        Sleep();
    }
}


void timer1Expired()
{
    timer1Flag = 1;
}

void timer2Expired()
{
    timer2Flag = 1;
}

void timer3Expired()
{
    timer3Flag = 1;
}

void timer4Expired()
{
    timer4Flag = 1;
}

void timer5Expired()
{
    timer5Flag = 1;
}

float measureDistance()
{
    float d1 = sensor.getDistanceCm();
    float d2 = sensor.getDistanceCm();
    float d3 = sensor.getDistanceCm();
    float d4 = sensor.getDistanceCm();
    float d5 = sensor.getDistanceCm();
    float d6 = sensor.getDistanceCm();
    float d7 = sensor.getDistanceCm();
    float d8 = sensor.getDistanceCm();
    float d9 = sensor.getDistanceCm();
    float d10 = sensor.getDistanceCm();
    float dt = (d1+d2+d3+d4+d5+d6+d7+d8+d9+d10)/10;
    return dt;
}

void setTime()
{
// print time for debugging
    serial.printf("set_time - %s",rxString);
// atoi() converts a string to an integer
    int time = atoi(rxString);
// update the time
    set_time(time);
}
void serialISR()
{
// when a serial interrupt occurs, read rx string into buffer
    serial.gets(rxString,30);
// set flag
    setTimeFlag = 1;
}

void uPressed()   // toggle direction in ISR
{
    uFlag = !uFlag;
    wait (0.2);
}

void dPressed()   // toggle direction in ISR
{
    dFlag = !dFlag;
    wait (0.2);
}

void warning()
{
    float vol = pot.read()/5;
    led2 = !led2;
    buzzer = vol+0.8;
}

void writeDataToFile(char* buffer, float distance)
{
    leds = 1; // turn on LEDs for feedback
    FILE *fp = fopen("/local/log.csv", "a"); // open 'log.csv' for appending
// if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"%s, %.2f\n",buffer, distance); // print string to file
    serial.printf("Data Logged\n\r");
    fclose(fp); // close file
    leds = 0; // turn off LEDs to signify file access has finished
}
