#include "mbed.h"
#include <string.h>
#include <stdio.h>

 
Serial xbee(p9,p10); //Initalise xbee_lib

DigitalOut myled(LED1);
DigitalOut mled(LED2);
DigitalOut m3led(LED3);
DigitalOut m4led(LED4);


void xbee_detect(void);
void light2(void);
void light1(void);
void reed1(void);
void reed2(void);
void count1(void);
void count2(void);
void count3(void);
void count4(void);
 
 
//pin D4 and D3 configured 
int xbee1 = 104;// reed switches
int xbee2 = 45; // PIR
int xbee3 = 76;// reed switches
int xbee4 = 69;// PIR


short counter1 = 0;
short counter2 = 0;
short counter3 = 0;
short counter4 = 0;
int readAddress = 0;
int readValue=0;

 
//function declarations 
//void setRGBPixel(int r, int g, int b); //sets colour of one RGB Pixel
void setRGBStrip1(int r, int g, int b); //sets colour of a strip of 8 RGB Pixels on pin 5
void setRGBStrip2(int r, int g, int b); //sets colour of a strip of 8 RGB Pixels on pin 11
void setRGBPixels1(int colours[8][3]); //sets sequence of colours for a strip of 8 RGB Pixels on pin 5
void setRGBPixels2(int colours[8][3]); //sets sequence of colours for a strip of 8 RGB Pixels on pin 11
//void setRGBFloor1(int colours[2][8][3]); //sets a sequence of colours for 2 strips of 8 RGB Pixels on pin 5
//void setRGBFloor2(int colours[2][8][3]); //sets a sequence of colours for 2 strips of 8 RGB Pixels on pin 11
 
 
void spi_init(); //initializes SPI pin at correct bit length and bit rate
int * decimalToBinary(int n); //converts a decimal value between 0 and 255 to an 8 bit binary array of 0xF00 (0) and 0xFF0 (1)
 
//initialize pins 
DigitalOut volt(p16); //pin for LV voltage
SPI spi(p5, p6, p7);//pin for SPI communication - p5 MOSI p5 MISO p6 SCLK
SPI spi2(p11, p12, p13);//pin for SPI communication - p5 MOSI p5 MISO p6 SCLK
 
int main() {
       setRGBStrip1(0,0,0);
       wait(2);
       
    while(1) {
        xbee_detect();
        //setRGBStrip1(127,127,127);
        light2();
        light1();
        reed1();
        reed2();
}
}
 
void xbee_detect(void){
    if (xbee.getc() == 0x7E) {
        for (int i = 0; i < 19; i++) {
            if (i<10){
                int discard = xbee.getc();
            }
            else if (i<11){
                readAddress = xbee.getc();
            }
            else{
                int discarded = xbee.getc();
            }
        }
        readValue = xbee.getc();
    }
}
    //lights room1
void light1(void){
     if ( readAddress == xbee2){
        if (readValue == 0){
            counter2++;
            count2();
    }
    else if(readValue == 16){
            counter2 = 0;
            setRGBStrip1(127,127,127);
            wait(2);//mled = 1;
            }
    }
}
    //room 2
void light2(void){
      if ( readAddress == xbee4){
        if (readValue == 0){
            counter4++;
            count4();
           
        }
    
    else if(readValue == 16){
            counter4 = 0;
             setRGBStrip2(127,127,127);
    }
    }
}

void reed1(void){
    if( readAddress == xbee1){
        if (readValue == 0){
            counter1++;
            count1();
    }
    else if(readValue == 16){
        counter1 = 0;
        myled = 1;
    }
    }
}
    //room 2
void reed2(void){
   if ( readAddress == xbee3){
        if (readValue == 0){
            counter3++;
            count3();
    }
    else if(readValue == 16){
            counter3 = 0;
            m3led = 1;
    }
}
}

void count1(void){
     if(counter1==10){
                myled = 0;
                counter1 = 0;
            }
    }
void count3(void){
     if(counter3==10){
                m3led = 0;
                counter1 = 0;
            }
    }

//lights count 
void count2(void){
     if(counter2==150){
                   // mled = 0;
                   setRGBStrip1(0,0,0);
                   wait(2);
                    counter2 = 0;
        }
    }

void count4(void){
     if(counter4==150){
                   // mled = 0;
                   setRGBStrip2(0,0,0);
                    counter2 = 0;
        }
    }

void setRGBStrip1(int r, int g, int b){
    int r_array[8];
    int g_array[8];
    int b_array[8];
    memcpy(r_array, decimalToBinary(r), sizeof(r_array));
    memcpy(g_array, decimalToBinary(g), sizeof(g_array));
    memcpy(b_array, decimalToBinary(b), sizeof(b_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED1    
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED2
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED3
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED4
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED5
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED6
     //set green bits
     
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //LED7
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    
    //wait for latch 
    wait_us(60);
}
 
void setRGBStrip2(int r, int g, int b){
    int r_array[8];
    int g_array[8];
    int b_array[8];
    memcpy(r_array, decimalToBinary(r), sizeof(r_array));
    memcpy(g_array, decimalToBinary(g), sizeof(g_array));
    memcpy(b_array, decimalToBinary(b), sizeof(b_array));
    
    //send commands to LED Driver
     //initialize spi
     spi_init();
    //LED0
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED1    
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED2
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED3
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED4
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED5
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED6
     //set green bits
     
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    //LED7
     //set green bits
    spi2.write(g_array[7]); //set g7 bit
    spi2.write(g_array[6]); //set g6 bit
    spi2.write(g_array[5]); //set g5 bit
    spi2.write(g_array[4]); //set g4 bit
    spi2.write(g_array[3]); //set g3 bit
    spi2.write(g_array[2]); //set g2 bit
    spi2.write(g_array[1]); //set g1 bit 
    spi2.write(g_array[0]);//set g0 bit
    //set red bits
    spi2.write(r_array[7]);//set r7 bit
    spi2.write(r_array[6]); //set r6 bit
    spi2.write(r_array[5]); //set r5 bit
    spi2.write(r_array[4]); //set r4 bit
    spi2.write(r_array[3]); //set r3 bit
    spi2.write(r_array[2]); //set r2 bit
    spi2.write(r_array[1]); //set r1 bit 
    spi2.write(r_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b_array[7]); //set b7 bit
    spi2.write(b_array[6]); //set b6 bit
    spi2.write(b_array[5]); //set b5 bit
    spi2.write(b_array[4]); //set b4 bit
    spi2.write(b_array[3]); //set b3 bit
    spi2.write(b_array[2]); //set b2 bit
    spi2.write(b_array[1]); //set b1 bit 
    spi2.write(b_array[0]); //set b0 bit
    
    //wait for latch 
    wait_us(60);
}
    
    
 
void setRGBPixel(int r, int g, int b){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    int r_array[8];
    int g_array[8];
    int b_array[8];
    memcpy(r_array, decimalToBinary(r), sizeof(r_array));
    memcpy(g_array, decimalToBinary(g), sizeof(g_array));
    memcpy(b_array, decimalToBinary(b), sizeof(b_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
     //set green bits
    spi.write(g_array[7]); //set g7 bit
    spi.write(g_array[6]); //set g6 bit
    spi.write(g_array[5]); //set g5 bit
    spi.write(g_array[4]); //set g4 bit
    spi.write(g_array[3]); //set g3 bit
    spi.write(g_array[2]); //set g2 bit
    spi.write(g_array[1]); //set g1 bit 
    spi.write(g_array[0]);//set g0 bit
    //set red bits
    spi.write(r_array[7]);//set r7 bit
    spi.write(r_array[6]); //set r6 bit
    spi.write(r_array[5]); //set r5 bit
    spi.write(r_array[4]); //set r4 bit
    spi.write(r_array[3]); //set r3 bit
    spi.write(r_array[2]); //set r2 bit
    spi.write(r_array[1]); //set r1 bit 
    spi.write(r_array[0]); //set r0 bit
    //set blue bits
    spi.write(b_array[7]); //set b7 bit
    spi.write(b_array[6]); //set b6 bit
    spi.write(b_array[5]); //set b5 bit
    spi.write(b_array[4]); //set b4 bit
    spi.write(b_array[3]); //set b3 bit
    spi.write(b_array[2]); //set b2 bit
    spi.write(b_array[1]); //set b1 bit 
    spi.write(b_array[0]); //set b0 bit
    //wait for latch
    wait_us(60);
}
 
void setRGBPixels1(int colours[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    int r0_array[8]; //LED0
    int g0_array[8];
    int b0_array[8];
    memcpy(r0_array, decimalToBinary(colours[0][0]), sizeof(r0_array));
    memcpy(g0_array, decimalToBinary(colours[0][1]), sizeof(g0_array));
    memcpy(b0_array, decimalToBinary(colours[0][2]), sizeof(b0_array));
    int r1_array[8]; //LED1
    int g1_array[8];
    int b1_array[8];
    memcpy(r1_array, decimalToBinary(colours[1][0]), sizeof(r1_array));
    memcpy(g1_array, decimalToBinary(colours[1][1]), sizeof(g1_array));
    memcpy(b1_array, decimalToBinary(colours[1][2]), sizeof(b1_array));
    int r2_array[8]; //LED2
    int g2_array[8];
    int b2_array[8];
    memcpy(r2_array, decimalToBinary(colours[2][0]), sizeof(r2_array));
    memcpy(g2_array, decimalToBinary(colours[2][1]), sizeof(g2_array));
    memcpy(b2_array, decimalToBinary(colours[2][2]), sizeof(b2_array));
    int r3_array[8]; //LED3
    int g3_array[8];
    int b3_array[8];
    memcpy(r3_array, decimalToBinary(colours[3][0]), sizeof(r3_array));
    memcpy(g3_array, decimalToBinary(colours[3][1]), sizeof(g3_array));
    memcpy(b3_array, decimalToBinary(colours[3][2]), sizeof(b3_array));
    int r4_array[8]; //LED4
    int g4_array[8];
    int b4_array[8];
    memcpy(r4_array, decimalToBinary(colours[4][0]), sizeof(r4_array));
    memcpy(g4_array, decimalToBinary(colours[4][1]), sizeof(g4_array));
    memcpy(b4_array, decimalToBinary(colours[4][2]), sizeof(b4_array));
    int r5_array[8]; //LED5
    int g5_array[8];
    int b5_array[8];
    memcpy(r5_array, decimalToBinary(colours[5][0]), sizeof(r5_array));
    memcpy(g5_array, decimalToBinary(colours[5][1]), sizeof(g5_array));
    memcpy(b5_array, decimalToBinary(colours[5][2]), sizeof(b5_array));
    int r6_array[8]; //LED6
    int g6_array[8];
    int b6_array[8];
    memcpy(r6_array, decimalToBinary(colours[6][0]), sizeof(r6_array));
    memcpy(g6_array, decimalToBinary(colours[6][1]), sizeof(g6_array));
    memcpy(b6_array, decimalToBinary(colours[6][2]), sizeof(b6_array));
    int r7_array[8]; //LED7
    int g7_array[8];
    int b7_array[8];
    memcpy(r7_array, decimalToBinary(colours[7][0]), sizeof(r7_array));
    memcpy(g7_array, decimalToBinary(colours[7][1]), sizeof(g7_array));
    memcpy(b7_array, decimalToBinary(colours[7][2]), sizeof(b7_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
    //set green bits
    spi.write(g0_array[7]); //set g7 bit
    spi.write(g0_array[6]); //set g6 bit
    spi.write(g0_array[5]); //set g5 bit
    spi.write(g0_array[4]); //set g4 bit
    spi.write(g0_array[3]); //set g3 bit
    spi.write(g0_array[2]); //set g2 bit
    spi.write(g0_array[1]); //set g1 bit 
    spi.write(g0_array[0]);//set g0 bit
    //set red bits
    spi.write(r0_array[7]);//set r7 bit
    spi.write(r0_array[6]); //set r6 bit
    spi.write(r0_array[5]); //set r5 bit
    spi.write(r0_array[4]); //set r4 bit
    spi.write(r0_array[3]); //set r3 bit
    spi.write(r0_array[2]); //set r2 bit
    spi.write(r0_array[1]); //set r1 bit 
    spi.write(r0_array[0]); //set r0 bit
    //set blue bits
    spi.write(b0_array[7]); //set b7 bit
    spi.write(b0_array[6]); //set b6 bit
    spi.write(b0_array[5]); //set b5 bit
    spi.write(b0_array[4]); //set b4 bit
    spi.write(b0_array[3]); //set b3 bit
    spi.write(b0_array[2]); //set b2 bit
    spi.write(b0_array[1]); //set b1 bit 
    spi.write(b0_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi.write(g1_array[7]); //set g7 bit
    spi.write(g1_array[6]); //set g6 bit
    spi.write(g1_array[5]); //set g5 bit
    spi.write(g1_array[4]); //set g4 bit
    spi.write(g1_array[3]); //set g3 bit
    spi.write(g1_array[2]); //set g2 bit
    spi.write(g1_array[1]); //set g1 bit 
    spi.write(g1_array[0]);//set g0 bit
    //set red bits
    spi.write(r1_array[7]);//set r7 bit
    spi.write(r1_array[6]); //set r6 bit
    spi.write(r1_array[5]); //set r5 bit
    spi.write(r1_array[4]); //set r4 bit
    spi.write(r1_array[3]); //set r3 bit
    spi.write(r1_array[2]); //set r2 bit
    spi.write(r1_array[1]); //set r1 bit 
    spi.write(r1_array[0]); //set r0 bit
    //set blue bits
    spi.write(b1_array[7]); //set b7 bit
    spi.write(b1_array[6]); //set b6 bit
    spi.write(b1_array[5]); //set b5 bit
    spi.write(b1_array[4]); //set b4 bit
    spi.write(b1_array[3]); //set b3 bit
    spi.write(b1_array[2]); //set b2 bit
    spi.write(b1_array[1]); //set b1 bit 
    spi.write(b1_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi.write(g2_array[7]); //set g7 bit
    spi.write(g2_array[6]); //set g6 bit
    spi.write(g2_array[5]); //set g5 bit
    spi.write(g2_array[4]); //set g4 bit
    spi.write(g2_array[3]); //set g3 bit
    spi.write(g2_array[2]); //set g2 bit
    spi.write(g2_array[1]); //set g1 bit 
    spi.write(g2_array[0]);//set g0 bit
    //set red bits
    spi.write(r2_array[7]);//set r7 bit
    spi.write(r2_array[6]); //set r6 bit
    spi.write(r2_array[5]); //set r5 bit
    spi.write(r2_array[4]); //set r4 bit
    spi.write(r2_array[3]); //set r3 bit
    spi.write(r2_array[2]); //set r2 bit
    spi.write(r2_array[1]); //set r1 bit 
    spi.write(r2_array[0]); //set r0 bit
    //set blue bits
    spi.write(b2_array[7]); //set b7 bit
    spi.write(b2_array[6]); //set b6 bit
    spi.write(b2_array[5]); //set b5 bit
    spi.write(b2_array[4]); //set b4 bit
    spi.write(b2_array[3]); //set b3 bit
    spi.write(b2_array[2]); //set b2 bit
    spi.write(b2_array[1]); //set b1 bit 
    spi.write(b2_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi.write(g3_array[7]); //set g7 bit
    spi.write(g3_array[6]); //set g6 bit
    spi.write(g3_array[5]); //set g5 bit
    spi.write(g3_array[4]); //set g4 bit
    spi.write(g3_array[3]); //set g3 bit
    spi.write(g3_array[2]); //set g2 bit
    spi.write(g3_array[1]); //set g1 bit 
    spi.write(g3_array[0]);//set g0 bit
    //set red bits
    spi.write(r3_array[7]);//set r7 bit
    spi.write(r3_array[6]); //set r6 bit
    spi.write(r3_array[5]); //set r5 bit
    spi.write(r3_array[4]); //set r4 bit
    spi.write(r3_array[3]); //set r3 bit
    spi.write(r3_array[2]); //set r2 bit
    spi.write(r3_array[1]); //set r1 bit 
    spi.write(r3_array[0]); //set r0 bit
    //set blue bits
    spi.write(b3_array[7]); //set b7 bit
    spi.write(b3_array[6]); //set b6 bit
    spi.write(b3_array[5]); //set b5 bit
    spi.write(b3_array[4]); //set b4 bit
    spi.write(b3_array[3]); //set b3 bit
    spi.write(b3_array[2]); //set b2 bit
    spi.write(b3_array[1]); //set b1 bit 
    spi.write(b3_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi.write(g4_array[7]); //set g7 bit
    spi.write(g4_array[6]); //set g6 bit
    spi.write(g4_array[5]); //set g5 bit
    spi.write(g4_array[4]); //set g4 bit
    spi.write(g4_array[3]); //set g3 bit
    spi.write(g4_array[2]); //set g2 bit
    spi.write(g4_array[1]); //set g1 bit 
    spi.write(g4_array[0]);//set g0 bit
    //set red bits
    spi.write(r4_array[7]);//set r7 bit
    spi.write(r4_array[6]); //set r6 bit
    spi.write(r4_array[5]); //set r5 bit
    spi.write(r4_array[4]); //set r4 bit
    spi.write(r4_array[3]); //set r3 bit
    spi.write(r4_array[2]); //set r2 bit
    spi.write(r4_array[1]); //set r1 bit 
    spi.write(r4_array[0]); //set r0 bit
    //set blue bits
    spi.write(b4_array[7]); //set b7 bit
    spi.write(b4_array[6]); //set b6 bit
    spi.write(b4_array[5]); //set b5 bit
    spi.write(b4_array[4]); //set b4 bit
    spi.write(b4_array[3]); //set b3 bit
    spi.write(b4_array[2]); //set b2 bit
    spi.write(b4_array[1]); //set b1 bit 
    spi.write(b4_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi.write(g5_array[7]); //set g7 bit
    spi.write(g5_array[6]); //set g6 bit
    spi.write(g5_array[5]); //set g5 bit
    spi.write(g5_array[4]); //set g4 bit
    spi.write(g5_array[3]); //set g3 bit
    spi.write(g5_array[2]); //set g2 bit
    spi.write(g5_array[1]); //set g1 bit 
    spi.write(g5_array[0]);//set g0 bit
    //set red bits
    spi.write(r5_array[7]);//set r7 bit
    spi.write(r5_array[6]); //set r6 bit
    spi.write(r5_array[5]); //set r5 bit
    spi.write(r5_array[4]); //set r4 bit
    spi.write(r5_array[3]); //set r3 bit
    spi.write(r5_array[2]); //set r2 bit
    spi.write(r5_array[1]); //set r1 bit 
    spi.write(r5_array[0]); //set r0 bit
    //set blue bits
    spi.write(b5_array[7]); //set b7 bit
    spi.write(b5_array[6]); //set b6 bit
    spi.write(b5_array[5]); //set b5 bit
    spi.write(b5_array[4]); //set b4 bit
    spi.write(b5_array[3]); //set b3 bit
    spi.write(b5_array[2]); //set b2 bit
    spi.write(b5_array[1]); //set b1 bit 
    spi.write(b5_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi.write(g6_array[7]); //set g7 bit
    spi.write(g6_array[6]); //set g6 bit
    spi.write(g6_array[5]); //set g5 bit
    spi.write(g6_array[4]); //set g4 bit
    spi.write(g6_array[3]); //set g3 bit
    spi.write(g6_array[2]); //set g2 bit
    spi.write(g6_array[1]); //set g1 bit 
    spi.write(g6_array[0]);//set g0 bit
    //set red bits
    spi.write(r6_array[7]);//set r7 bit
    spi.write(r6_array[6]); //set r6 bit
    spi.write(r6_array[5]); //set r5 bit
    spi.write(r6_array[4]); //set r4 bit
    spi.write(r6_array[3]); //set r3 bit
    spi.write(r6_array[2]); //set r2 bit
    spi.write(r6_array[1]); //set r1 bit 
    spi.write(r6_array[0]); //set r0 bit
    //set blue bits
    spi.write(b6_array[7]); //set b7 bit
    spi.write(b6_array[6]); //set b6 bit
    spi.write(b6_array[5]); //set b5 bit
    spi.write(b6_array[4]); //set b4 bit
    spi.write(b6_array[3]); //set b3 bit
    spi.write(b6_array[2]); //set b2 bit
    spi.write(b6_array[1]); //set b1 bit 
    spi.write(b6_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi.write(g7_array[7]); //set g7 bit
    spi.write(g7_array[6]); //set g6 bit
    spi.write(g7_array[5]); //set g5 bit
    spi.write(g7_array[4]); //set g4 bit
    spi.write(g7_array[3]); //set g3 bit
    spi.write(g7_array[2]); //set g2 bit
    spi.write(g7_array[1]); //set g1 bit 
    spi.write(g7_array[0]);//set g0 bit
    //set red bits
    spi.write(r7_array[7]);//set r7 bit
    spi.write(r7_array[6]); //set r6 bit
    spi.write(r7_array[5]); //set r5 bit
    spi.write(r7_array[4]); //set r4 bit
    spi.write(r7_array[3]); //set r3 bit
    spi.write(r7_array[2]); //set r2 bit
    spi.write(r7_array[1]); //set r1 bit 
    spi.write(r7_array[0]); //set r0 bit
    //set blue bits
    spi.write(b7_array[7]); //set b7 bit
    spi.write(b7_array[6]); //set b6 bit
    spi.write(b7_array[5]); //set b5 bit
    spi.write(b7_array[4]); //set b4 bit
    spi.write(b7_array[3]); //set b3 bit
    spi.write(b7_array[2]); //set b2 bit
    spi.write(b7_array[1]); //set b1 bit 
    spi.write(b7_array[0]); //set b0 bit
    //wait for latch
    wait_us(60);   
}
 
void setRGBPixels2(int colours[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    int r0_array[8]; //LED0
    int g0_array[8];
    int b0_array[8];
    memcpy(r0_array, decimalToBinary(colours[0][0]), sizeof(r0_array));
    memcpy(g0_array, decimalToBinary(colours[0][1]), sizeof(g0_array));
    memcpy(b0_array, decimalToBinary(colours[0][2]), sizeof(b0_array));
    int r1_array[8]; //LED1
    int g1_array[8];
    int b1_array[8];
    memcpy(r1_array, decimalToBinary(colours[1][0]), sizeof(r1_array));
    memcpy(g1_array, decimalToBinary(colours[1][1]), sizeof(g1_array));
    memcpy(b1_array, decimalToBinary(colours[1][2]), sizeof(b1_array));
    int r2_array[8]; //LED2
    int g2_array[8];
    int b2_array[8];
    memcpy(r2_array, decimalToBinary(colours[2][0]), sizeof(r2_array));
    memcpy(g2_array, decimalToBinary(colours[2][1]), sizeof(g2_array));
    memcpy(b2_array, decimalToBinary(colours[2][2]), sizeof(b2_array));
    int r3_array[8]; //LED3
    int g3_array[8];
    int b3_array[8];
    memcpy(r3_array, decimalToBinary(colours[3][0]), sizeof(r3_array));
    memcpy(g3_array, decimalToBinary(colours[3][1]), sizeof(g3_array));
    memcpy(b3_array, decimalToBinary(colours[3][2]), sizeof(b3_array));
    int r4_array[8]; //LED4
    int g4_array[8];
    int b4_array[8];
    memcpy(r4_array, decimalToBinary(colours[4][0]), sizeof(r4_array));
    memcpy(g4_array, decimalToBinary(colours[4][1]), sizeof(g4_array));
    memcpy(b4_array, decimalToBinary(colours[4][2]), sizeof(b4_array));
    int r5_array[8]; //LED5
    int g5_array[8];
    int b5_array[8];
    memcpy(r5_array, decimalToBinary(colours[5][0]), sizeof(r5_array));
    memcpy(g5_array, decimalToBinary(colours[5][1]), sizeof(g5_array));
    memcpy(b5_array, decimalToBinary(colours[5][2]), sizeof(b5_array));
    int r6_array[8]; //LED6
    int g6_array[8];
    int b6_array[8];
    memcpy(r6_array, decimalToBinary(colours[6][0]), sizeof(r6_array));
    memcpy(g6_array, decimalToBinary(colours[6][1]), sizeof(g6_array));
    memcpy(b6_array, decimalToBinary(colours[6][2]), sizeof(b6_array));
    int r7_array[8]; //LED7
    int g7_array[8];
    int b7_array[8];
    memcpy(r7_array, decimalToBinary(colours[7][0]), sizeof(r7_array));
    memcpy(g7_array, decimalToBinary(colours[7][1]), sizeof(g7_array));
    memcpy(b7_array, decimalToBinary(colours[7][2]), sizeof(b7_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //LED0
    //set green bits
    spi2.write(g0_array[7]); //set g7 bit
    spi2.write(g0_array[6]); //set g6 bit
    spi2.write(g0_array[5]); //set g5 bit
    spi2.write(g0_array[4]); //set g4 bit
    spi2.write(g0_array[3]); //set g3 bit
    spi2.write(g0_array[2]); //set g2 bit
    spi2.write(g0_array[1]); //set g1 bit 
    spi2.write(g0_array[0]);//set g0 bit
    //set red bits
    spi2.write(r0_array[7]);//set r7 bit
    spi2.write(r0_array[6]); //set r6 bit
    spi2.write(r0_array[5]); //set r5 bit
    spi2.write(r0_array[4]); //set r4 bit
    spi2.write(r0_array[3]); //set r3 bit
    spi2.write(r0_array[2]); //set r2 bit
    spi2.write(r0_array[1]); //set r1 bit 
    spi2.write(r0_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b0_array[7]); //set b7 bit
    spi2.write(b0_array[6]); //set b6 bit
    spi2.write(b0_array[5]); //set b5 bit
    spi2.write(b0_array[4]); //set b4 bit
    spi2.write(b0_array[3]); //set b3 bit
    spi2.write(b0_array[2]); //set b2 bit
    spi2.write(b0_array[1]); //set b1 bit 
    spi2.write(b0_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi2.write(g1_array[7]); //set g7 bit
    spi2.write(g1_array[6]); //set g6 bit
    spi2.write(g1_array[5]); //set g5 bit
    spi2.write(g1_array[4]); //set g4 bit
    spi2.write(g1_array[3]); //set g3 bit
    spi2.write(g1_array[2]); //set g2 bit
    spi2.write(g1_array[1]); //set g1 bit 
    spi2.write(g1_array[0]);//set g0 bit
    //set red bits
    spi2.write(r1_array[7]);//set r7 bit
    spi2.write(r1_array[6]); //set r6 bit
    spi2.write(r1_array[5]); //set r5 bit
    spi2.write(r1_array[4]); //set r4 bit
    spi2.write(r1_array[3]); //set r3 bit
    spi2.write(r1_array[2]); //set r2 bit
    spi2.write(r1_array[1]); //set r1 bit 
    spi2.write(r1_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b1_array[7]); //set b7 bit
    spi2.write(b1_array[6]); //set b6 bit
    spi2.write(b1_array[5]); //set b5 bit
    spi2.write(b1_array[4]); //set b4 bit
    spi2.write(b1_array[3]); //set b3 bit
    spi2.write(b1_array[2]); //set b2 bit
    spi2.write(b1_array[1]); //set b1 bit 
    spi2.write(b1_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi2.write(g2_array[7]); //set g7 bit
    spi2.write(g2_array[6]); //set g6 bit
    spi2.write(g2_array[5]); //set g5 bit
    spi2.write(g2_array[4]); //set g4 bit
    spi2.write(g2_array[3]); //set g3 bit
    spi2.write(g2_array[2]); //set g2 bit
    spi2.write(g2_array[1]); //set g1 bit 
    spi2.write(g2_array[0]);//set g0 bit
    //set red bits
    spi2.write(r2_array[7]);//set r7 bit
    spi2.write(r2_array[6]); //set r6 bit
    spi2.write(r2_array[5]); //set r5 bit
    spi2.write(r2_array[4]); //set r4 bit
    spi2.write(r2_array[3]); //set r3 bit
    spi2.write(r2_array[2]); //set r2 bit
    spi2.write(r2_array[1]); //set r1 bit 
    spi2.write(r2_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b2_array[7]); //set b7 bit
    spi2.write(b2_array[6]); //set b6 bit
    spi2.write(b2_array[5]); //set b5 bit
    spi2.write(b2_array[4]); //set b4 bit
    spi2.write(b2_array[3]); //set b3 bit
    spi2.write(b2_array[2]); //set b2 bit
    spi2.write(b2_array[1]); //set b1 bit 
    spi2.write(b2_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi2.write(g3_array[7]); //set g7 bit
    spi2.write(g3_array[6]); //set g6 bit
    spi2.write(g3_array[5]); //set g5 bit
    spi2.write(g3_array[4]); //set g4 bit
    spi2.write(g3_array[3]); //set g3 bit
    spi2.write(g3_array[2]); //set g2 bit
    spi2.write(g3_array[1]); //set g1 bit 
    spi2.write(g3_array[0]);//set g0 bit
    //set red bits
    spi2.write(r3_array[7]);//set r7 bit
    spi2.write(r3_array[6]); //set r6 bit
    spi2.write(r3_array[5]); //set r5 bit
    spi2.write(r3_array[4]); //set r4 bit
    spi2.write(r3_array[3]); //set r3 bit
    spi2.write(r3_array[2]); //set r2 bit
    spi2.write(r3_array[1]); //set r1 bit 
    spi2.write(r3_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b3_array[7]); //set b7 bit
    spi2.write(b3_array[6]); //set b6 bit
    spi2.write(b3_array[5]); //set b5 bit
    spi2.write(b3_array[4]); //set b4 bit
    spi2.write(b3_array[3]); //set b3 bit
    spi2.write(b3_array[2]); //set b2 bit
    spi2.write(b3_array[1]); //set b1 bit 
    spi2.write(b3_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi2.write(g4_array[7]); //set g7 bit
    spi2.write(g4_array[6]); //set g6 bit
    spi2.write(g4_array[5]); //set g5 bit
    spi2.write(g4_array[4]); //set g4 bit
    spi2.write(g4_array[3]); //set g3 bit
    spi2.write(g4_array[2]); //set g2 bit
    spi2.write(g4_array[1]); //set g1 bit 
    spi2.write(g4_array[0]);//set g0 bit
    //set red bits
    spi2.write(r4_array[7]);//set r7 bit
    spi2.write(r4_array[6]); //set r6 bit
    spi2.write(r4_array[5]); //set r5 bit
    spi2.write(r4_array[4]); //set r4 bit
    spi2.write(r4_array[3]); //set r3 bit
    spi2.write(r4_array[2]); //set r2 bit
    spi2.write(r4_array[1]); //set r1 bit 
    spi2.write(r4_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b4_array[7]); //set b7 bit
    spi2.write(b4_array[6]); //set b6 bit
    spi2.write(b4_array[5]); //set b5 bit
    spi2.write(b4_array[4]); //set b4 bit
    spi2.write(b4_array[3]); //set b3 bit
    spi2.write(b4_array[2]); //set b2 bit
    spi2.write(b4_array[1]); //set b1 bit 
    spi2.write(b4_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi2.write(g5_array[7]); //set g7 bit
    spi2.write(g5_array[6]); //set g6 bit
    spi2.write(g5_array[5]); //set g5 bit
    spi2.write(g5_array[4]); //set g4 bit
    spi2.write(g5_array[3]); //set g3 bit
    spi2.write(g5_array[2]); //set g2 bit
    spi2.write(g5_array[1]); //set g1 bit 
    spi2.write(g5_array[0]);//set g0 bit
    //set red bits
    spi2.write(r5_array[7]);//set r7 bit
    spi2.write(r5_array[6]); //set r6 bit
    spi2.write(r5_array[5]); //set r5 bit
    spi2.write(r5_array[4]); //set r4 bit
    spi2.write(r5_array[3]); //set r3 bit
    spi2.write(r5_array[2]); //set r2 bit
    spi2.write(r5_array[1]); //set r1 bit 
    spi2.write(r5_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b5_array[7]); //set b7 bit
    spi2.write(b5_array[6]); //set b6 bit
    spi2.write(b5_array[5]); //set b5 bit
    spi2.write(b5_array[4]); //set b4 bit
    spi2.write(b5_array[3]); //set b3 bit
    spi2.write(b5_array[2]); //set b2 bit
    spi2.write(b5_array[1]); //set b1 bit 
    spi2.write(b5_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi2.write(g6_array[7]); //set g7 bit
    spi2.write(g6_array[6]); //set g6 bit
    spi2.write(g6_array[5]); //set g5 bit
    spi2.write(g6_array[4]); //set g4 bit
    spi2.write(g6_array[3]); //set g3 bit
    spi2.write(g6_array[2]); //set g2 bit
    spi2.write(g6_array[1]); //set g1 bit 
    spi2.write(g6_array[0]);//set g0 bit
    //set red bits
    spi2.write(r6_array[7]);//set r7 bit
    spi2.write(r6_array[6]); //set r6 bit
    spi2.write(r6_array[5]); //set r5 bit
    spi2.write(r6_array[4]); //set r4 bit
    spi2.write(r6_array[3]); //set r3 bit
    spi2.write(r6_array[2]); //set r2 bit
    spi2.write(r6_array[1]); //set r1 bit 
    spi2.write(r6_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b6_array[7]); //set b7 bit
    spi2.write(b6_array[6]); //set b6 bit
    spi2.write(b6_array[5]); //set b5 bit
    spi2.write(b6_array[4]); //set b4 bit
    spi2.write(b6_array[3]); //set b3 bit
    spi2.write(b6_array[2]); //set b2 bit
    spi2.write(b6_array[1]); //set b1 bit 
    spi2.write(b6_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi2.write(g7_array[7]); //set g7 bit
    spi2.write(g7_array[6]); //set g6 bit
    spi2.write(g7_array[5]); //set g5 bit
    spi2.write(g7_array[4]); //set g4 bit
    spi2.write(g7_array[3]); //set g3 bit
    spi2.write(g7_array[2]); //set g2 bit
    spi2.write(g7_array[1]); //set g1 bit 
    spi2.write(g7_array[0]);//set g0 bit
    //set red bits
    spi2.write(r7_array[7]);//set r7 bit
    spi2.write(r7_array[6]); //set r6 bit
    spi2.write(r7_array[5]); //set r5 bit
    spi2.write(r7_array[4]); //set r4 bit
    spi2.write(r7_array[3]); //set r3 bit
    spi2.write(r7_array[2]); //set r2 bit
    spi2.write(r7_array[1]); //set r1 bit 
    spi2.write(r7_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b7_array[7]); //set b7 bit
    spi2.write(b7_array[6]); //set b6 bit
    spi2.write(b7_array[5]); //set b5 bit
    spi2.write(b7_array[4]); //set b4 bit
    spi2.write(b7_array[3]); //set b3 bit
    spi2.write(b7_array[2]); //set b2 bit
    spi2.write(b7_array[1]); //set b1 bit 
    spi2.write(b7_array[0]); //set b0 bit
    //wait for latch
    wait_us(60);   
}
/*
void setRGBFloor_1(int room1[8][3], int room2[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    //room1
    int r00_array[8]; //LED0
    int g00_array[8];
    int b00_array[8];
    memcpy(r00_array, decimalToBinary(room1[0][0]), sizeof(r00_array));
    memcpy(g00_array, decimalToBinary(room1[0][1]), sizeof(g00_array));
    memcpy(b00_array, decimalToBinary(room1[0][2]), sizeof(b00_array));
    int r01_array[8]; //LED1
    int g01_array[8];
    int b01_array[8];
    memcpy(r01_array, decimalToBinary(room1[1][0]), sizeof(r01_array));
    memcpy(g01_array, decimalToBinary(room1[1][1]), sizeof(g01_array));
    memcpy(b01_array, decimalToBinary(room1[1][2]), sizeof(b01_array));
    int r02_array[8]; //LED2
    int g02_array[8];
    int b02_array[8];
    memcpy(r02_array, decimalToBinary(room1[2][0]), sizeof(r02_array));
    memcpy(g02_array, decimalToBinary(room1[2][1]), sizeof(g02_array));
    memcpy(b02_array, decimalToBinary(room1[2][2]), sizeof(b02_array));
    int r03_array[8]; //LED3
    int g03_array[8];
    int b03_array[8];
    memcpy(r03_array, decimalToBinary(room1[3][0]), sizeof(r03_array));
    memcpy(g03_array, decimalToBinary(room1[3][1]), sizeof(g03_array));
    memcpy(b03_array, decimalToBinary(room1[3][2]), sizeof(b03_array));
    int r04_array[8]; //LED4
    int g04_array[8];
    int b04_array[8];
    memcpy(r04_array, decimalToBinary(room1[4][0]), sizeof(r04_array));
    memcpy(g04_array, decimalToBinary(room1[4][1]), sizeof(g04_array));
    memcpy(b04_array, decimalToBinary(room1[4][2]), sizeof(b04_array));
    int r05_array[8]; //LED5
    int g05_array[8];
    int b05_array[8];
    memcpy(r05_array, decimalToBinary(room1[5][0]), sizeof(r05_array));
    memcpy(g05_array, decimalToBinary(room1[5][1]), sizeof(g05_array));
    memcpy(b05_array, decimalToBinary(room1[5][2]), sizeof(b05_array));
    int r06_array[8]; //LED6
    int g06_array[8];
    int b06_array[8];
    memcpy(r06_array, decimalToBinary(room1[6][0]), sizeof(r06_array));
    memcpy(g06_array, decimalToBinary(room1[6][1]), sizeof(g06_array));
    memcpy(b06_array, decimalToBinary(room1[6][2]), sizeof(b06_array));
    int r07_array[8]; //LED7
    int g07_array[8];
    int b07_array[8];
    memcpy(r07_array, decimalToBinary(room1[7][0]), sizeof(r07_array));
    memcpy(g07_array, decimalToBinary(room1[7][1]), sizeof(g07_array));
    memcpy(b07_array, decimalToBinary(room1[7][2]), sizeof(b07_array));
    
    //room2
    int r10_array[8]; //LED0
    int g10_array[8];
    int b10_array[8];
    memcpy(r10_array, decimalToBinary(room2[0][0]), sizeof(r10_array));
    memcpy(g10_array, decimalToBinary(room2[0][1]), sizeof(g10_array));
    memcpy(b10_array, decimalToBinary(room2[0][2]), sizeof(b10_array));
    int r11_array[8]; //LED1
    int g11_array[8];
    int b11_array[8];
    memcpy(r11_array, decimalToBinary(room2[1][0]), sizeof(r11_array));
    memcpy(g11_array, decimalToBinary(room2[1][1]), sizeof(g11_array));
    memcpy(b11_array, decimalToBinary(room2[1][2]), sizeof(b11_array));
    int r12_array[8]; //LED2
    int g12_array[8];
    int b12_array[8];
    memcpy(r12_array, decimalToBinary(room2[2][0]), sizeof(r12_array));
    memcpy(g12_array, decimalToBinary(room2[2][1]), sizeof(g12_array));
    memcpy(b12_array, decimalToBinary(room2[2][2]), sizeof(b12_array));
    int r13_array[8]; //LED3
    int g13_array[8];
    int b13_array[8];
    memcpy(r13_array, decimalToBinary(room2[3][0]), sizeof(r13_array));
    memcpy(g13_array, decimalToBinary(room2[3][1]), sizeof(g13_array));
    memcpy(b13_array, decimalToBinary(room2[3][2]), sizeof(b13_array));
    int r14_array[8]; //LED4
    int g14_array[8];
    int b14_array[8];
    memcpy(r14_array, decimalToBinary(room2[4][0]), sizeof(r14_array));
    memcpy(g14_array, decimalToBinary(room2[4][1]), sizeof(g14_array));
    memcpy(b14_array, decimalToBinary(room2[4][2]), sizeof(b14_array));
    int r15_array[8]; //LED5
    int g15_array[8];
    int b15_array[8];
    memcpy(r15_array, decimalToBinary(room2[5][0]), sizeof(r15_array));
    memcpy(g15_array, decimalToBinary(room2[5][1]), sizeof(g15_array));
    memcpy(b15_array, decimalToBinary(room2[5][2]), sizeof(b15_array));
    int r16_array[8]; //LED6
    int g16_array[8];
    int b16_array[8];
    memcpy(r16_array, decimalToBinary(room2[6][0]), sizeof(r16_array));
    memcpy(g16_array, decimalToBinary(room2[6][1]), sizeof(g16_array));
    memcpy(b16_array, decimalToBinary(room2[6][2]), sizeof(b16_array));
    int r17_array[8]; //LED7
    int g17_array[8];
    int b17_array[8];
    memcpy(r17_array, decimalToBinary(room2[7][0]), sizeof(r17_array));
    memcpy(g17_array, decimalToBinary(room2[7][1]), sizeof(g17_array));
    memcpy(b17_array, decimalToBinary(room2[7][2]), sizeof(b17_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //room1
    //LED0
    //set green bits
    spi.write(g00_array[7]); //set g7 bit
    spi.write(g00_array[6]); //set g6 bit
    spi.write(g00_array[5]); //set g5 bit
    spi.write(g00_array[4]); //set g4 bit
    spi.write(g00_array[3]); //set g3 bit
    spi.write(g00_array[2]); //set g2 bit
    spi.write(g00_array[1]); //set g1 bit 
    spi.write(g00_array[0]);//set g0 bit
    //set red bits
    spi.write(r00_array[7]);//set r7 bit
    spi.write(r00_array[6]); //set r6 bit
    spi.write(r00_array[5]); //set r5 bit
    spi.write(r00_array[4]); //set r4 bit
    spi.write(r00_array[3]); //set r3 bit
    spi.write(r00_array[2]); //set r2 bit
    spi.write(r00_array[1]); //set r1 bit 
    spi.write(r00_array[0]); //set r0 bit
    //set blue bits
    spi.write(b00_array[7]); //set b7 bit
    spi.write(b00_array[6]); //set b6 bit
    spi.write(b00_array[5]); //set b5 bit
    spi.write(b00_array[4]); //set b4 bit
    spi.write(b00_array[3]); //set b3 bit
    spi.write(b00_array[2]); //set b2 bit
    spi.write(b00_array[1]); //set b1 bit 
    spi.write(b00_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi.write(g01_array[7]); //set g7 bit
    spi.write(g01_array[6]); //set g6 bit
    spi.write(g01_array[5]); //set g5 bit
    spi.write(g01_array[4]); //set g4 bit
    spi.write(g01_array[3]); //set g3 bit
    spi.write(g01_array[2]); //set g2 bit
    spi.write(g01_array[1]); //set g1 bit 
    spi.write(g01_array[0]);//set g0 bit
    //set red bits
    spi.write(r01_array[7]);//set r7 bit
    spi.write(r01_array[6]); //set r6 bit
    spi.write(r01_array[5]); //set r5 bit
    spi.write(r01_array[4]); //set r4 bit
    spi.write(r01_array[3]); //set r3 bit
    spi.write(r01_array[2]); //set r2 bit
    spi.write(r01_array[1]); //set r1 bit 
    spi.write(r01_array[0]); //set r0 bit
    //set blue bits
    spi.write(b01_array[7]); //set b7 bit
    spi.write(b01_array[6]); //set b6 bit
    spi.write(b01_array[5]); //set b5 bit
    spi.write(b01_array[4]); //set b4 bit
    spi.write(b01_array[3]); //set b3 bit
    spi.write(b01_array[2]); //set b2 bit
    spi.write(b01_array[1]); //set b1 bit 
    spi.write(b01_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi.write(g02_array[7]); //set g7 bit
    spi.write(g02_array[6]); //set g6 bit
    spi.write(g02_array[5]); //set g5 bit
    spi.write(g02_array[4]); //set g4 bit
    spi.write(g02_array[3]); //set g3 bit
    spi.write(g02_array[2]); //set g2 bit
    spi.write(g02_array[1]); //set g1 bit 
    spi.write(g02_array[0]);//set g0 bit
    //set red bits
    spi.write(r02_array[7]);//set r7 bit
    spi.write(r02_array[6]); //set r6 bit
    spi.write(r02_array[5]); //set r5 bit
    spi.write(r02_array[4]); //set r4 bit
    spi.write(r02_array[3]); //set r3 bit
    spi.write(r02_array[2]); //set r2 bit
    spi.write(r02_array[1]); //set r1 bit 
    spi.write(r02_array[0]); //set r0 bit
    //set blue bits
    spi.write(b02_array[7]); //set b7 bit
    spi.write(b02_array[6]); //set b6 bit
    spi.write(b02_array[5]); //set b5 bit
    spi.write(b02_array[4]); //set b4 bit
    spi.write(b02_array[3]); //set b3 bit
    spi.write(b02_array[2]); //set b2 bit
    spi.write(b02_array[1]); //set b1 bit 
    spi.write(b02_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi.write(g03_array[7]); //set g7 bit
    spi.write(g03_array[6]); //set g6 bit
    spi.write(g03_array[5]); //set g5 bit
    spi.write(g03_array[4]); //set g4 bit
    spi.write(g03_array[3]); //set g3 bit
    spi.write(g03_array[2]); //set g2 bit
    spi.write(g03_array[1]); //set g1 bit 
    spi.write(g03_array[0]);//set g0 bit
    //set red bits
    spi.write(r03_array[7]);//set r7 bit
    spi.write(r03_array[6]); //set r6 bit
    spi.write(r03_array[5]); //set r5 bit
    spi.write(r03_array[4]); //set r4 bit
    spi.write(r03_array[3]); //set r3 bit
    spi.write(r03_array[2]); //set r2 bit
    spi.write(r03_array[1]); //set r1 bit 
    spi.write(r03_array[0]); //set r0 bit
    //set blue bits
    spi.write(b03_array[7]); //set b7 bit
    spi.write(b03_array[6]); //set b6 bit
    spi.write(b03_array[5]); //set b5 bit
    spi.write(b03_array[4]); //set b4 bit
    spi.write(b03_array[3]); //set b3 bit
    spi.write(b03_array[2]); //set b2 bit
    spi.write(b03_array[1]); //set b1 bit 
    spi.write(b03_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi.write(g04_array[7]); //set g7 bit
    spi.write(g04_array[6]); //set g6 bit
    spi.write(g04_array[5]); //set g5 bit
    spi.write(g04_array[4]); //set g4 bit
    spi.write(g04_array[3]); //set g3 bit
    spi.write(g04_array[2]); //set g2 bit
    spi.write(g04_array[1]); //set g1 bit 
    spi.write(g04_array[0]);//set g0 bit
    //set red bits
    spi.write(r04_array[7]);//set r7 bit
    spi.write(r04_array[6]); //set r6 bit
    spi.write(r04_array[5]); //set r5 bit
    spi.write(r04_array[4]); //set r4 bit
    spi.write(r04_array[3]); //set r3 bit
    spi.write(r04_array[2]); //set r2 bit
    spi.write(r04_array[1]); //set r1 bit 
    spi.write(r04_array[0]); //set r0 bit
    //set blue bits
    spi.write(b04_array[7]); //set b7 bit
    spi.write(b04_array[6]); //set b6 bit
    spi.write(b04_array[5]); //set b5 bit
    spi.write(b04_array[4]); //set b4 bit
    spi.write(b04_array[3]); //set b3 bit
    spi.write(b04_array[2]); //set b2 bit
    spi.write(b04_array[1]); //set b1 bit 
    spi.write(b04_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi.write(g05_array[7]); //set g7 bit
    spi.write(g05_array[6]); //set g6 bit
    spi.write(g05_array[5]); //set g5 bit
    spi.write(g05_array[4]); //set g4 bit
    spi.write(g05_array[3]); //set g3 bit
    spi.write(g05_array[2]); //set g2 bit
    spi.write(g05_array[1]); //set g1 bit 
    spi.write(g05_array[0]);//set g0 bit
    //set red bits
    spi.write(r05_array[7]);//set r7 bit
    spi.write(r05_array[6]); //set r6 bit
    spi.write(r05_array[5]); //set r5 bit
    spi.write(r05_array[4]); //set r4 bit
    spi.write(r05_array[3]); //set r3 bit
    spi.write(r05_array[2]); //set r2 bit
    spi.write(r05_array[1]); //set r1 bit 
    spi.write(r05_array[0]); //set r0 bit
    //set blue bits
    spi.write(b05_array[7]); //set b7 bit
    spi.write(b05_array[6]); //set b6 bit
    spi.write(b05_array[5]); //set b5 bit
    spi.write(b05_array[4]); //set b4 bit
    spi.write(b05_array[3]); //set b3 bit
    spi.write(b05_array[2]); //set b2 bit
    spi.write(b05_array[1]); //set b1 bit 
    spi.write(b05_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi.write(g06_array[7]); //set g7 bit
    spi.write(g06_array[6]); //set g6 bit
    spi.write(g06_array[5]); //set g5 bit
    spi.write(g06_array[4]); //set g4 bit
    spi.write(g06_array[3]); //set g3 bit
    spi.write(g06_array[2]); //set g2 bit
    spi.write(g06_array[1]); //set g1 bit 
    spi.write(g06_array[0]);//set g0 bit
    //set red bits
    spi.write(r06_array[7]);//set r7 bit
    spi.write(r06_array[6]); //set r6 bit
    spi.write(r06_array[5]); //set r5 bit
    spi.write(r06_array[4]); //set r4 bit
    spi.write(r06_array[3]); //set r3 bit
    spi.write(r06_array[2]); //set r2 bit
    spi.write(r06_array[1]); //set r1 bit 
    spi.write(r06_array[0]); //set r0 bit
    //set blue bits
    spi.write(b06_array[7]); //set b7 bit
    spi.write(b06_array[6]); //set b6 bit
    spi.write(b06_array[5]); //set b5 bit
    spi.write(b06_array[4]); //set b4 bit
    spi.write(b06_array[3]); //set b3 bit
    spi.write(b06_array[2]); //set b2 bit
    spi.write(b06_array[1]); //set b1 bit 
    spi.write(b06_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi.write(g07_array[7]); //set g7 bit
    spi.write(g07_array[6]); //set g6 bit
    spi.write(g07_array[5]); //set g5 bit
    spi.write(g07_array[4]); //set g4 bit
    spi.write(g07_array[3]); //set g3 bit
    spi.write(g07_array[2]); //set g2 bit
    spi.write(g07_array[1]); //set g1 bit 
    spi.write(g07_array[0]);//set g0 bit
    //set red bits
    spi.write(r07_array[7]);//set r7 bit
    spi.write(r07_array[6]); //set r6 bit
    spi.write(r07_array[5]); //set r5 bit
    spi.write(r07_array[4]); //set r4 bit
    spi.write(r07_array[3]); //set r3 bit
    spi.write(r07_array[2]); //set r2 bit
    spi.write(r07_array[1]); //set r1 bit 
    spi.write(r07_array[0]); //set r0 bit
    //set blue bits
    spi.write(b07_array[7]); //set b7 bit
    spi.write(b07_array[6]); //set b6 bit
    spi.write(b07_array[5]); //set b5 bit
    spi.write(b07_array[4]); //set b4 bit
    spi.write(b07_array[3]); //set b3 bit
    spi.write(b07_array[2]); //set b2 bit
    spi.write(b07_array[1]); //set b1 bit 
    spi.write(b07_array[0]); //set b0 bit
    //room2
    //LED0
    //set green bits
    spi.write(g10_array[7]); //set g7 bit
    spi.write(g10_array[6]); //set g6 bit
    spi.write(g10_array[5]); //set g5 bit
    spi.write(g10_array[4]); //set g4 bit
    spi.write(g10_array[3]); //set g3 bit
    spi.write(g10_array[2]); //set g2 bit
    spi.write(g10_array[1]); //set g1 bit 
    spi.write(g10_array[0]);//set g0 bit
    //set red bits
    spi.write(r10_array[7]);//set r7 bit
    spi.write(r10_array[6]); //set r6 bit
    spi.write(r10_array[5]); //set r5 bit
    spi.write(r10_array[4]); //set r4 bit
    spi.write(r10_array[3]); //set r3 bit
    spi.write(r10_array[2]); //set r2 bit
    spi.write(r10_array[1]); //set r1 bit 
    spi.write(r10_array[0]); //set r0 bit
    //set blue bits
    spi.write(b10_array[7]); //set b7 bit
    spi.write(b10_array[6]); //set b6 bit
    spi.write(b10_array[5]); //set b5 bit
    spi.write(b10_array[4]); //set b4 bit
    spi.write(b10_array[3]); //set b3 bit
    spi.write(b10_array[2]); //set b2 bit
    spi.write(b10_array[1]); //set b1 bit 
    spi.write(b10_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi.write(g11_array[7]); //set g7 bit
    spi.write(g11_array[6]); //set g6 bit
    spi.write(g11_array[5]); //set g5 bit
    spi.write(g11_array[4]); //set g4 bit
    spi.write(g11_array[3]); //set g3 bit
    spi.write(g11_array[2]); //set g2 bit
    spi.write(g11_array[1]); //set g1 bit 
    spi.write(g11_array[0]);//set g0 bit
    //set red bits
    spi.write(r11_array[7]);//set r7 bit
    spi.write(r11_array[6]); //set r6 bit
    spi.write(r11_array[5]); //set r5 bit
    spi.write(r11_array[4]); //set r4 bit
    spi.write(r11_array[3]); //set r3 bit
    spi.write(r11_array[2]); //set r2 bit
    spi.write(r11_array[1]); //set r1 bit 
    spi.write(r11_array[0]); //set r0 bit
    //set blue bits
    spi.write(b11_array[7]); //set b7 bit
    spi.write(b11_array[6]); //set b6 bit
    spi.write(b11_array[5]); //set b5 bit
    spi.write(b11_array[4]); //set b4 bit
    spi.write(b11_array[3]); //set b3 bit
    spi.write(b11_array[2]); //set b2 bit
    spi.write(b11_array[1]); //set b1 bit 
    spi.write(b11_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi.write(g12_array[7]); //set g7 bit
    spi.write(g12_array[6]); //set g6 bit
    spi.write(g12_array[5]); //set g5 bit
    spi.write(g12_array[4]); //set g4 bit
    spi.write(g12_array[3]); //set g3 bit
    spi.write(g12_array[2]); //set g2 bit
    spi.write(g12_array[1]); //set g1 bit 
    spi.write(g12_array[0]);//set g0 bit
    //set red bits
    spi.write(r12_array[7]);//set r7 bit
    spi.write(r12_array[6]); //set r6 bit
    spi.write(r12_array[5]); //set r5 bit
    spi.write(r12_array[4]); //set r4 bit
    spi.write(r12_array[3]); //set r3 bit
    spi.write(r12_array[2]); //set r2 bit
    spi.write(r12_array[1]); //set r1 bit 
    spi.write(r12_array[0]); //set r0 bit
    //set blue bits
    spi.write(b12_array[7]); //set b7 bit
    spi.write(b12_array[6]); //set b6 bit
    spi.write(b12_array[5]); //set b5 bit
    spi.write(b12_array[4]); //set b4 bit
    spi.write(b12_array[3]); //set b3 bit
    spi.write(b12_array[2]); //set b2 bit
    spi.write(b12_array[1]); //set b1 bit 
    spi.write(b12_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi.write(g13_array[7]); //set g7 bit
    spi.write(g13_array[6]); //set g6 bit
    spi.write(g13_array[5]); //set g5 bit
    spi.write(g13_array[4]); //set g4 bit
    spi.write(g13_array[3]); //set g3 bit
    spi.write(g13_array[2]); //set g2 bit
    spi.write(g13_array[1]); //set g1 bit 
    spi.write(g13_array[0]);//set g0 bit
    //set red bits
    spi.write(r13_array[7]);//set r7 bit
    spi.write(r13_array[6]); //set r6 bit
    spi.write(r13_array[5]); //set r5 bit
    spi.write(r13_array[4]); //set r4 bit
    spi.write(r13_array[3]); //set r3 bit
    spi.write(r13_array[2]); //set r2 bit
    spi.write(r13_array[1]); //set r1 bit 
    spi.write(r13_array[0]); //set r0 bit
    //set blue bits
    spi.write(b13_array[7]); //set b7 bit
    spi.write(b13_array[6]); //set b6 bit
    spi.write(b13_array[5]); //set b5 bit
    spi.write(b13_array[4]); //set b4 bit
    spi.write(b13_array[3]); //set b3 bit
    spi.write(b13_array[2]); //set b2 bit
    spi.write(b13_array[1]); //set b1 bit 
    spi.write(b13_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi.write(g14_array[7]); //set g7 bit
    spi.write(g14_array[6]); //set g6 bit
    spi.write(g14_array[5]); //set g5 bit
    spi.write(g14_array[4]); //set g4 bit
    spi.write(g14_array[3]); //set g3 bit
    spi.write(g14_array[2]); //set g2 bit
    spi.write(g14_array[1]); //set g1 bit 
    spi.write(g14_array[0]);//set g0 bit
    //set red bits
    spi.write(r14_array[7]);//set r7 bit
    spi.write(r14_array[6]); //set r6 bit
    spi.write(r14_array[5]); //set r5 bit
    spi.write(r14_array[4]); //set r4 bit
    spi.write(r14_array[3]); //set r3 bit
    spi.write(r14_array[2]); //set r2 bit
    spi.write(r14_array[1]); //set r1 bit 
    spi.write(r14_array[0]); //set r0 bit
    //set blue bits
    spi.write(b14_array[7]); //set b7 bit
    spi.write(b14_array[6]); //set b6 bit
    spi.write(b14_array[5]); //set b5 bit
    spi.write(b14_array[4]); //set b4 bit
    spi.write(b14_array[3]); //set b3 bit
    spi.write(b14_array[2]); //set b2 bit
    spi.write(b14_array[1]); //set b1 bit 
    spi.write(b14_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi.write(g15_array[7]); //set g7 bit
    spi.write(g15_array[6]); //set g6 bit
    spi.write(g15_array[5]); //set g5 bit
    spi.write(g15_array[4]); //set g4 bit
    spi.write(g15_array[3]); //set g3 bit
    spi.write(g15_array[2]); //set g2 bit
    spi.write(g15_array[1]); //set g1 bit 
    spi.write(g15_array[0]);//set g0 bit
    //set red bits
    spi.write(r15_array[7]);//set r7 bit
    spi.write(r15_array[6]); //set r6 bit
    spi.write(r15_array[5]); //set r5 bit
    spi.write(r15_array[4]); //set r4 bit
    spi.write(r15_array[3]); //set r3 bit
    spi.write(r15_array[2]); //set r2 bit
    spi.write(r15_array[1]); //set r1 bit 
    spi.write(r15_array[0]); //set r0 bit
    //set blue bits
    spi.write(b15_array[7]); //set b7 bit
    spi.write(b15_array[6]); //set b6 bit
    spi.write(b15_array[5]); //set b5 bit
    spi.write(b15_array[4]); //set b4 bit
    spi.write(b15_array[3]); //set b3 bit
    spi.write(b15_array[2]); //set b2 bit
    spi.write(b15_array[1]); //set b1 bit 
    spi.write(b15_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi.write(g16_array[7]); //set g7 bit
    spi.write(g16_array[6]); //set g6 bit
    spi.write(g16_array[5]); //set g5 bit
    spi.write(g16_array[4]); //set g4 bit
    spi.write(g16_array[3]); //set g3 bit
    spi.write(g16_array[2]); //set g2 bit
    spi.write(g16_array[1]); //set g1 bit 
    spi.write(g16_array[0]);//set g0 bit
    //set red bits
    spi.write(r16_array[7]);//set r7 bit
    spi.write(r16_array[6]); //set r6 bit
    spi.write(r16_array[5]); //set r5 bit
    spi.write(r16_array[4]); //set r4 bit
    spi.write(r16_array[3]); //set r3 bit
    spi.write(r16_array[2]); //set r2 bit
    spi.write(r16_array[1]); //set r1 bit 
    spi.write(r16_array[0]); //set r0 bit
    //set blue bits
    spi.write(b16_array[7]); //set b7 bit
    spi.write(b16_array[6]); //set b6 bit
    spi.write(b16_array[5]); //set b5 bit
    spi.write(b16_array[4]); //set b4 bit
    spi.write(b16_array[3]); //set b3 bit
    spi.write(b16_array[2]); //set b2 bit
    spi.write(b16_array[1]); //set b1 bit 
    spi.write(b16_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi.write(g17_array[7]); //set g7 bit
    spi.write(g17_array[6]); //set g6 bit
    spi.write(g17_array[5]); //set g5 bit
    spi.write(g17_array[4]); //set g4 bit
    spi.write(g17_array[3]); //set g3 bit
    spi.write(g17_array[2]); //set g2 bit
    spi.write(g17_array[1]); //set g1 bit 
    spi.write(g17_array[0]);//set g0 bit
    //set red bits
    spi.write(r17_array[7]);//set r7 bit
    spi.write(r17_array[6]); //set r6 bit
    spi.write(r17_array[5]); //set r5 bit
    spi.write(r17_array[4]); //set r4 bit
    spi.write(r17_array[3]); //set r3 bit
    spi.write(r17_array[2]); //set r2 bit
    spi.write(r17_array[1]); //set r1 bit 
    spi.write(r17_array[0]); //set r0 bit
    //set blue bits
    spi.write(b17_array[7]); //set b7 bit
    spi.write(b17_array[6]); //set b6 bit
    spi.write(b17_array[5]); //set b5 bit
    spi.write(b17_array[4]); //set b4 bit
    spi.write(b17_array[3]); //set b3 bit
    spi.write(b17_array[2]); //set b2 bit
    spi.write(b17_array[1]); //set b1 bit 
    spi.write(b17_array[0]); //set b0 bit
    
    //wait for latch
    wait_us(60);   
}
 
void setRGBFloor_2(int room3[8][3], int room4[8][3]){
    //translate int values to array of 0xF00 (0) and 0xFF0 (1) binary 
    //room3
    int r00_array[8]; //LED0
    int g00_array[8];
    int b00_array[8];
    memcpy(r00_array, decimalToBinary(room3[0][0]), sizeof(r00_array));
    memcpy(g00_array, decimalToBinary(room3[0][1]), sizeof(g00_array));
    memcpy(b00_array, decimalToBinary(room3[0][2]), sizeof(b00_array));
    int r01_array[8]; //LED1
    int g01_array[8];
    int b01_array[8];
    memcpy(r01_array, decimalToBinary(room3[1][0]), sizeof(r01_array));
    memcpy(g01_array, decimalToBinary(room3[1][1]), sizeof(g01_array));
    memcpy(b01_array, decimalToBinary(room3[1][2]), sizeof(b01_array));
    int r02_array[8]; //LED2
    int g02_array[8];
    int b02_array[8];
    memcpy(r02_array, decimalToBinary(room3[2][0]), sizeof(r02_array));
    memcpy(g02_array, decimalToBinary(room3[2][1]), sizeof(g02_array));
    memcpy(b02_array, decimalToBinary(room3[2][2]), sizeof(b02_array));
    int r03_array[8]; //LED3
    int g03_array[8];
    int b03_array[8];
    memcpy(r03_array, decimalToBinary(room3[3][0]), sizeof(r03_array));
    memcpy(g03_array, decimalToBinary(room3[3][1]), sizeof(g03_array));
    memcpy(b03_array, decimalToBinary(room3[3][2]), sizeof(b03_array));
    int r04_array[8]; //LED4
    int g04_array[8];
    int b04_array[8];
    memcpy(r04_array, decimalToBinary(room3[4][0]), sizeof(r04_array));
    memcpy(g04_array, decimalToBinary(room3[4][1]), sizeof(g04_array));
    memcpy(b04_array, decimalToBinary(room3[4][2]), sizeof(b04_array));
    int r05_array[8]; //LED5
    int g05_array[8];
    int b05_array[8];
    memcpy(r05_array, decimalToBinary(room3[5][0]), sizeof(r05_array));
    memcpy(g05_array, decimalToBinary(room3[5][1]), sizeof(g05_array));
    memcpy(b05_array, decimalToBinary(room3[5][2]), sizeof(b05_array));
    int r06_array[8]; //LED6
    int g06_array[8];
    int b06_array[8];
    memcpy(r06_array, decimalToBinary(room3[6][0]), sizeof(r06_array));
    memcpy(g06_array, decimalToBinary(room3[6][1]), sizeof(g06_array));
    memcpy(b06_array, decimalToBinary(room3[6][2]), sizeof(b06_array));
    int r07_array[8]; //LED7
    int g07_array[8];
    int b07_array[8];
    memcpy(r07_array, decimalToBinary(room3[7][0]), sizeof(r07_array));
    memcpy(g07_array, decimalToBinary(room3[7][1]), sizeof(g07_array));
    memcpy(b07_array, decimalToBinary(room3[7][2]), sizeof(b07_array));
    
    //room4
    int r10_array[8]; //LED0
    int g10_array[8];
    int b10_array[8];
    memcpy(r10_array, decimalToBinary(room4[0][0]), sizeof(r10_array));
    memcpy(g10_array, decimalToBinary(room4[0][1]), sizeof(g10_array));
    memcpy(b10_array, decimalToBinary(room4[0][2]), sizeof(b10_array));
    int r11_array[8]; //LED1
    int g11_array[8];
    int b11_array[8];
    memcpy(r11_array, decimalToBinary(room4[1][0]), sizeof(r11_array));
    memcpy(g11_array, decimalToBinary(room4[1][1]), sizeof(g11_array));
    memcpy(b11_array, decimalToBinary(room4[1][2]), sizeof(b11_array));
    int r12_array[8]; //LED2
    int g12_array[8];
    int b12_array[8];
    memcpy(r12_array, decimalToBinary(room4[2][0]), sizeof(r12_array));
    memcpy(g12_array, decimalToBinary(room4[2][1]), sizeof(g12_array));
    memcpy(b12_array, decimalToBinary(room4[2][2]), sizeof(b12_array));
    int r13_array[8]; //LED3
    int g13_array[8];
    int b13_array[8];
    memcpy(r13_array, decimalToBinary(room4[3][0]), sizeof(r13_array));
    memcpy(g13_array, decimalToBinary(room4[3][1]), sizeof(g13_array));
    memcpy(b13_array, decimalToBinary(room4[3][2]), sizeof(b13_array));
    int r14_array[8]; //LED4
    int g14_array[8];
    int b14_array[8];
    memcpy(r14_array, decimalToBinary(room4[4][0]), sizeof(r14_array));
    memcpy(g14_array, decimalToBinary(room4[4][1]), sizeof(g14_array));
    memcpy(b14_array, decimalToBinary(room4[4][2]), sizeof(b14_array));
    int r15_array[8]; //LED5
    int g15_array[8];
    int b15_array[8];
    memcpy(r15_array, decimalToBinary(room4[5][0]), sizeof(r15_array));
    memcpy(g15_array, decimalToBinary(room4[5][1]), sizeof(g15_array));
    memcpy(b15_array, decimalToBinary(room4[5][2]), sizeof(b15_array));
    int r16_array[8]; //LED6
    int g16_array[8];
    int b16_array[8];
    memcpy(r16_array, decimalToBinary(room4[6][0]), sizeof(r16_array));
    memcpy(g16_array, decimalToBinary(room4[6][1]), sizeof(g16_array));
    memcpy(b16_array, decimalToBinary(room4[6][2]), sizeof(b16_array));
    int r17_array[8]; //LED7
    int g17_array[8];
    int b17_array[8];
    memcpy(r17_array, decimalToBinary(room4[7][0]), sizeof(r17_array));
    memcpy(g17_array, decimalToBinary(room4[7][1]), sizeof(g17_array));
    memcpy(b17_array, decimalToBinary(room4[7][2]), sizeof(b17_array));
    
    //send commands to LED Driver
     //initialize SPI
     spi_init();
    //room3
    //LED0
    //set green bits
    spi2.write(g00_array[7]); //set g7 bit
    spi2.write(g00_array[6]); //set g6 bit
    spi2.write(g00_array[5]); //set g5 bit
    spi2.write(g00_array[4]); //set g4 bit
    spi2.write(g00_array[3]); //set g3 bit
    spi2.write(g00_array[2]); //set g2 bit
    spi2.write(g00_array[1]); //set g1 bit 
    spi2.write(g00_array[0]);//set g0 bit
    //set red bits
    spi2.write(r00_array[7]);//set r7 bit
    spi2.write(r00_array[6]); //set r6 bit
    spi2.write(r00_array[5]); //set r5 bit
    spi2.write(r00_array[4]); //set r4 bit
    spi2.write(r00_array[3]); //set r3 bit
    spi2.write(r00_array[2]); //set r2 bit
    spi2.write(r00_array[1]); //set r1 bit 
    spi2.write(r00_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b00_array[7]); //set b7 bit
    spi2.write(b00_array[6]); //set b6 bit
    spi2.write(b00_array[5]); //set b5 bit
    spi2.write(b00_array[4]); //set b4 bit
    spi2.write(b00_array[3]); //set b3 bit
    spi2.write(b00_array[2]); //set b2 bit
    spi2.write(b00_array[1]); //set b1 bit 
    spi2.write(b00_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi2.write(g01_array[7]); //set g7 bit
    spi2.write(g01_array[6]); //set g6 bit
    spi2.write(g01_array[5]); //set g5 bit
    spi2.write(g01_array[4]); //set g4 bit
    spi2.write(g01_array[3]); //set g3 bit
    spi2.write(g01_array[2]); //set g2 bit
    spi2.write(g01_array[1]); //set g1 bit 
    spi2.write(g01_array[0]);//set g0 bit
    //set red bits
    spi2.write(r01_array[7]);//set r7 bit
    spi2.write(r01_array[6]); //set r6 bit
    spi2.write(r01_array[5]); //set r5 bit
    spi2.write(r01_array[4]); //set r4 bit
    spi2.write(r01_array[3]); //set r3 bit
    spi2.write(r01_array[2]); //set r2 bit
    spi2.write(r01_array[1]); //set r1 bit 
    spi2.write(r01_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b01_array[7]); //set b7 bit
    spi2.write(b01_array[6]); //set b6 bit
    spi2.write(b01_array[5]); //set b5 bit
    spi2.write(b01_array[4]); //set b4 bit
    spi2.write(b01_array[3]); //set b3 bit
    spi2.write(b01_array[2]); //set b2 bit
    spi2.write(b01_array[1]); //set b1 bit 
    spi2.write(b01_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi2.write(g02_array[7]); //set g7 bit
    spi2.write(g02_array[6]); //set g6 bit
    spi2.write(g02_array[5]); //set g5 bit
    spi2.write(g02_array[4]); //set g4 bit
    spi2.write(g02_array[3]); //set g3 bit
    spi2.write(g02_array[2]); //set g2 bit
    spi2.write(g02_array[1]); //set g1 bit 
    spi2.write(g02_array[0]);//set g0 bit
    //set red bits
    spi2.write(r02_array[7]);//set r7 bit
    spi2.write(r02_array[6]); //set r6 bit
    spi2.write(r02_array[5]); //set r5 bit
    spi2.write(r02_array[4]); //set r4 bit
    spi2.write(r02_array[3]); //set r3 bit
    spi2.write(r02_array[2]); //set r2 bit
    spi2.write(r02_array[1]); //set r1 bit 
    spi2.write(r02_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b02_array[7]); //set b7 bit
    spi2.write(b02_array[6]); //set b6 bit
    spi2.write(b02_array[5]); //set b5 bit
    spi2.write(b02_array[4]); //set b4 bit
    spi2.write(b02_array[3]); //set b3 bit
    spi2.write(b02_array[2]); //set b2 bit
    spi2.write(b02_array[1]); //set b1 bit 
    spi2.write(b02_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi2.write(g03_array[7]); //set g7 bit
    spi2.write(g03_array[6]); //set g6 bit
    spi2.write(g03_array[5]); //set g5 bit
    spi2.write(g03_array[4]); //set g4 bit
    spi2.write(g03_array[3]); //set g3 bit
    spi2.write(g03_array[2]); //set g2 bit
    spi2.write(g03_array[1]); //set g1 bit 
    spi2.write(g03_array[0]);//set g0 bit
    //set red bits
    spi2.write(r03_array[7]);//set r7 bit
    spi2.write(r03_array[6]); //set r6 bit
    spi2.write(r03_array[5]); //set r5 bit
    spi2.write(r03_array[4]); //set r4 bit
    spi2.write(r03_array[3]); //set r3 bit
    spi2.write(r03_array[2]); //set r2 bit
    spi2.write(r03_array[1]); //set r1 bit 
    spi2.write(r03_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b03_array[7]); //set b7 bit
    spi2.write(b03_array[6]); //set b6 bit
    spi2.write(b03_array[5]); //set b5 bit
    spi2.write(b03_array[4]); //set b4 bit
    spi2.write(b03_array[3]); //set b3 bit
    spi2.write(b03_array[2]); //set b2 bit
    spi2.write(b03_array[1]); //set b1 bit 
    spi2.write(b03_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi2.write(g04_array[7]); //set g7 bit
    spi2.write(g04_array[6]); //set g6 bit
    spi2.write(g04_array[5]); //set g5 bit
    spi2.write(g04_array[4]); //set g4 bit
    spi2.write(g04_array[3]); //set g3 bit
    spi2.write(g04_array[2]); //set g2 bit
    spi2.write(g04_array[1]); //set g1 bit 
    spi2.write(g04_array[0]);//set g0 bit
    //set red bits
    spi2.write(r04_array[7]);//set r7 bit
    spi2.write(r04_array[6]); //set r6 bit
    spi2.write(r04_array[5]); //set r5 bit
    spi2.write(r04_array[4]); //set r4 bit
    spi2.write(r04_array[3]); //set r3 bit
    spi2.write(r04_array[2]); //set r2 bit
    spi2.write(r04_array[1]); //set r1 bit 
    spi2.write(r04_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b04_array[7]); //set b7 bit
    spi2.write(b04_array[6]); //set b6 bit
    spi2.write(b04_array[5]); //set b5 bit
    spi2.write(b04_array[4]); //set b4 bit
    spi2.write(b04_array[3]); //set b3 bit
    spi2.write(b04_array[2]); //set b2 bit
    spi2.write(b04_array[1]); //set b1 bit 
    spi2.write(b04_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi2.write(g05_array[7]); //set g7 bit
    spi2.write(g05_array[6]); //set g6 bit
    spi2.write(g05_array[5]); //set g5 bit
    spi2.write(g05_array[4]); //set g4 bit
    spi2.write(g05_array[3]); //set g3 bit
    spi2.write(g05_array[2]); //set g2 bit
    spi2.write(g05_array[1]); //set g1 bit 
    spi2.write(g05_array[0]);//set g0 bit
    //set red bits
    spi2.write(r05_array[7]);//set r7 bit
    spi2.write(r05_array[6]); //set r6 bit
    spi2.write(r05_array[5]); //set r5 bit
    spi2.write(r05_array[4]); //set r4 bit
    spi2.write(r05_array[3]); //set r3 bit
    spi2.write(r05_array[2]); //set r2 bit
    spi2.write(r05_array[1]); //set r1 bit 
    spi2.write(r05_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b05_array[7]); //set b7 bit
    spi2.write(b05_array[6]); //set b6 bit
    spi2.write(b05_array[5]); //set b5 bit
    spi2.write(b05_array[4]); //set b4 bit
    spi2.write(b05_array[3]); //set b3 bit
    spi2.write(b05_array[2]); //set b2 bit
    spi2.write(b05_array[1]); //set b1 bit 
    spi2.write(b05_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi2.write(g06_array[7]); //set g7 bit
    spi2.write(g06_array[6]); //set g6 bit
    spi2.write(g06_array[5]); //set g5 bit
    spi2.write(g06_array[4]); //set g4 bit
    spi2.write(g06_array[3]); //set g3 bit
    spi2.write(g06_array[2]); //set g2 bit
    spi2.write(g06_array[1]); //set g1 bit 
    spi2.write(g06_array[0]);//set g0 bit
    //set red bits
    spi2.write(r06_array[7]);//set r7 bit
    spi2.write(r06_array[6]); //set r6 bit
    spi2.write(r06_array[5]); //set r5 bit
    spi2.write(r06_array[4]); //set r4 bit
    spi2.write(r06_array[3]); //set r3 bit
    spi2.write(r06_array[2]); //set r2 bit
    spi2.write(r06_array[1]); //set r1 bit 
    spi2.write(r06_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b06_array[7]); //set b7 bit
    spi2.write(b06_array[6]); //set b6 bit
    spi2.write(b06_array[5]); //set b5 bit
    spi2.write(b06_array[4]); //set b4 bit
    spi2.write(b06_array[3]); //set b3 bit
    spi2.write(b06_array[2]); //set b2 bit
    spi2.write(b06_array[1]); //set b1 bit 
    spi2.write(b06_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi2.write(g07_array[7]); //set g7 bit
    spi2.write(g07_array[6]); //set g6 bit
    spi2.write(g07_array[5]); //set g5 bit
    spi2.write(g07_array[4]); //set g4 bit
    spi2.write(g07_array[3]); //set g3 bit
    spi2.write(g07_array[2]); //set g2 bit
    spi2.write(g07_array[1]); //set g1 bit 
    spi2.write(g07_array[0]);//set g0 bit
    //set red bits
    spi2.write(r07_array[7]);//set r7 bit
    spi2.write(r07_array[6]); //set r6 bit
    spi2.write(r07_array[5]); //set r5 bit
    spi2.write(r07_array[4]); //set r4 bit
    spi2.write(r07_array[3]); //set r3 bit
    spi2.write(r07_array[2]); //set r2 bit
    spi2.write(r07_array[1]); //set r1 bit 
    spi2.write(r07_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b07_array[7]); //set b7 bit
    spi2.write(b07_array[6]); //set b6 bit
    spi2.write(b07_array[5]); //set b5 bit
    spi2.write(b07_array[4]); //set b4 bit
    spi2.write(b07_array[3]); //set b3 bit
    spi2.write(b07_array[2]); //set b2 bit
    spi2.write(b07_array[1]); //set b1 bit 
    spi2.write(b07_array[0]); //set b0 bit
    //room4
    //LED0
    //set green bits
    spi2.write(g10_array[7]); //set g7 bit
    spi2.write(g10_array[6]); //set g6 bit
    spi2.write(g10_array[5]); //set g5 bit
    spi2.write(g10_array[4]); //set g4 bit
    spi2.write(g10_array[3]); //set g3 bit
    spi2.write(g10_array[2]); //set g2 bit
    spi2.write(g10_array[1]); //set g1 bit 
    spi2.write(g10_array[0]);//set g0 bit
    //set red bits
    spi2.write(r10_array[7]);//set r7 bit
    spi2.write(r10_array[6]); //set r6 bit
    spi2.write(r10_array[5]); //set r5 bit
    spi2.write(r10_array[4]); //set r4 bit
    spi2.write(r10_array[3]); //set r3 bit
    spi2.write(r10_array[2]); //set r2 bit
    spi2.write(r10_array[1]); //set r1 bit 
    spi2.write(r10_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b10_array[7]); //set b7 bit
    spi2.write(b10_array[6]); //set b6 bit
    spi2.write(b10_array[5]); //set b5 bit
    spi2.write(b10_array[4]); //set b4 bit
    spi2.write(b10_array[3]); //set b3 bit
    spi2.write(b10_array[2]); //set b2 bit
    spi2.write(b10_array[1]); //set b1 bit 
    spi2.write(b10_array[0]); //set b0 bit
    //LED1
    //set green bits
    spi2.write(g11_array[7]); //set g7 bit
    spi2.write(g11_array[6]); //set g6 bit
    spi2.write(g11_array[5]); //set g5 bit
    spi2.write(g11_array[4]); //set g4 bit
    spi2.write(g11_array[3]); //set g3 bit
    spi2.write(g11_array[2]); //set g2 bit
    spi2.write(g11_array[1]); //set g1 bit 
    spi2.write(g11_array[0]);//set g0 bit
    //set red bits
    spi2.write(r11_array[7]);//set r7 bit
    spi2.write(r11_array[6]); //set r6 bit
    spi2.write(r11_array[5]); //set r5 bit
    spi2.write(r11_array[4]); //set r4 bit
    spi2.write(r11_array[3]); //set r3 bit
    spi2.write(r11_array[2]); //set r2 bit
    spi2.write(r11_array[1]); //set r1 bit 
    spi2.write(r11_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b11_array[7]); //set b7 bit
    spi2.write(b11_array[6]); //set b6 bit
    spi2.write(b11_array[5]); //set b5 bit
    spi2.write(b11_array[4]); //set b4 bit
    spi2.write(b11_array[3]); //set b3 bit
    spi2.write(b11_array[2]); //set b2 bit
    spi2.write(b11_array[1]); //set b1 bit 
    spi2.write(b11_array[0]); //set b0 bit
    //LED2
    //set green bits
    spi2.write(g12_array[7]); //set g7 bit
    spi2.write(g12_array[6]); //set g6 bit
    spi2.write(g12_array[5]); //set g5 bit
    spi2.write(g12_array[4]); //set g4 bit
    spi2.write(g12_array[3]); //set g3 bit
    spi2.write(g12_array[2]); //set g2 bit
    spi2.write(g12_array[1]); //set g1 bit 
    spi2.write(g12_array[0]);//set g0 bit
    //s2et red bits
    spi2.write(r12_array[7]);//set r7 bit
    spi2.write(r12_array[6]); //set r6 bit
    spi2.write(r12_array[5]); //set r5 bit
    spi2.write(r12_array[4]); //set r4 bit
    spi2.write(r12_array[3]); //set r3 bit
    spi2.write(r12_array[2]); //set r2 bit
    spi2.write(r12_array[1]); //set r1 bit 
    spi2.write(r12_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b12_array[7]); //set b7 bit
    spi2.write(b12_array[6]); //set b6 bit
    spi2.write(b12_array[5]); //set b5 bit
    spi2.write(b12_array[4]); //set b4 bit
    spi2.write(b12_array[3]); //set b3 bit
    spi2.write(b12_array[2]); //set b2 bit
    spi2.write(b12_array[1]); //set b1 bit 
    spi2.write(b12_array[0]); //set b0 bit
    //LED3
    //set green bits
    spi2.write(g13_array[7]); //set g7 bit
    spi2.write(g13_array[6]); //set g6 bit
    spi2.write(g13_array[5]); //set g5 bit
    spi2.write(g13_array[4]); //set g4 bit
    spi2.write(g13_array[3]); //set g3 bit
    spi2.write(g13_array[2]); //set g2 bit
    spi2.write(g13_array[1]); //set g1 bit 
    spi2.write(g13_array[0]);//set g0 bit
    //set red bits
    spi2.write(r13_array[7]);//set r7 bit
    spi2.write(r13_array[6]); //set r6 bit
    spi2.write(r13_array[5]); //set r5 bit
    spi2.write(r13_array[4]); //set r4 bit
    spi2.write(r13_array[3]); //set r3 bit
    spi2.write(r13_array[2]); //set r2 bit
    spi2.write(r13_array[1]); //set r1 bit 
    spi2.write(r13_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b13_array[7]); //set b7 bit
    spi2.write(b13_array[6]); //set b6 bit
    spi2.write(b13_array[5]); //set b5 bit
    spi2.write(b13_array[4]); //set b4 bit
    spi2.write(b13_array[3]); //set b3 bit
    spi2.write(b13_array[2]); //set b2 bit
    spi2.write(b13_array[1]); //set b1 bit 
    spi2.write(b13_array[0]); //set b0 bit
    //LED4
   //set green bits
    spi2.write(g14_array[7]); //set g7 bit
    spi2.write(g14_array[6]); //set g6 bit
    spi2.write(g14_array[5]); //set g5 bit
    spi2.write(g14_array[4]); //set g4 bit
    spi2.write(g14_array[3]); //set g3 bit
    spi2.write(g14_array[2]); //set g2 bit
    spi2.write(g14_array[1]); //set g1 bit 
    spi2.write(g14_array[0]);//set g0 bit
    //set red bits
    spi2.write(r14_array[7]);//set r7 bit
    spi2.write(r14_array[6]); //set r6 bit
    spi2.write(r14_array[5]); //set r5 bit
    spi2.write(r14_array[4]); //set r4 bit
    spi2.write(r14_array[3]); //set r3 bit
    spi2.write(r14_array[2]); //set r2 bit
    spi2.write(r14_array[1]); //set r1 bit 
    spi2.write(r14_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b14_array[7]); //set b7 bit
    spi2.write(b14_array[6]); //set b6 bit
    spi2.write(b14_array[5]); //set b5 bit
    spi2.write(b14_array[4]); //set b4 bit
    spi2.write(b14_array[3]); //set b3 bit
    spi2.write(b14_array[2]); //set b2 bit
    spi2.write(b14_array[1]); //set b1 bit 
    spi2.write(b14_array[0]); //set b0 bit
    //LED5   
    //set green bits
    spi2.write(g15_array[7]); //set g7 bit
    spi2.write(g15_array[6]); //set g6 bit
    spi2.write(g15_array[5]); //set g5 bit
    spi2.write(g15_array[4]); //set g4 bit
    spi2.write(g15_array[3]); //set g3 bit
    spi2.write(g15_array[2]); //set g2 bit
    spi2.write(g15_array[1]); //set g1 bit 
    spi2.write(g15_array[0]);//set g0 bit
    //set red bits
    spi2.write(r15_array[7]);//set r7 bit
    spi2.write(r15_array[6]); //set r6 bit
    spi2.write(r15_array[5]); //set r5 bit
    spi2.write(r15_array[4]); //set r4 bit
    spi2.write(r15_array[3]); //set r3 bit
    spi2.write(r15_array[2]); //set r2 bit
    spi2.write(r15_array[1]); //set r1 bit 
    spi2.write(r15_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b15_array[7]); //set b7 bit
    spi2.write(b15_array[6]); //set b6 bit
    spi2.write(b15_array[5]); //set b5 bit
    spi2.write(b15_array[4]); //set b4 bit
    spi2.write(b15_array[3]); //set b3 bit
    spi2.write(b15_array[2]); //set b2 bit
    spi2.write(b15_array[1]); //set b1 bit 
    spi2.write(b15_array[0]); //set b0 bit
    //LED6
    //set green bits
    spi2.write(g16_array[7]); //set g7 bit
    spi2.write(g16_array[6]); //set g6 bit
    spi2.write(g16_array[5]); //set g5 bit
    spi2.write(g16_array[4]); //set g4 bit
    spi2.write(g16_array[3]); //set g3 bit
    spi2.write(g16_array[2]); //set g2 bit
    spi2.write(g16_array[1]); //set g1 bit 
    spi2.write(g16_array[0]);//set g0 bit
    //set red bits
    spi2.write(r16_array[7]);//set r7 bit
    spi2.write(r16_array[6]); //set r6 bit
    spi2.write(r16_array[5]); //set r5 bit
    spi2.write(r16_array[4]); //set r4 bit
    spi2.write(r16_array[3]); //set r3 bit
    spi2.write(r16_array[2]); //set r2 bit
    spi2.write(r16_array[1]); //set r1 bit 
    spi2.write(r16_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b16_array[7]); //set b7 bit
    spi2.write(b16_array[6]); //set b6 bit
    spi2.write(b16_array[5]); //set b5 bit
    spi2.write(b16_array[4]); //set b4 bit
    spi2.write(b16_array[3]); //set b3 bit
    spi2.write(b16_array[2]); //set b2 bit
    spi2.write(b16_array[1]); //set b1 bit 
    spi2.write(b16_array[0]); //set b0 bit
    //LED7
    //set green bits
    spi2.write(g17_array[7]); //set g7 bit
    spi2.write(g17_array[6]); //set g6 bit
    spi2.write(g17_array[5]); //set g5 bit
    spi2.write(g17_array[4]); //set g4 bit
    spi2.write(g17_array[3]); //set g3 bit
    spi2.write(g17_array[2]); //set g2 bit
    spi2.write(g17_array[1]); //set g1 bit 
    spi2.write(g17_array[0]);//set g0 bit
    //set red bits
    spi2.write(r17_array[7]);//set r7 bit
    spi2.write(r17_array[6]); //set r6 bit
    spi2.write(r17_array[5]); //set r5 bit
    spi2.write(r17_array[4]); //set r4 bit
    spi2.write(r17_array[3]); //set r3 bit
    spi2.write(r17_array[2]); //set r2 bit
    spi2.write(r17_array[1]); //set r1 bit 
    spi2.write(r17_array[0]); //set r0 bit
    //set blue bits
    spi2.write(b17_array[7]); //set b7 bit
    spi2.write(b17_array[6]); //set b6 bit
    spi2.write(b17_array[5]); //set b5 bit
    spi2.write(b17_array[4]); //set b4 bit
    spi2.write(b17_array[3]); //set b3 bit
    spi2.write(b17_array[2]); //set b2 bit
    spi2.write(b17_array[1]); //set b1 bit 
    spi2.write(b17_array[0]); //set b0 bit
    
    //wait for latch
    wait_us(60);   
}
*/
int * decimalToBinary(int n)  // converts decimal value to 8 bit array of 1's (0xFF0) and 0's (0xF00)
{
    int reminder;
    int i=0;
    int static binary[8]; //initialize to 00000000
    while (n!=0)
    {
        reminder=n%2;
        if(reminder == 1){
            binary[i] = 0xFF0;
        }
        if(reminder == 0){
            binary[i] = 0xF00;
        }
        n = n/2;
        i++;
    }
    //sets the remainder of the digits to 0xF00 if n reaches 0 before i = 7
    for(;i<8;i++){
        binary[i] = 0xF00;
    }   
    return binary;
}
 
void spi_init(){ //initializes spi port to send 0 bit length
     spi.format(14, 0); //set spi at 14 bits/byte with clock phase and clock polarity at mode 0 
     spi.frequency(10600000); //set frequency of spi clock at 96/9 - 10.6MHz 94.3 ns bit time length
     spi2.format(14, 0); //set spi at 14 bits/byte with clock phase and clock polarity at mode 0 
     spi2.frequency(10600000); //set frequency of spi clock at 96/9 - 10.6MHz 94.3 ns bit time length
     
    }
 