#include "mbed.h"

#include "neopixels_spi.h"

neopixels_spi lights;
Ticker xmas;

Serial xbee(p9,p10); //Initalise xbee_lib

Serial pi(USBTX, USBRX);// Initialse USB serial port
void mbedReceive(void);
void modeActivated(void);
void security(void);
void brightness(void);
void colour(void);
void festive(void);
void sleep(void);
void presetBrightness(void);
void presetColour(void);
void christmas(void);
void hunika(void);
void akwansa(void);
void rainbow(void);
void rgbm(void);
void christmas2(void);
void hunika2(void);
void akwansa2(void);
void rainbow2(void);
void rgbm2(void);

//wireless commm dependencies
void xbee_detect(void);
void light2(void);
void light1(void);
void reed1(void);
void reed2(void);
void count1(void);
void count2(void);
void count3(void);
void count4(void);
void normal_mode(void);
void normal_mode2(void);

//alarm dependencies
void alarmP1(void);
void alarmR1(void);
void alarmP2(void);
void alarmR2(void);

void b1(void);
void b2(void);


DigitalOut myled(LED1);
DigitalOut mled(LED2);
DigitalOut m3led(LED3);
DigitalOut m4led(LED4);

int xbee1 = 104;// reed switches
int xbee2 = 45; // PIR
int xbee3 = 76;// reed switches
int xbee4 = 69;// PIR


short counter1 = 0;
short counter2 = 0;
short counter3 = 0;
short counter4 = 0;
int readAddress = 0;
int readValue=0;

PwmOut buzzer(p21);
float frequency[]= {659,554};  //frequency array for both sound and LED (Taken from the mbed website)
float beat[]= {1,1}; //beat array for both sound and LED

//RSP packets dependencies
int room=0;
int mode=0;
int red=0;
int green=0;
int blue=0;

//lights mode dependencies 
int rg[8][3] = {{255,0,0},{0,255,0},{255,0,0},{0,255,0},{255,0,0},{0,255,0},{255,0,0},{0,225,0}};
int gr[8][3] = {{0,255,0},{255,0,0},{0,255,0},{255,0,0},{0,255,0},{255,0,0},{0,225,0},{255,0,0}};

int bw[8][3] = {{0,0,255},{255,255,255},{0,0,255},{255,255,255},{0,0,255},{255,255,255},{0,0,255},{255,255,255}};
int wb[8][3] = {{255,255,255},{0,0,255},{255,255,255},{0,0,255},{255,255,255},{0,0,255},{255,255,255},{0,0,255}};

int rgb[8][3] = {{255,0,0},{0,255,0},{0,0,255},{255,0,0},{0,255,0},{0,0,255},{255,0,0},{0,255,0}};
int brg[8][3] = {{0,0,255},{255,0,0},{0,255,0},{0,0,255},{255,0,0},{0,255,0},{0,0,255},{255,0,0}};
int gbr[8][3] = {{0,255,0},{0,0,255},{255,0,0},{0,255,0},{0,0,255},{255,0,0},{0,255,0},{0,0,255}};
int bgr[8][3] = {{0,0,255},{0,255,0},{255,0,0},{0,0,255},{0,255,0},{255,0,0},{0,0,255},{0,255,0}};

int ak1[8][3] = {{255,0,0},{0,255,0},{0,0,0},{255,0,0},{0,255,0},{0,0,0},{255,0,0},{0,255,0}};
int ak2[8][3] = {{0,0,0},{255,0,0},{0,255,0},{0,0,0},{255,0,0},{0,255,0},{0,0,0},{255,0,0}};
int ak3[8][3] = {{0,255,0},{0,0,0},{255,0,0},{0,255,0},{0,0,0},{255,0,0},{0,255,0},{0,0,0}};
int ak4[8][3] = {{0,0,0},{0,255,0},{255,0,0},{0,0,0},{0,255,0},{255,0,0},{0,0,0},{0,255,0}};

int ra1[8][3] = {{255,0,0},{255,165,0},{255,255,0},{255,255,255},{0,255,0},{0,0,255},{75,0,255},{238,130,238}};
int ra2[8][3] = {{255,165,0},{255,255,0},{255,255,255},{0,255,0},{0,0,255},{75,0,255},{238,130,238},{255,0,0}};
int ra3[8][3] = {{255,255,0},{255,255,255},{0,255,0},{0,0,255},{75,0,255},{238,130,238},{255,0,0},{255,165,0}};
int ra4[8][3] = {{255,255,255},{0,255,0},{0,0,255},{75,0,255},{238,130,238},{255,0,0},{255,165,0},{255,255,0}};
int ra5[8][3] = {{0,255,0},{0,0,255},{75,0,255},{238,130,238},{255,0,0},{255,165,0},{255,255,0},{255,255,255}};
int ra6[8][3] = {{0,0,255},{75,0,255},{238,130,238},{255,0,0},{255,165,0},{255,255,0},{255,255,255},{0,255,0}};
int ra7[8][3] = {{75,0,255},{238,130,238},{255,0,0},{255,165,0},{255,255,0},{255,255,255},{0,255,0},{0,0,255}};
int ra8[8][3] = {{238,130,238},{255,0,0},{255,165,0},{255,255,0},{255,255,255},{0,255,0},{0,0,255},{75,0,255}};


int main() {
    xmas.attach(&mbedReceive, 1.0);
    while(1) {
        if(pi.readable()){
         modeActivated();
         //mbedReceive();   
            }
     xbee_detect();
     normal_mode();
     normal_mode2();
    }
}

// function to receive stuff from pi 
void mbedReceive(void){
    int section = pi.getc();
    if (section==1){
        security(); //activate security mode
        }
    else if (section==2){
        room = pi.getc();
        mode = pi.getc();
        red = pi.getc();
        green = pi.getc();
        blue = pi.getc();
        }
    else if (section==0){
        //normal lights function a way of stopping different light modes
        // b2() stop alarm
        room = pi.getc();
        if (room==1){
            //normal mode 1
            }
        else if (room==2){
            //normal mode 2
            }
        
        }
    }
    
void modeActivated(void){
    mbedReceive(); 
     if (mode==1){
      brightness();
        }
     if (mode==2){
      colour();
        }
     if (mode==3){
      festive();
        } 
     if (mode==4){
      sleep();
        }
     if (mode==5){
     presetBrightness();
        }
     if (mode==6){
      presetColour();
        }
            
    }

 void security(void){
     
     }

void brightness(void){
    if (room==1){
       lights.setRGBStrip1(red, red, red);
        }
     if (room==2){
      lights.setRGBStrip2(red, red, red);
        }
    }
void colour(void){
    if (room==1){
     lights.setRGBStrip1(red, green, blue);
        }
     if (room==2){
     lights.setRGBStrip2(red, green, blue);
        }
    
    }
void festive(void){
    if (room==1){
        if(red==1){
         christmas();  
        }
        if(red==2){
         hunika();   
        }
        if(red==3){
         akwansa();   
        }
        if(red==4){
         rainbow();   
        }
        if(red==5){
         rgbm();   
        }
        }
     else if (room==2){
        if(red==1){
         
         christmas2();   
        }
        if(red==2){
         hunika2();   
        }
        if(red==3){
         akwansa2();   
        }
        if(red==4){
         rainbow2();   
        }
        if(red==5){
         rgbm2();   
        }
        }
    }
void sleep(void){
    if (room==1){
     //  setRGBStrip1(red, green, blue); sleep pattern for strip1
        }
     if (room==2){
     //  setRGBStrip2(red, green, blue);sleep pattern for strip1
        }
    }
void presetBrightness(void){
    
    }
void presetColour(void){
    
    }
    
//xmas red & green 
void christmas(void){
    lights.setRGBPixels1(rg);
      wait(1);
    lights.setRGBPixels1(gr);
      wait(1);
    lights.setRGBPixels1(rg);
      wait(1);
    lights.setRGBPixels1(gr);
      wait(1);
    lights.setRGBPixels1(rg);
      wait(1);
    lights.setRGBPixels1(gr);
      wait(1);
    lights.setRGBPixels1(rg);
      wait(1);
    lights.setRGBPixels1(gr);
      wait(1);
    lights.setRGBPixels1(rg);
      wait(1);
    lights.setRGBPixels1(gr);
      wait(1);
    lights.setRGBStrip1(255, 0, 0);
         wait(1);
    lights.setRGBStrip1(0,255,0);
         wait(1);
    }
void hunika(void){
     lights.setRGBPixels1(bw);
      wait(1);
     lights.setRGBPixels1(wb);
      wait(1);
      lights.setRGBPixels1(bw);
      wait(1);
     lights.setRGBPixels1(wb);
      wait(1);
      lights.setRGBPixels1(bw);
      wait(1);
     lights.setRGBPixels1(wb);
      wait(1);
      lights.setRGBPixels1(bw);
      wait(1);
     lights.setRGBPixels1(wb);
      wait(1);
      lights.setRGBPixels1(bw);
      wait(1);
     lights.setRGBPixels1(wb);
      wait(1);
     lights.setRGBStrip1(0, 0, 255);
         wait(1);
    lights.setRGBStrip1(255,255,255);
         wait(1);
    }
    
void akwansa(void){
    lights.setRGBPixels1(ak1);
      wait(1);
     lights.setRGBPixels1(ak2);
      wait(1);
      lights.setRGBPixels1(ak3);
      wait(1);
     lights.setRGBPixels1(ak4);
      wait(1);
      lights.setRGBPixels1(ak1);
      wait(1);
     lights.setRGBPixels1(ak2);
      wait(1);
      lights.setRGBPixels1(ak3);
      wait(1);
     lights.setRGBPixels1(ak4);
      wait(1);
      lights.setRGBPixels1(ak1);
      wait(1);
     lights.setRGBPixels1(ak2);
      wait(1);
      lights.setRGBPixels1(ak3);
      wait(1);
     lights.setRGBPixels1(ak4);
      wait(1);
    }
void rainbow(void){
     lights.setRGBPixels1(ra1);
      wait(1);
     lights.setRGBPixels1(ra2);
      wait(1);
      lights.setRGBPixels1(ra3);
      wait(1);
     lights.setRGBPixels1(ra4);
      wait(1);
      lights.setRGBPixels1(ra5);
      wait(1);
     lights.setRGBPixels1(ra6);
      wait(1);
      lights.setRGBPixels1(ra7);
      wait(1);
     lights.setRGBPixels1(ra8);
      wait(1);
    }
    
void rgbm(void){
    lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
      lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
      lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
      lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
      lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
      lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
     lights.setRGBStrip2(255, 0, 0);
         wait(1);
    lights.setRGBStrip2(0,255,0);
         wait(1);
    lights.setRGBStrip2(0,0,255);
         wait(1);
    }
    
void christmas2(void){
    lights.setRGBPixels2(rg);
      wait(1);
     lights.setRGBPixels2(gr);
      wait(1);
      lights.setRGBPixels2(rg);
      wait(1);
     lights.setRGBPixels2(gr);
      wait(1);
      lights.setRGBPixels2(rg);
      wait(1);
     lights.setRGBPixels2(gr);
      wait(1);
      lights.setRGBPixels2(rg);
      wait(1);
     lights.setRGBPixels2(gr);
      wait(1);
      lights.setRGBPixels2(rg);
      wait(1);
     lights.setRGBPixels2(gr);
      wait(1);
     lights.setRGBStrip2(255, 0, 0);
         wait(1);
    lights.setRGBStrip2(0,255,0);
         wait(1);
    }
    
void hunika2(void){
     lights.setRGBPixels2(bw);
      wait(1);
     lights.setRGBPixels2(wb);
      wait(1);
      lights.setRGBPixels2(bw);
      wait(1);
     lights.setRGBPixels2(wb);
      wait(1);
      lights.setRGBPixels2(bw);
      wait(1);
     lights.setRGBPixels2(wb);
      wait(1);
      lights.setRGBPixels2(bw);
      wait(1);
     lights.setRGBPixels2(wb);
      wait(1);
      lights.setRGBPixels2(bw);
      wait(1);
     lights.setRGBPixels2(wb);
      wait(1);
     lights.setRGBStrip2(0, 0, 255);
         wait(1);
    lights.setRGBStrip2(255,255,255);
         wait(1);
    }
    
void akwansa2(void){
    lights.setRGBPixels2(ak1);
      wait(1);
     lights.setRGBPixels2(ak2);
      wait(1);
      lights.setRGBPixels2(ak3);
      wait(1);
     lights.setRGBPixels2(ak4);
      wait(1);
      lights.setRGBPixels2(ak1);
      wait(1);
     lights.setRGBPixels2(ak2);
      wait(1);
      lights.setRGBPixels2(ak3);
      wait(1);
     lights.setRGBPixels2(ak4);
      wait(1);
      lights.setRGBPixels2(ak1);
      wait(1);
     lights.setRGBPixels2(ak2);
      wait(1);
      lights.setRGBPixels2(ak3);
      wait(1);
     lights.setRGBPixels2(ak4);
      wait(1);
    }
    
    
void rainbow2(void){
     lights.setRGBPixels2(ra1);
      wait(1);
     lights.setRGBPixels2(ra2);
      wait(1);
      lights.setRGBPixels2(ra3);
      wait(1);
     lights.setRGBPixels2(ra4);
      wait(1);
      lights.setRGBPixels2(ra5);
      wait(1);
     lights.setRGBPixels2(ra6);
      wait(1);
      lights.setRGBPixels2(ra7);
      wait(1);
     lights.setRGBPixels2(ra8);
      wait(1);
    }
    
    
void rgbm2(void){
    lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
      lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
      lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
      lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
     lights.setRGBPixels2(rgb);
      wait(1);
     lights.setRGBPixels2(brg);
      wait(1);
     lights.setRGBPixels2(gbr);
      wait(1);
     lights.setRGBPixels2(bgr);
      wait(1);
     lights.setRGBStrip2(255, 0, 0);
         wait(1);
    lights.setRGBStrip2(0,255,0);
         wait(1);
    lights.setRGBStrip2(0,0,255);
         wait(1);
    }

void xbee_detect(void){
    if (xbee.getc() == 0x7E) {
        for (int i = 0; i < 19; i++) {
            if (i<10){
                int discard = xbee.getc();
            }
            else if (i<11){
                readAddress = xbee.getc();
            }
            else{
                int discarded = xbee.getc();
            }
        }
        readValue = xbee.getc();
    }
}
    //lights room1
void light1(void){
     if ( readAddress == xbee2){
        if (readValue == 0){
            counter2++;
            count2();
    }
    else if(readValue == 16){
            counter2 = 0;
          lights.setRGBStrip1(127,127,127);
           // wait(2);//mled = 1;
            }
    }
}
    //room 2
void light2(void){
      if ( readAddress == xbee4){
        if (readValue == 0){
            counter4++;
            count4();
           
        }
    
    else if(readValue == 16){
            counter4 = 0;
             lights.setRGBStrip2(127,127,127);
    }
    }
}

void reed1(void){
    if( readAddress == xbee1){
        if (readValue == 0){
            //counter1++;
          //  count1();
          b2(); 
    }
    else if(readValue == 16){
        counter1 = 0;
       // myled = 1;
       b1(); 
    }
    }
}
    //room 2
void reed2(void){
   if ( readAddress == xbee3){
        if (readValue == 0){
            //counter3++;
            //count3();
            b2(); 
    }
    else if(readValue == 16){
            //counter3 = 0;
           // m3led = 1;
           b1(); 
    }
}
}

void count1(void){
     if(counter1==10){
                myled = 0;
                counter1 = 0;
            }
    }
void count3(void){
     if(counter3==10){
                m3led = 0;
                counter1 = 0;
            }
    }

//lights count 
void count2(void){
     if(counter2==150){
                   lights.setRGBStrip1(0,0,0);
                    counter2 = 0;
        }
    }

void count4(void){
     if(counter4==150){
                   lights.setRGBStrip2(0,0,0);
                    counter2 = 0;
        }
    }

void b1(void){  
    for (int i=0; i<=1; i++) {
                buzzer.period(1/(frequency[i])); // set PWM period
                buzzer=0; // set duty cycle
                //wait(0.1*beat[i]); // hold for beat period
               // myled = 1;
                
          }
    }
    
void b2(void){  
    for (int i=0; i<=1; i++) {
                buzzer.period(1/(frequency[i])); // set PWM period
                buzzer=0.9; // set duty cycle
                //wait(0.1*beat[i]); // hold for beat period
               // myled = 1;
                
          }
    }

void normal_mode(void){
       // light2();
        light1();
        reed1();
        //reed2();
    }
    
void normal_mode2(void){
        light2();
        //light1();
        //reed1();
        reed2();
    }


// Alarm Dependencies
void alarmP1(void){
     if ( readAddress == xbee2){
        if (readValue == 0){
            counter2++;
            count2();
    }
    else if(readValue == 16){
            counter2 = 0;
          lights.setRGBStrip1(127,127,127);
          b2();
           // wait(2);//mled = 1;
            }
    }
}
    //room 2
void alarmP2(void){
      if ( readAddress == xbee4){
        if (readValue == 0){
            counter4++;
            count4();  
        }
    
    else if(readValue == 16){
            counter4 = 0;
             lights.setRGBStrip2(127,127,127);
             b2();
    }
    }
}

void alarmR1(void){
    if( readAddress == xbee1){
        if (readValue == 0){
            //counter1++;
          //  count1();
          b2(); 
    }
    else if(readValue == 16){
        counter1 = 0;
       // myled = 1;
       //b1(); 
    }
    }
}
    //room 2
void alarmR2(void){
   if ( readAddress == xbee3){
        if (readValue == 0){
            //counter3++;
            //count3();
            b2(); 
    }
    else if(readValue == 16){
            //counter3 = 0;
           // m3led = 1;
          // b1(); 
    }
}
}