#include "mbed.h"
#include "HIDScope.h"

// Motor 1 has PWM-pin D5 and direction-pin D4

AnalogIn pot1(A0);
DigitalOut directionpin(D4);
PwmOut pwmpin(D5);
HIDScope scope(1); // We’re going to send 1 channel of data
Ticker AInTicker;

void ReadAnalogInAndFilter()
{
        float u = 2.0f*pot1-1.0f;
        scope.set(0, u);  // Brightness is saved in the first scope.
        scope.send(); // send what's in scope memory to PC
}

int main(){
    pwmpin.period_us(60);
    AInTicker.attach(&ReadAnalogInAndFilter, 0.01f);
    while (true) {
        float u = 2.0f*pot1-1.0f; //determine useful value, -0.3f is just an example
        directionpin = u > 0.0f; //either true or false
        pwmpin.write = fabs(u); //pwm duty cycle can only be positive, floating point absolute value
        wait(0.001f);
    }
}