#include "mbed.h"
#include "DRV8825.h"
#define MAX_SPEED 8000
#define MICROSTEPS_PER_STEP 32
#include "Ping.h"
#include <stdio.h> 
#include "TextLCD.h"
#include <cmath>
// add boundaries

Ping Pinger(p30);
Serial pc(USBTX, USBRX);

    int PULL = 1;
    int PUSH = 0;
    int SALT = 1;
    int PURE = 0;
    int PREVIOUS_DIRECTION_SALT = -1;
    int PREVIOUS_DIRECTION_PURE = -1;
    
    DRV8825 stpr_mtr(p21, p27, p28, p29, p22, p23);
    DRV8825 stpr_mtr2(p24, p27, p28, p29, p25, p26);

bool proximity_ok(){
    int range;
 
        Pinger.Send();   
        wait(0.1); 
        range = Pinger.Read_cm();
        
        
        range = range/2;
       // lcd.printf("Range in cm: %d \n\r", range);
        
    if (range >= 12){
        //lcd.printf("Proximity ok");
        return true;
    }    
    return false;        
}  

void add_water(int type, double mililiters, int DIRECTION){
        
    int MOVEMENT = 4000; //constant for 1 mL
    double STEP_EXTRA = 4700; //for the other mL's
            
        //accelerate
        for (int i = 25; i < MAX_SPEED; i+=20) {    
            if (type == SALT)
                stpr_mtr.settings(1/MICROSTEPS_PER_STEP, DIRECTION, i);
           else 
               stpr_mtr2.settings(1/MICROSTEPS_PER_STEP, DIRECTION, i);  
        } 
    
        //fix the changing of directions for pure
        if (type == PURE && PREVIOUS_DIRECTION_PURE != DIRECTION){          
            mililiters = mililiters + 1.0;
        }    
    
        //fix the changing of directions for salt
        if (type == SALT && PREVIOUS_DIRECTION_SALT != DIRECTION){
             mililiters = mililiters + 1.0;  
        }    

        //move with constant speed
        for (int i = 1; i < (MOVEMENT + (int)floor(((mililiters - 1.0)*STEP_EXTRA))); i+=1) {      
            if (type == SALT)
                stpr_mtr.settings(1/MICROSTEPS_PER_STEP, DIRECTION, MAX_SPEED);
            else
                stpr_mtr2.settings(1/MICROSTEPS_PER_STEP, DIRECTION, MAX_SPEED);   
        }
   
        //de-accelerate
        for (int i = MAX_SPEED; i > 0; i-=20) {    
            if (type == SALT)
                stpr_mtr.settings(1/MICROSTEPS_PER_STEP, DIRECTION, i);
            else
                stpr_mtr2.settings(1/MICROSTEPS_PER_STEP, DIRECTION, i);    
        }
    
        //remember previous direction
        if (type == SALT){    
            PREVIOUS_DIRECTION_SALT = DIRECTION;
        }else{       
            PREVIOUS_DIRECTION_PURE = DIRECTION;  
        }           
}

int main() {
        //initialize
        wait(3); //turn the thing to pulling from reservoir
        add_water(PURE, 20.0, PULL); //20
        wait(3); //turn the thing to pushing to glass
        add_water(PURE, 20.0, PUSH); //19.5 
        wait(3); //turn the thing to pulling from reservoir
        add_water(PURE, 20.0, PULL); //20
        wait(3); //turn the thing to pushing to glass
        add_water(PURE, 20.0, PUSH); //19
        wait(3); //turn the thing to pulling from reservoir
        add_water(PURE, 25.0, PULL); //20
        //done
        
        //initialize
        wait(3); //turn the thing to pulling from reservoir
        add_water(SALT, 20.0, PULL); //20
        wait(3); //turn the thing to pushing to glass
        add_water(SALT, 20.0, PUSH); //19.5 
        wait(3); //turn the thing to pulling from reservoir
        add_water(SALT, 20.0, PULL); //20
        wait(3); //turn the thing to pushing to glass
        add_water(SALT, 20.0, PUSH); //19
        wait(3); //turn the thing to pulling from reservoir
        add_water(SALT, 25.0, PULL); //20
        //done
}
