#include "mbed.h"
#include <cmath>
#include <stdio.h>   
#include <math.h>
#include <algorithm>
//#include <LinearTemp.h>
#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p19, p20, p21, p22, p23, p24); // rs, e, d4-d7
Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1), myled2(LED2);
AnalogIn pin_1(p16), pin_2(p15), pin_3(p17) ;
AnalogOut pin_18 (p18);
DigitalIn switchinput(p7);
DigitalOut redLed(p5);
DigitalOut alarm (p5);
//LinearTemp mysensor(p15, 0.0050354, -273.15); 
 
char program_name[128] = "G3-Waterplay Project";
float roundvalue = 0;
double Temperature = 0;
float Salinity = 0;

void salinityMeasurement();
void temperatureMeasurement();
void initialization ();
int main()
{
    //int number = 0;
    temperatureMeasurement();
    lcd.printf("None \n");
    
    while(true){
        if (Temperature >= 32){
            pin_18 = 0;
            redLed = 1;
            temperatureMeasurement();
            lcd.printf("Temp too high \n");
        }
        
        if(Temperature >= 28 && Temperature < 32 ){
            pin_18 = 0;  
            myled1 = 0;
            redLed = 0;
            temperatureMeasurement();
            salinityMeasurement();      
        }
        if (Temperature < 28){
            pin_18 = 1;
            myled1 = 1;
            temperatureMeasurement();
            lcd.printf("None \n");
        }
    }    
     
     //initialization();    
     //while(1){
       // wait(2); 
        //salinityMeasurement();
        //temperatureMeasurement();
    //}
    
    /*
    int number = 0;
    temperatureMeasurement();
    salinityMeasurement();
    for (int i = 23 ; i < 35; i++){
        while (Temperature < (double)i){
            number++;
            pin_18 = 1;
            myled1 = 1;   
            if (number %100 == 0){
                temperatureMeasurement();
                salinityMeasurement();
            }      
        }
        pin_18 = 0;  
        myled1 = 0;
        redLed = 0;  
        
        alarm = 1;
        wait(0.2);
        alarm = 0;
        wait(0.5);
        alarm = 1;
        wait(0.2);
        alarm = 0;
        
        while (switchinput!=1){
            wait(1);
            temperatureMeasurement();
            salinityMeasurement();
        }    
        
        temperatureMeasurement();
        salinityMeasurement();
    }
    */
}
    
//salinity function
void salinityMeasurement(){
    float f, vin, divider, vout;
    
    float salt[100];
    
    for (int i = 0;  i < 100; i++){
        f = pin_1.read();
        vin = f * 3.3;
        divider = (float)5/ (float)3;
        vout = vin * divider;
    
        //measure the salinity
        salt[i] = 16.3 * vout; 
    }   
    
    sort(salt, salt + 100);
    
    pc.printf("vin: %f, vout: %f, salt: %f \n\r", vin, vout, salt[50]);
    roundvalue = (float)floor((salt[50]*100.0) + 0.5)/100.0;
    lcd.printf("Sal:  %g \n", roundvalue);
    Salinity = roundvalue;
}

//temperature function
void temperatureMeasurement(){
    //measure the temperature
    double f2, vin, divider, vout, RT, K0, K1, K2, TKelvin;
    double Celcius[100];
    
    for (int i = 0;  i < 100; i++){
        f2 = pin_2.read();
        vin = f2 * 4.85;
        divider = (double)5/ (double)3;
        vout = vin * divider;
    
        RT = (vout * (double)15000) / (4.85 - vout);
        K0 = 0.00102119;
        K1 = 0.000222468 * (log(RT));
        K2 = double (1.33342 * pow (10.0, -7.0)) * pow ((double)log(RT), 3.0);
        TKelvin = 1.0 / (K0 + K1 + K2);
        Celcius[i] = (TKelvin - 273.15)+5.0;
    }
    //pc.printf("K0: %f, K1: %f, K2: %f \n\r", K0, K1, K2); 
    //pc.printf("vin: %f, vout: %f, temperature: %f \n\r", vin, vout, Celcius);
    
    sort(Celcius, Celcius + 100);
    
    pc.printf("vin: %f, vout: %f, temperature: %f \n\r",vin, vout, Celcius[50]);
    roundvalue = (float)floor((Celcius[50]*100.0) + 0.5)/100.0;
    lcd.printf("Temp: %g \n", roundvalue);
    Temperature = roundvalue;
    
    /*
    if (Celcius[50] >= 34){
        pin_18 = 0;
        redLed = 1;
        lcd.printf("The temperature is too high");
    }else if(Celcius[50] >= 28 && Celcius[50] < 34 ){
        pin_18 = 0;  
        myled1 = 0;
        redLed = 0;      
    }else {
        pin_18 = 1;
        myled1 = 1;
    }
    */
}

void initialization(){
int message=0;
    while (message<8){
    
        if (message==0){
            lcd.printf("Check the water tank  \n");
        }
        if (message==1){
            lcd.printf("Check the solution tank  \n");
        }
        if (message==2){
            lcd.printf("Check the water tube  \n");
        }
        if (message==3){
            lcd.printf("Check the salinity tube  \n");
        }
        if (message==4){
            lcd.printf("Check the valves position  \n");
        }
        if (message==5){
            lcd.printf("Check the syrenge  \n");
        }
        if (message==6){
            lcd.printf("Check the sensor position  \n");
        }
        if (message==7){
            lcd.printf("Check the thermostat  \n");
        }
    
        if (switchinput==1){
            message++;
            wait(2);
            lcd.cls();
        }
    
    }
    
    lcd.printf("System will start in 2 sec \n");
    wait(2);
    lcd.cls();
}




    

