/*
* G3: WATERPLAY
*/

#include "mbed.h"
#include "Flasher.h"
#include "SalinitySensor.h"
#include "TemperatureSensor.h"
#include "Thermostat.h"
#include "Waterplay.h"
#include "TextLCD.h"
#include "Printer.h"
#include "Tank.h"

DRV8825 salinitySyringe(
    p21, p27, p28, p29, p22, p23
);
DRV8825 waterSyringe(
    p24, p27, p28, p29, p25, p26
);
TextLCD lcd(
    p19, p20, p11, p12, p13, p14
);
char buffer[128];
char program_name[128] = "G3: WATERPLAY";
int keep_running = 1;
Serial serial(USBTX, USBRX);
Flasher led1(LED1);
Printer printer(serial, lcd);

SalinitySensor salinitySensor(
    printer,
    p16
);

TemperatureSensor temperatureSensor(
    printer,
    p15
);

Thermostat thermostat(
    printer,
    p18,
    LED4
);

Ping pinger(p30);

Tank tank(
    printer,
    salinitySyringe,
    waterSyringe,
    pinger
);

Waterplay waterplay(
    printer,
    temperatureSensor,
    salinitySensor,
    thermostat,
    tank,
    led1
);

int main()
{
    printer.display();
    led1.flash(1);

    while(keep_running) {
        waterplay.control();
        //keep_running = 0;
    }
}