/*
* G3: WATERPLAY
*/

#include "Waterplay.h"
#include "mbed.h"

Waterplay::Waterplay(
    Printer &printer,
    TemperatureSensor &temperatureSensor,
    SalinitySensor &salinitySensor,
    Thermostat &thermostat,
    Tank &tank,
    Flasher &flasher
):
    _printer(printer),
    _temperatureSensor(temperatureSensor),
    _salinitySensor(salinitySensor),
    _thermostat(thermostat),
    _tank(tank),
    _flasher(flasher)
{
}

int Waterplay::control()
{
    int retVal = 1;
    _temperatureSensor.reload();
    _salinitySensor.reload();
    _flasher.flash(1);
    _thermostat.react(
        _temperatureSensor.getStatus()
    );
    _tank.react(
        _salinitySensor.getStatus()
    );
    
    _printer.display(
        _salinitySensor.getSalinity(),
        _salinitySensor.getStrStatus(),
        _temperatureSensor.getTemperature(),
        _temperatureSensor.getStrStatus()
    );
    
    _flasher.flash(2);
    
    _printer.toBoth(
        _thermostat.getStrStatus()
    );
    _flasher.flash(2);
    
    return(retVal);
}