/*
* G3: WATERPLAY
*/

#include "Thermostat.h"
#include "mbed.h"

Thermostat::Thermostat(
    Printer &printer,
    PinName pin,
    PinName led_pin
):
    _printer(printer),
    _analog_out(pin),
    _led(led_pin),
    _status(STATUS_OFF)
{
}

int Thermostat::update(){
    this->_analog_out = this->_status;
    this->_led = this->_status;
    
    return(this->_status);
}

int Thermostat::on()
{
    this->_status = STATUS_ON;
    this->_strStatus = "Thermostat: ON\n\r";
    return(this->_status);
}

int Thermostat::off()
{
    this->_status = STATUS_OFF;
    this->_strStatus = "Thermostat: OFF\n\r";
    return(this->_status);
}

int Thermostat::react(double temperature)
{
    int retVal = 0;

    if(temperature < 0.0) {
        retVal = this->on();
    } else {
        retVal = this->off();
    }

    return(retVal);
}

char* Thermostat::getStrStatus(){
    return(this->_strStatus);
}