/*
* G3: WATERPLAY



*/

#ifndef TEMPERATURE_SENSOR_H
#define TEMPERATURE_SENSOR_H

#include "mbed.h"
#include "Printer.h"

class TemperatureSensor
{
public:
    TemperatureSensor(
        Printer &printer,
        PinName pin
    );
    static const double VIN = 4.85;
    static const double CONVERTER = 1.6667;
    static const double LOWER_BOUNDARY = 28.0;
    static const double UPPER_BOUNDARY = 31.9;
    static const double VARIANCE = 5.0;
    static const double RESISTANCE = 15000.0;
    static const int SAMPLING_NUMBER = 100;
    static const double K0 = 0.00102119;
    static const double K1 = 0.000222468;
    static const double K2 = 0.000000133342;
    static const double KELVIN_TO_CELCIUS = -273.15;
    void reload();
    double getReading();
    double getVoltage();
    double getTemperature();
    double getStatus();
    char* getStrStatus();

private:
    Printer &_printer;
    AnalogIn _analog_in;
    double _reading;
    double _voltage;
    double _temperature;
    double _status;
    char* _strStatus;
    double _k0;
    double _k1;
    double _k2;
    double _kelvin_to_celcius;
};

#endif