/*
* G3: WATERPLAY
*/

#include "Printer.h"
#include "Tank.h"
#include "mbed.h"

Tank::Tank(
    Printer &printer,
    DRV8825 &salinitySyringe,
    DRV8825 &waterSyringe,
    Ping &pinger
):
    _printer(printer),
    _salinitySyringe(salinitySyringe),
    _waterSyringe(waterSyringe),
    _pinger(pinger),
    _previous_direction_salt(-1),
    _previous_direction_pure(-1),
    _position_salt(14),
    _position_pure(27)
{
}

bool Tank::is_proximity_ok()
{
    int range = 0;
    char buffer[32];

    _pinger.Send();
    wait(0.1);
    range = _pinger.Read_cm();

    range = range/2;
    sprintf(
        buffer,
        "Range in cm: %d",
        range
    );
    _printer.toBoth(buffer);

    if (range >= 12) {
        _printer.toBoth("Proximity ok");
        return true;
    }
    return false;
}

void Tank::add(int type, int mililiters, int direction)
{
    for (int i = 25; i < MAX_SPEED; i+=20) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
    }

    //fix the changing of directions for pure
    if (type == TYPE_PURE) {
        //mililiters = mililiters * 2.0;
        if (_previous_direction_pure != direction)
            mililiters = mililiters + 1.0;
    }

    //fix the changing of directions for salt
    if (type == TYPE_SALT) {
        //mililiters = mililiters * 2.0;
        if (_previous_direction_salt != direction)
            mililiters = mililiters + 1.0;
        //if (_previous_direction_salt == DIRECTION_PULL)
        //mililiters = mililiters + 0.5;
    }

    //move with constant speed
    for (int i = 1; i < (MOVEMENT + (int)floor(((mililiters - 1.0)*STEP_EXTRA))); i+=1) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, MAX_SPEED);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, MAX_SPEED);

        //if ((i - MOVEMENT) % STEP_EXTRA == 0 && !proximity_ok())
        //  break;
    }

    //de-accelerate
    for (int i = MAX_SPEED; i > 0; i-=20) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
    }

    //remember previous direction
    if (type == TYPE_SALT) {
        _previous_direction_salt = direction;
    } else {
        _previous_direction_pure = direction;
    }
}
void Tank::react(double salinity)
{
    char buffer[32];
    sprintf(
        buffer,
        "salinity: %3.2F",
        salinity
    );
    _printer.toBothln(buffer);
    
    //this->add(TYPE_PURE, 2.0, DIRECTION_PUSH);
    //wait(2);
    //this->add(TYPE_PURE, 4.0, DIRECTION_PULL);
}