/*
* G3: WATERPLAY
*/

#ifndef SALINITY_SENSOR_H
#define SALINITY_SENSOR_H

#include "mbed.h"
#include "Printer.h"

class SalinitySensor
{
public:
    SalinitySensor(
        Printer &printer,
        PinName pin
    );
    static const double VIN = 3.3;
    static const double CONVERTER = 1.6667;
    static const double MULTIPLIER = 16.3;
    static const double LOWER_BOUNDARY = 3.0;
    static const double UPPER_BOUNDARY = 6.9;
    static const int SAMPLING_NUMBER = 100;
    void reload();
    double getReading();
    double getVoltage();
    double getSalinity();
    double getStatus();
    char* getStrStatus();

private:
    Printer &_printer;
    AnalogIn _analog_in;
    double _reading;
    double _voltage;
    double _salinity;
    double _status;
    char* _strStatus;
};

#endif