/*
* G3: WATERPLAY
*/

#include "SalinitySensor.h"
#include "mbed.h"
#include <algorithm>
#include "Printer.h"

SalinitySensor::SalinitySensor(
    Printer &printer,
    PinName pin
):
    _printer(printer),
    _analog_in(pin),
    _reading(0.0),
    _voltage(0.0),
    _salinity(0.0),
    _status(0.0),
    _strStatus("OK")
{
    this->reload();
}

void SalinitySensor::reload()
{
    double readings[SAMPLING_NUMBER];
    
    for(int counter = 0; counter < SAMPLING_NUMBER; ++counter){
        // the reading from sensor.
        readings[counter] = this->_analog_in.read();
    }

    sort(readings, readings + SAMPLING_NUMBER);
    
    this->_reading = readings[SAMPLING_NUMBER / 2];
    
    // converted voltage.
    this->_voltage = 
        this->_reading *
        VIN *
        CONVERTER;
    // the salinity value.
    this->_salinity = 
        this->_voltage *
        MULTIPLIER;
        
    this->_status = 0.0;
    this->_strStatus = "OK";
    if(this->_salinity < LOWER_BOUNDARY){
        this->_status = this->_salinity - LOWER_BOUNDARY;
        this->_strStatus = "LW";
    } else if(this->_salinity > UPPER_BOUNDARY){
        this->_status = UPPER_BOUNDARY - this->_salinity;
        this->_strStatus = "HI";
    }
}

double SalinitySensor::getReading()
{
    return(this->_reading);
}

double SalinitySensor::getVoltage()
{
    return(this->_voltage);
}

double SalinitySensor::getSalinity()
{
    return(this->_salinity);
}

double SalinitySensor::getStatus()
{
    return(this->_status);
}

char* SalinitySensor::getStrStatus()
{
    return(this->_strStatus);
}