#ifndef MBED_SOUNDBOARD_H
#define MBED_SOUNDBOARD_H

#include "mbed.h"

#define MUTE VOL_0
#define VOL_0 0xFFF0
#define VOL_1 0xFFF1
#define VOL_2 0xFFF2
#define VOL_3 0xFFF3
#define VOL_4 0xFFF4
#define VOL_5 0xFFF5
#define VOL_6 0xFFF6
#define VOL_7 0xFFF7
#define PLAY_PAUSE 0xFFFE
#define STOP 0xFFFF
/**
* soundboard class
* Used to control the WTV020SD board from sparkfun
* Find out more at https://www.sparkfun.com/products/11125
* Example:
@code
#include "mbed.h"
#include "soundboard.h"
int main(void)
{
   //initialise the soundboard
   soundboard mySoundBoard(D1, D2, D3, D4);
   //play track 0
   mySoundBoard.play(0);
   //play track 1
   mySoundBoard.playAsync(1);
   //set the volume as 3
   mySoundBoard.setVolume(VOL_3);
   wait(.5);
   //set the volume as 7 (max)
   mySoundBoard.setVolume(VOL_7);
   wait(.5);
   //mute the playback, but the playback will continue
   mySoundBoard.setVolume(MUTE);
   wait(.5);
   //pause playback
   mySoundBoard.pause();
   wait(.5);
   //continue playback
   mySoundBoard.pause();
   wait(.5);
   //reset the soundboard.
   mySoundBoard.reset();
   while(1);
}
@endcode
*/
class soundboard
{
public:
    /** Creates the soundboard class with the specified reset pin, clock pin, data pin and busy pin*/
    soundboard(PinName resetPin, PinName clockPin, PinName dataPin, PinName busyPin);
    /** resets the soundboard*/
    void reset(void);
    /** plays the given track, Code will be blocked until the track has finished playing
    @param <tracknum> the number of the track which should be played*/
    void play(int);
    /** plays the given track, Code will continue running while the track is playing
    @param <tracknum> the number of the track which should be played*/
    void playAsync(int);
    /** stops play back of the current track, only works if the track was played using playAsync*/
    void stop(void);
    /** pauses the currently playing track, or plays the currently paused track, only works if the track was played using playAsync*/
    void pause(void);
    /** sets the volume of the playback. Use VOL_0 through to VOL_7*/
    void setVolume(int);
    /**plays if something else is not playing**/
    void playPerhapsAsync(int);
private:
    void sendCommand(unsigned int);
    DigitalOut _resetPin;
    DigitalOut _clockPin;
    DigitalOut _dataPin;
    DigitalIn _busyPin;
    
};

#endif
