#include "soundboard.h"



soundboard::soundboard(PinName resetPin, PinName clockPin, PinName dataPin, PinName busyPin) : _resetPin(resetPin), _clockPin(clockPin), _dataPin(dataPin), _busyPin(busyPin)
{
    reset();
}

void soundboard::reset()
{
    _clockPin = 0;
    _resetPin = 1;
    //Reset pulse.
    _resetPin = 0;
    wait_ms(5);
    _resetPin = 1;
    //Reset idle to start bit. 
    _clockPin = 1;
    wait_ms(300);
}
void soundboard::play(int trackNum)
{
    sendCommand(trackNum);
    while(_busyPin==1);
}
void soundboard::playAsync(int trackNum )
{
    sendCommand(trackNum);
}
void soundboard::stop(void)
{
    sendCommand(STOP);
}
void soundboard::pause(void)
{
    sendCommand(PLAY_PAUSE);
}
void soundboard::setVolume(int Volume)
{
    sendCommand(Volume);
}
void soundboard::sendCommand(unsigned int cmd)
{
    _clockPin = 0;
    wait_ms(2);
    for (unsigned int mask = 0x8000; mask>0; mask>>=1)
    {
        _clockPin=0;
        wait_us(50);
        if(cmd&mask)
        {
            _dataPin = 1;
        }
        else
        {
            _dataPin = 0;
        }
        wait_us(50);
        _clockPin=1;
        wait_us(100);
        if(mask>0x0001)
        {
            wait_ms(2);
        }
    }
    wait_ms(20);
}
void soundboard::playPerhapsAsync(int trackNum)
{
    if(!_busyPin)
    {
        playAsync(trackNum);
    }
}
