#ifndef MBED_ULTRASONIC_H
#define MBED_ULTRASONIC_H

#include "mbed.h"

class ultrasonic
{
    public:
        ultrasonic(PinName trigPin, PinName echoPin, float updateSpeed, float timeout);
        ultrasonic(PinName trigPin, PinName echoPin, float updateSpeed, float timeout, void onUpdate(int), void onTrig(void),void onStartTimer(void)/*, Timer *t*/ );
        int getCurrentDistance(void);
        void pauseUpdates(void);
        void startUpdates(void);
        void attachOnUpdate(void method(int));
        void attachOnTrigger(void method(void));
        void attachOnStartTimer(void method(void));
        void changeUpdateSpeed(float updateSpeed);
        int isUpdated(void);
        float getUpdateSpeed();
    private:
        DigitalOut _trig;
        InterruptIn _echo;
        Timer _t;
        Timeout _tout;
        int _distance;
        float _updateSpeed;
        int start;
        int end;
        volatile int done;
        void (*_onUpdateMethod)(int);
        void (*_onTriggerMethod)(void);
        void (*_onStartTimerMethod)(void);
        void _startT(void);
        void _updateDist(void);
        void _startTrig(void);
        float _timeout;

        int d;
        /*unsigned int tickcount;
        Ticker _ticker;
        void ticktock(void);*/
};
#endif