 #include "ultrasonic.h"
    
    ultrasonic::ultrasonic(PinName trigPin, PinName echoPin, float updateSpeed, float timeout):_trig(trigPin), _echo(echoPin)
    {
        printf("ultrasonic (wo methods)\r\n");
        _updateSpeed = updateSpeed;
        _timeout = timeout;
    }
    
    ultrasonic::ultrasonic(PinName trigPin, PinName echoPin, float updateSpeed, float timeout, void onUpdate(int), void onTrig(void),void onStartTimer(void)/*, Timer *t*/ )
    :_trig(trigPin), _echo(echoPin)
    {
        printf("ultrasonic(with methods)\r\n");
        _onUpdateMethod=onUpdate;
        _onTriggerMethod=onTrig;
        _onStartTimerMethod=onStartTimer;
        _updateSpeed = updateSpeed;
        _timeout = timeout;
        _t.start ();
        //_ticker.attach_us(this,&ultrasonic::ticktock, 10);
        //_t = t;
    }
    void ultrasonic::_startT(){ 
        //_t.reset ();
        start = _t.read_us ();
//        _t.start();  
        (*_onStartTimerMethod)();            
       // printf("_startT %d\r\n", tickcount);

        return;
    }
        
    void ultrasonic::_updateDist()
    {
        end = _t.read_us ();
        done = 1;
        //_t.stop();
       // printf("_t.read_us()=%d\r\n", _t.read_us());
       // printf("_t.read() = %f\r\n", _t.read());
      //  printf("_t.read_us()=%d\r\n", _t.read_us());
      //  printf("_t.read() = %f\r\n", _t.read());
        _distance = (end - start)/6;       
         
        //_t.reset();
        _tout.detach();
        _tout.attach(this,&ultrasonic::_startTrig, _updateSpeed);
        (*_onUpdateMethod)(_distance);          
    }
    void ultrasonic::_startTrig(void)
    {
            _tout.detach();
            //printf("_startTrig\r\n");
            _trig=1;             
            wait_us(10);        
            done = 0;            
            _echo.rise(this,&ultrasonic::_startT);   
            _echo.fall(this,&ultrasonic::_updateDist);
            _echo.enable_irq ();
            _tout.attach(this,&ultrasonic::_startTrig,_timeout);
            _trig=0;   

                      
    }
    
    int ultrasonic::getCurrentDistance(void)
    {
        //printf("getCurrDistance\r\n");
        return _distance;
    }
    void ultrasonic::pauseUpdates(void)
    {
        //printf("pauseUpdates\r\n");
        _tout.detach();
        _echo.rise(NULL);
        _echo.fall(NULL);
    }
    void ultrasonic::startUpdates(void)
    {
        //printf("startUpdates\r\n");
        _startTrig();
 /*       while (1)
        {
        
                    while (done == 0)
            {
            }
 //       printf("_updateDist- t=%f, %d\r\n", _t.read(), start);
 //       printf("_updateDist- t=%d, %d\r\n", end, start);
        printf("_updateDist- dist=%d\r\n", _distance);
        }*/
    }
    void ultrasonic::attachOnUpdate(void method(int))
    {
        _onUpdateMethod = method;
    }
    void ultrasonic::attachOnTrigger(void method(void))
    {
        _onTriggerMethod = method;
    }
    void ultrasonic::attachOnStartTimer(void method(void))
    {
        _onStartTimerMethod = method;
    }
    void ultrasonic::changeUpdateSpeed(float updateSpeed)
    {
        _updateSpeed = updateSpeed;
    }
    float ultrasonic::getUpdateSpeed()
    {
        return _updateSpeed;
    }
    
    /*void ultrasonic::ticktock(void)
    {
        tickcount += 1;
    }*/
    int ultrasonic::isUpdated(void)
    {
        d=done;
        done = 0;
        return d;
    }
