#include "mbed.h"

/*------------------------------------------------------------------------------
Before to use this example, ensure that you an hyperterminal installed on your
computer. More info here: https://developer.mbed.org/handbook/Terminals

The default serial comm port uses the SERIAL_TX and SERIAL_RX pins (see their
definition in the PinNames.h file).

The default serial configuration in this case is 9600 bauds, 8-bit data, no parity

If you want to change the baudrate for example, you have to redeclare the
serial object in your code:

Serial pc(SERIAL_TX, SERIAL_RX);

Then, you can modify the baudrate and print like this:

pc.baud(115200);
pc.printf("Hello World !\n");
------------------------------------------------------------------------------*/

DigitalOut led(LED1);

class A {
    public:
    void print(void) {
        printf("A=%d\n",1);
    }
};

class B : public A {
    public:
    void print(void) {
        printf("B=%d\n",2);
    }
};

char mystring[] = "A String";
char mystring2[] = "B_String";
short myshort = 123;

unsigned getLength(char *p) {
    unsigned len = 0;
    while(p[len++]);
    return len-1;
}

void changeShort(short *s) {
    *s = 321;
}

void changeString(char **p) {
    *p = mystring2;
}

void change(char *p) {
    char newstr[] = "CSE360";
    int i = 0;
    while(p[i]) {
        p[i] = newstr[i];
        i++;
    }
    p[i] = 0;
}

int main(void)
{
    printf("Hello World !\n");
    
    change(mystring);
    char *p = 0;
    p = (char*)mystring;
    
    A a;
    B b, b1;

    while(true) {
        wait(1); // 1 second
        led = !led; // Toggle LED
//        printf("This program runs since \"%d\" seconds.\n", getLength(mystring));
        changeShort(&myshort);
        printf("myshort = \"%d\".\n", myshort);
        char *z = (char*)&myshort;
//        changeString(p);
        printf("myshort[0] = \"%x\", myshort[1] = \"%x\".\n", z[0],z[1]);
        printf("mystring2 = %s\n", p);
        a.print();
        b.print();
        ((A)b1).print();
    }
}

