#include "mbed.h"

Ticker toggle_led_ticker;
InterruptIn SW7(PB_3);
InterruptIn SW6(PA_10);
float tikerhastighet=0.1;
DigitalOut led1(PA_9);
Timeout    timeOutIrq;

void toggle_led() 
{
    led1 = !led1;
}

void enableKnappeTrykk(){
    SW7.enable_irq();
    SW6.enable_irq();
}


void sw7Trykket()
{
    SW7.disable_irq();
    timeOutIrq.attach(&enableKnappeTrykk,.5);
    tikerhastighet=tikerhastighet-.01f;
    toggle_led_ticker.attach(&toggle_led, tikerhastighet);
}

void sw6Trykket()
{
    SW6.disable_irq();
    timeOutIrq.attach(&enableKnappeTrykk,.5);
    tikerhastighet=tikerhastighet+.01f;
    toggle_led_ticker.attach(&toggle_led, tikerhastighet);

}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.1);
    while (true) 
    {    
        SW6.fall(&sw6Trykket);
        SW7.fall(&sw7Trykket);
        
    }
}