#include "mbed.h"

Timeout    onTime;
Ticker     periodTimer;
DigitalOut led(PA_9); 
InterruptIn SW7(PB_3);
InterruptIn SW6(PA_10);

float periodTime=0.020;  // 20ms period time (50Hz)
float dutyCycle=.05;

void TurnLightOff()
{   led=1;
}

void SW7Trykk(){
    dutyCycle=dutyCycle+.1f;
}

void SW6Trykk(){
    
    dutyCycle=dutyCycle-.1f;
    if(dutyCycle<=0.1)
    {
        dutyCycle=0.1;    
    }
    
}

void TurnLightOn()
{   led=0;
    onTime.attach(&TurnLightOff,(float)periodTime*dutyCycle);
}

int main()
{
    periodTimer.attach(&TurnLightOn,periodTime);

    while(1) {
        SW7.fall(&SW7Trykk);
        SW6.fall(&SW6Trykk);
        wait(1);
    }
}
