/*************************************************** 
  This is a library for the MLX90614 Temp Sensor
  Designed specifically to work with the MLX90614 sensors in the
  adafruit shop
  ----> https://www.adafruit.com/products/1748
  ----> https://www.adafruit.com/products/1749
  These sensors use I2C to communicate, 2 pins are required to  
  interface
  Adafruit invests time and resources providing this open source code, 
  please support Adafruit and open-source hardware by purchasing 
  products from Adafruit!
  Written by Limor Fried/Ladyada for Adafruit Industries.  
  BSD license, all text above must be included in any redistribution
 ****************************************************/

#include "my_mlx.h"

//Adafruit_MLX90614::Adafruit_MLX90614(uint8_t i2caddr) {
//  _addr = i2caddr;
//}

Adafruit_MLX90614::Adafruit_MLX90614(PinName sda, PinName scl)
{
    i2c_ = new I2C(sda, scl);
    i2c_->frequency(400000);
}

Adafruit_MLX90614::Adafruit_MLX90614(I2C *i2c) : i2c_(i2c) {
    }

Adafruit_MLX90614::~Adafruit_MLX90614() {
    delete i2c_;
    }

//////////////////////////////////////////////////////


double Adafruit_MLX90614::readObjectTempF(void) {
  return (readTemp(MLX90614_TOBJ1) * 9 / 5) + 32;
}


double Adafruit_MLX90614::readAmbientTempF(void) {
  return (readTemp(MLX90614_TA) * 9 / 5) + 32;
}

double Adafruit_MLX90614::readObjectTempC(void) {
  return readTemp(MLX90614_TOBJ1);
}


double Adafruit_MLX90614::readAmbientTempC(void) {
  return readTemp(MLX90614_TA);
}

float Adafruit_MLX90614::readTemp(uint8_t reg) {
  float temp;
  
  temp = read16(reg);
  temp *= .02;
  temp  -= 273.15;
  return temp;
}

/*********************************************************************/

uint16_t Adafruit_MLX90614::read16(uint8_t a) {
  uint16_t ret;
  char cmd[3] = { 0 };

  //Wire.beginTransmission(_addr); // start transmission to device
  i2c_->write(_addr,cmd,1,true); 
  //Wire.write(a); // sends register address to read from
  //Wire.endTransmission(false); // end transmission
  
 // Wire.requestFrom(_addr, (uint8_t)3);// send data n-bytes read
  ret = i2c_->read(_addr,cmd,3); // receive DATA
  ret |= i2c_->read(_addr,cmd,3) << 8; // receive DATA

  uint8_t pec = i2c_->read(_addr,cmd,3);

  return ret;
}