// Listener - print sender messages
// From Tnode/Tsender @ anarduino.com
// 2014 - anarduino.com
//
#include "mbed.h"
#include "RFM69.h"
#include "definitions.h"

#define NETWORK_ID          101
#define BOXRADIO_ID         69
#define NODE_ID             55
#define FREQUENCY_915MHZ    91

// Uncomment only one of the following three to match radio frequency
//#define FREQUENCY     RF69_433MHZ    
//#define FREQUENCY     RF69_868MHZ
#define FREQUENCY     RF69_915MHZ

//#define IS_RFM69HW   //NOTE: uncomment this ONLY for RFM69HW or RFM69HCW
#define ENCRYPT_KEY    "EncryptKey123456"  // use same 16byte encryption key for all devices on net
#define ACK_TIME       50                  // max msec for ACK wait
#define SERIAL_BAUD    115200
#define VERSION  "1.0"

#define MSGBUFSIZE 64   // message buffersize, but for this demo we only use: 
                        // 1-byte NODEID + 4-bytes for time + 1-byte for temp in C + 2-bytes for vcc(mV)

Serial pc(PA_9, PA_10);
DigitalOut myled(PC_13);
DigitalOut but(PA_1, PullUp);
//RFM69::RFM69(PinName  PinName mosi, PinName miso, PinName sclk,slaveSelectPin, PinName int)
RFM69 radio(PB_15, PB_14, PB_13, PB_12, PA_8);

bool promiscuousMode = false; // set 'true' to sniff all packets on the same network
bool requestACK=false;
//packet_t data;
uint8_t data[sizeof(packet_t)];
Timer tmr;

main() {
  uint8_t theNodeID;
  tmr.start();

  pc.baud(SERIAL_BAUD);
//  pc.printf("\r\nListener %s startup at %d Mhz...\r\n",VERSION,(FREQUENCY==RF69_433MHZ ? 433 : FREQUENCY==RF69_868MHZ ? 868 : 915));
  wait(1);
  radio.initialize(RF69_915MHZ, BOXRADIO_ID, NETWORK_ID);
  radio.encrypt(0);
  radio.promiscuous(promiscuousMode);
//  pc.printf("Frequency at %d\r\n", radio.getFrequency());
//  pc.printf("Temp at %ld\r\n", sizeof(packet_t));// radio.readTemperature(0));
  radio.setPowerLevel(20);
#ifdef IS_RFM69HW
  radio.setHighPower(); //uncomment #define ONLY if radio is of type: RFM69HW or RFM69HCW 
#endif
  bool box = true;

while(1) {
  if (radio.receiveDone()) {
//     pc.printf("Received from TNODE: %d \r\n",radio.SENDERID);
    memcpy(&data, (uint8_t *)radio.DATA, sizeof(packet_t));
    theNodeID = radio.SENDERID;
    pc.putc(theNodeID);
    for(int i = 0; i < sizeof(data); i++)
        pc.putc(data[i]);

     //pc.printf("temperature = %d\r\n",data.temp.motor);
//     pc.printf("speed=%d\r\n", data.data_10hz[0].speed);
//     pc.printf("speed=%d\r\n", data.data_10hz[1].speed);
//     pc.printf("rpm=%d\r\n", data.data_10hz[0].rpm);
//     pc.printf("rpm=%d\r\n", data.data_10hz[1].rpm);
//     pc.printf("flags=%d\r\n", data.data_10hz[0].flags);
//     pc.printf("flags=%d\r\n", data.data_10hz[1].flags);
//     pc.printf("time=%d\r\n", data.data_saved);
//     pc.printf("imu acc x =%d\r\n", data.imu[0].acc_x);
//     pc.printf("imu acc y =%d\r\n", data.imu[0].acc_y);
//     pc.printf("imu acc z =%d\r\n", data.imu[0].acc_z);
//     pc.printf("imu dps x =%d\r\n", data.imu[0].dps_x);
//     pc.printf("imu dps y =%d\r\n", data.imu[0].dps_y);
//     pc.printf("imu dps z =%d\r\n", data.imu[0].dps_z);
     if (radio.ACKRequested()){
        theNodeID = radio.SENDERID;
        radio.sendACK();
    }
    
    myled = !myled;
//        pc.printf(" - ACK sent. Receive RSSI: %d\r\n",radio.RSSI);
//     } else pc.printf("Receive RSSI: %d\r\n",radio.RSSI);
  }
//         myled = !myled; 
 }
}
