#include "mbed.h"
#include "USBJoystick.h"

USBJoystick joystick;
// Variables for Heartbeat and Status monitoring
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);
#define IN_UP PC_0
#define IN_RIGHT PC_1
#define IN_DOWN PB_0
#define IN_LEFT PA_4

#define UP 0x01
#define RIGHT 0x02
#define DOWN 0x04
#define LEFT 0x08
#ifdef TARGET_STM32F4
BusIn hatin(PC_0, PC_1, PB_0, PA_4);
BusIn buttonin(PH_0, PA_15, PB_7, PH_1, PC_3, PC_2, PC_15, PC_14, PA_13, PA_14);
DigitalIn psbutton(PC_12);
#endif
#ifdef TARGET_KL25Z
BusIn hatin(PTC1, PTC2, PTB3, PTB2);
BusIn buttonin(PTE30, PTE29, PTE23, PTE22, PTE21, PTE20, PTE5, PTE4, PTE3, PTE2);
DigitalIn psbutton(PTB8);
DigitalOut extraGround(PTD3);
#endif

//Ticker heartbeat;

// Heartbeat monitor
/*
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}
*/

int main() {
    hatin.mode(PullUp);
    buttonin.mode(PullUp);
    psbutton.mode(PullUp);
    #ifdef TARGET_KL25Z
    extraGround.write(0);
    #endif
    heartbeatLED = 0;
    #define UPDATEINTERVAL 0.002
    int i = 0;
    int16_t throttle = 0;
    int16_t rudder = 0;    
    int16_t x = 0;
    int16_t y = 0;

    int16_t button = 0;    
    int8_t hat = 0;
    int8_t hat_reverse = 0;    
    int8_t isUp = 0;
    int8_t isDown = 0;
    int8_t isLeft = 0;
    int8_t isRight = 0;
    int16_t ps = 0;
    
    //heartbeat_start();

    while (1) {

        throttle = 0;
        rudder = 0;
        x = 0;
        y = 0;
        
        button = 0;
        button = ( ~buttonin) & 0x03ff;
        ps = (psbutton)? 0 : 1;
        button |= ( ps << 12);
        hat_reverse = (~hatin) & 0x0F ;        
        isUp = isDown = isLeft = isRight = 0;
        if (hat_reverse & DOWN){
            isDown = 1;
        }
        if (hat_reverse & UP){
            isUp =1;
            isDown = 0;
        }
        
        if (hat_reverse & RIGHT){
            isRight = 1;
        }
        if (hat_reverse & LEFT){
            isLeft = 1;
        }
        if (isLeft && isRight){
            isLeft = 0;
            isRight = 0;
        }
        
        if (isUp && isLeft) {
            hat = 7;
        } else if (isUp && isRight){
            hat = 1;
        } else if (isDown && isLeft){
            hat = 5;
        } else if (isDown && isRight){
            hat = 3;
        } else if (isUp){
            hat = 0;
        } else if (isDown){
            hat = 4;
        } else if (isRight){
            hat = 2;
        } else if (isLeft){
            hat = 6;
        } else {
            hat = 9;
        }
        
        joystick.update(throttle, rudder, x, y, button, hat);
        i = (i + 1) % 500 ;
        if (i == 0){
              heartbeatLED = !heartbeatLED;                
        }      
        wait(UPDATEINTERVAL);
    }
                     
}