//交流ロボコンロボット側プログラム
#include "mbed.h"

PwmOut moter[] = {p23,p24};
BusOut selecter(p5,p6,p7,p8,p9,p10,p11,p12);
Serial pc(USBTX,USBRX);
Serial mc(p28,p27);
#define pi 3.141592

int main() {
    uint8_t data_r1,data_r2,data_l1,data_l2,sw_data5,sw_data6,start;
    uint8_t select_r,select_l,select_all,check,checker;
    double signal_r,signal_l;
    
    while(1){
        //初期化
        select_r = 0;
        select_l = 0;
        signal_r = 0;
        signal_l = 0;
        //受信部
        start = mc.getc();
        data_r1 = mc.getc();
        data_r2 = mc.getc();
        data_l1 = mc.getc();
        data_l2 = mc.getc();
        sw_data5 = mc.getc();
        sw_data6 = mc.getc();
        check = mc.getc();
        //加工    
           if(start == 255){
                if(data_r1 != 0){
                    signal_r = data_r1/200.0000;
                    select_r = 16;
                }else if(data_r2 != 0){
                    signal_r = data_r2/200.0000;
                    select_r = 32;
                }
                if(data_l1 != 0){
                    signal_l = data_l1/200.0000;
                    select_l = 64;
                }else if(data_l2 != 0){
                    signal_l = data_l2/200.0000;
                    select_l = 128;
                }
            }
            else  {
                moter[0] = 0;
                moter[1] = 0;
                selecter = 0;
                }
            //Right
            if (signal_r >= 0.6) {
                signal_r = 1;
            }else if(signal_r >= 0.3) {
                signal_r = 0.5;
            }else {
                signal_r = 0;
            }//Left
            if (signal_l >= 0.6) {
                signal_l= 1;
            }else if(signal_l >= 0.3) {
                signal_l = 0.5;
            }else {
                signal_l = 0;
            }
            
                checker = data_r1^data_r2^data_l1^data_l2^sw_data5^sw_data6;
                select_all = sw_data5+sw_data6+select_r+select_l;
                                    
                pc.printf("%u_%u_%u_%u_%u_%u_%u_%u\n",start,data_r1,data_r2,data_l1,data_l2,sw_data5,sw_data6,select_all);
                             
                if(check == checker){
                    moter[0] = signal_r;
                    moter[1] = signal_l;
                    selecter = select_all;
                }
            }
        }
  