// module PWM433Mhz
// Edgar Huckert 08-2019
// V2.0 - is OK
//
// Uses a HC-2 433Mhz module to receive bytes (9600 Baud)
// Uses PWM(500 Hz) to control an ESC for a brushless motor 
// The ESC is: Robbe 
// The brushless motor is: Simprop Magic Torque
//
// on the other side (remote control sender):
// HC-12 module used in TX direction (RX pin connected to Arduino TX)
// Arduino Nano used as USB-Serial (5V) converter
// On PC/Laptop (Windows): TeraTerm with pseudo serial(USB) port
//
#include "mbed.h"
//
DigitalOut myled(LED1);
PwmOut PWM1(p23);
Serial ser(p28, p27); // RX from HC-12 on pin 27
float rxVal = 0.5;
float rxValTable[10] =
{
    0.0, 0.50, 0.55, 0.60, 0.65,
    0.70, 0.75, 0.80, 0.85, 0.90
};

// ----------------------------------------------
// the callback routine: receives bytes from the HC-12 module
// Received bytes in range '0' - '9'
// Sets the global variable rxVal
void gotBytes()
{
    char ch = ser.getc();
    // normalize the received char (byte) to the range '0 - '9'
    ch = ch & 0x7f;
    printf("ori %c", ch);
    if (ch <= ' ') ch = '0';
    if (ch < '0')  ch = '0';
    if (ch > '9')  ch = '9';
    rxVal = rxValTable[ch - '0'];
    printf(" %c", ch);
    printf(" rxVal=%f\r\n", rxVal);
    return;
}   // end gotBytes()
    
// ---------------------------------------
void initMotor()
{
    // configure the serial interface connected to a HC-12 module (433MHz)
    printf("configure ser.interf. for HC-12\r\n");
    // register the call back routine
    ser.attach(& gotBytes);
    ser.baud(9600);
    ser.format(8, SerialBase::None, 1);
    //
    // start PWM on pin 23
    printf("initMotor()\r\n");
    PWM1.period(0.002); // set PWM period to 2 ms=500 Hz
    PWM1 = 0.5;         // duty cycle 50%
    for (int n=0; n < 5; n++)
    {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
    printf("initMotor() OK\r\n");
}   // end initMotor()

// ----------------------------------------
// S1ets a new PWM duty value
// parameter val: the new duty cycle
void driveMotor(float val)
{
    printf("duty cycle=%f\r\n", val);
    // set the duty cycle value 
    PWM1 = val;         // set duty cycle 
}   // end driveMotor()

// ----------------------------------------
int main() 
{
    float oldRxVal = rxVal;
    unsigned count = 0;
    //
    printf("PWM433Mhz starting...\r\n");
    //
    initMotor();
    //
    // Note: the control bytes varying the PWM ducty cycle
    //       are received in callback routine gotBytes()
    while (1)
    {
      if (rxVal != oldRxVal)
        driveMotor(rxVal);
      oldRxVal = rxVal;
      wait(0.333);
      count++;
      if ((count % 100) == 0)
        printf("alive\r\n");
    }
}   // end main()
