#ifndef MBED_LPH88LCD_H
#define MBED_LPH88LCD_H

#include "mbed.h"

class LPH88LCD {
    
    public:

    LPH88LCD(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName rst, PinName rs);

    virtual void orientation(bool rotate, bool mirror);
    virtual void reset();
    virtual void set_8bit_mode(char BGR);
    virtual void set_16bit_mode(void);
    virtual void set_8_color_mode(void);
    virtual void set_65k_color_mode(void);

    void fillrectangle(unsigned int x0, unsigned int y0, unsigned int x1, unsigned int y1, unsigned int color);
    void drawpixel(unsigned int x, unsigned int y, unsigned int color);
    void drawline(unsigned int x0, unsigned int y0, unsigned int x1, unsigned int y1, unsigned int color);
    void drawrectangle(unsigned int x0, unsigned int y0, unsigned int x1, unsigned int y1, unsigned int color);
    void fillcircle(unsigned int x0, unsigned int y0, unsigned int radius, unsigned int color);
    void drawcircle(unsigned int x0, unsigned int y0, unsigned int radius, unsigned int color);
    unsigned int putc(unsigned int x, unsigned int y, unsigned int c, unsigned int size, unsigned int font, unsigned int color, unsigned int bgcolor);
    void drawtext(unsigned int x, unsigned int y, char* text, unsigned int size,unsigned int font, unsigned int color, unsigned int bgcolor);
    void scroll(char offset);
    void cls();
    void rectangle8(char x1, char y1, char x2, char y2, char color);
    void putpixel(unsigned char r,unsigned char g,unsigned char b, unsigned char x, unsigned char y);
    void put_char8(char x, char y, char symbol, char color, char bkcolor);
    void put_string8(char x, char y, char* text, char color, char bkcolor);
    void draw_table(void);
    
private:

SPI _spi(PinName mosi, PinName miso, PinName sclk);
DigitalOut _rst(PinName rst);
DigitalOut _cs(PinName cs);
DigitalOut _rs(PinName rs);

int _row,_column,_rows,_columns,_width, _height;
bool _rotate,_mirror ;
int _font,_foreground, _background;

void write_cmdRG(uint8_t reg, uint8_t param);
void write_cmd8(uint8_t cmd8);
    void write_cmd16(uint16_t cmd16);
    void write_data8(char data);
    void write_data16(uint16_t cmd16);
    void draw(uint16_t cmd16) ;
    void drawstop(void);
    void drawstart(void);

    void foreground(unsigned int color);
    void background(unsigned int color);

    void locate(int column, int row);
    void newline();
    int columns();
    int rows();
    void set_cursor(unsigned int x, unsigned int y);
    void set_window(char x0, char y0, char x1,char y1);

};

#endif