#include "mbed.h"
#include "ads1299.h"

SPI spi(SPI_MOSI,SPI_MISO,SPI_SCK);
DigitalOut  CS(PA_4);
InterruptIn DRDY(PA_2);  

long ADS129X_data[9];
bool ADS129X_newData;
void ADS129X_dataReadyISR();
 
void SPI_INIT(void){
    spi.format(8,1);
    spi.frequency(1000000);
    }

void WAKEUP() {
    CS = 0;
    spi.write(ADS129X_CMD_WAKEUP);
    wait_us(2);
    CS = 1;  
    wait_us(2);   
    }

void STANDBY() {
    CS = 0;
    spi.write(ADS129X_CMD_STANDBY);
    wait_us(2);
    CS = 1;
    }

void RSET() {
    CS = 0;
    spi.write(ADS129X_CMD_RESET);
    wait_us(2);
    CS =1;
    wait_ms(10);  
    }

void START() {
  //  CS = 0;
    //spi.write(ADS129X_CMD_START);
  //  wait_us(2);
  //  CS = 1;
    RDATA();
    DRDY.fall(&ADS129X_dataReadyISR);
}
    
 
void RDATAC() {
    CS =0;;
    spi.write(ADS129X_CMD_RDATAC);
    wait_us(2);
    CS = 1;
    wait_us(2); //must way at least 4 tCLK cycles before sending another command (Datasheet, pg. 39)
    }
    
void SDATAC() {
    CS = 0;
    spi.write(ADS129X_CMD_SDATAC); //SDATAC
    wait_us(2);
    CS=1;
}

void RDATA() {
    CS =0;
    spi.write(ADS129X_CMD_RDATA);
    wait_us(2);
    CS=1;
    }

char RREG(char _address) {
    char opcode1 = ADS129X_CMD_RREG | (_address & 0x1F); //001rrrrr; _RREG = 00100000 and _address = rrrrr
    CS = 0; //Low to communicate
    spi.write(opcode1); //RREG
    spi.write(0x00); //opcode2
    wait_us(1);
    char data = spi.write(0x00); // read (Datasheet, pg.39)
    wait_us(2);
    CS =1; //High to end communication
    return data;
}

void RREG(char _address, char _numRegisters, char *_data) {
    char opcode1 = ADS129X_CMD_RREG | (_address & 0x1F); //001rrrrr; _RREG = 00100000 and _address = rrrrr
    CS = 0;  
    spi.write(ADS129X_CMD_SDATAC); //SDATAC
    spi.write(opcode1); //RREG
    spi.write(_numRegisters-1); //opcode2
    for(char i = 0; i < _numRegisters; i++){
        *(_data+i) = spi.write(0x00);  
    }
    wait_us(2);
    CS = 1;  
}

void WREG(char _address, char _value) {
    char opcode1 = ADS129X_CMD_WREG | (_address & 0x1F); //001rrrrr; _RREG = 00100000 and _address = rrrrr ds
    CS=0; //Low to communicate
    spi.write(opcode1);
    spi.write(0x00); // opcode2; only write one register
    spi.write(_value);
    wait_us(2);
    CS = 1; //Low to communicate
}

char getDeviceId() {
    CS=0; //Low to communicate
    spi.write(ADS129X_CMD_RREG); //RREG
    spi.write(0x00); 
    char data = spi.write(0x00); // byte to read (hopefully 0b???11110)
    wait_us(2);
    CS=1; //Low to communicate
    return data;
}

void Set_IRQ(){
   // DRDY.fall(&ADS129X_dataReadyISR);
    }

void ADS129X_dataReadyISR() {

    CS = 0;
    
    // status
    ((char*) ADS129X_data)[0*4+3] = 0;
    ((char*) ADS129X_data)[0*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[0*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[0*4+0] = spi.write(0x00);
    // channel 1
    ((char*) ADS129X_data)[1*4+3] = 0;
    ((char*) ADS129X_data)[1*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[1*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[1*4+0] = spi.write(0x00);
    // channel 2
    ((char*) ADS129X_data)[2*4+3] = 0;
    ((char*) ADS129X_data)[2*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[2*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[2*4+0] = spi.write(0x00);
    // channel 3
    ((char*) ADS129X_data)[3*4+3] = 0;
    ((char*) ADS129X_data)[3*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[3*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[3*4+0] = spi.write(0x00);
    // channel 4
    ((char*) ADS129X_data)[4*4+3] = 0;
    ((char*) ADS129X_data)[4*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[4*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[4*4+0] = spi.write(0x00);
    // channel 5
    ((char*) ADS129X_data)[5*4+3] = 0;
    ((char*) ADS129X_data)[5*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[5*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[5*4+0] = spi.write(0x00);
    // channel 6
    ((char*) ADS129X_data)[6*4+3] = 0;
    ((char*) ADS129X_data)[6*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[6*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[6*4+0] = spi.write(0x00);
    // channel 7
    ((char*) ADS129X_data)[7*4+3] = 0;
    ((char*) ADS129X_data)[7*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[7*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[7*4+0] = spi.write(0x00);
    // channel 8
    ((char*) ADS129X_data)[8*4+3] = 0;
    ((char*) ADS129X_data)[8*4+2] = spi.write(0x00);
    ((char*) ADS129X_data)[8*4+1] = spi.write(0x00);
    ((char*) ADS129X_data)[8*4+0] = spi.write(0x00);
    CS = 1;
    ADS129X_newData = true;
}
 
bool getData(long *buffer) {
    if(ADS129X_newData) {
       ADS129X_newData = false;
       for (int i = 0; i < 9; i++) {
            buffer[i] = ADS129X_data[i];
        }
        return true;
    }
    return false;
}



void configChannel(char _channel, bool _powerDown, char _gain, char _mux) {
    char value = ((_powerDown & 1)<<7) | ((_gain & 7)<<4) | (_mux & 7);
    WREG(ADS129X_REG_CH1SET + (_channel-1), value);
}
 































