#include "mbed.h"

#include "SSD1306-Library.h"
#include "FreeSans9pt7b.h"


Serial pc(USBTX, USBRX);

DigitalOut gpo(D0);
DigitalOut led(LED_RED);

/**************************************************
 * graphics_simple_demo
 **************************************************/
void graphics_simple_demo(SSD1306 display) {
    display.setRotation(0);
    display.clearDisplay();
    display.drawFastVLine(SSD1306_LCDWIDTH/2, 0, SSD1306_LCDHEIGHT, WHITE);
    display.display();

//    wait(1);
    display.clearDisplay();
    display.drawFastHLine(0, SSD1306_LCDHEIGHT/2, SSD1306_LCDWIDTH, WHITE);
    display.display();
}

/**************************************************
 * graphics_speed_demo
 **************************************************/
void graphics_speed_demo(SSD1306 display, bool trail) {
    display.setRotation(0);
    //display.clearDisplay();

    int32_t y = 0;
    int32_t delta_y = 1;

    for (int32_t x=0; x<display.width(); x++) {
    display.drawFastVLine(x, 0, y, WHITE);
    display.display();
    if (!trail)
        display.drawFastVLine(x, 0, y, BLACK);
    y += delta_y;
    if ((y<0) || (y >= display.height()))
        delta_y = -delta_y;
    }
}
/**************************************************
 * graphics_line_demo
 **************************************************/
void graphics_line_demo(SSD1306 display, int32_t count) {
    display.setRotation(0);
    display.clearDisplay();

    //int32_t y = 0;
    int32_t delta_y = 3;
    int32_t delta_x = 5;

    switch (count % 4) {
    //////////////////////////////////////////////////////////////////
    case 0:
        for (int32_t x=0; x<display.width(); x+=delta_x)
            display.drawFastVLine(x, 0, display.height(), WHITE);

        for (int32_t y=0; y<display.height(); y+=delta_y)
            display.drawFastHLine(0, y, display.width(), WHITE);
        break;
    //////////////////////////////////////////////////////////////////
    case 1:
        delta_y = 2;
        delta_x = 2;
        for (int32_t x=0; x<display.width(); x+=delta_x)
            display.drawFastVLine(x, 0, display.height(), WHITE);

        for (int32_t y=0; y<display.height(); y+=delta_y)
            display.drawFastHLine(0, y, display.width(), WHITE);
        break;
    //////////////////////////////////////////////////////////////////
    case 2:
        {
        int32_t w = display.width();
        int32_t h = display.height();
        delta_y = 4;
        delta_x = 4;
        for (int32_t x=0; x<w/2; x+=delta_x) {
            display.drawLine(w/2, h-x, w-x, h, WHITE);
            display.drawLine(w/2, h-x, x, h, WHITE);
        }
        display.drawLine(w/2, 0, w/2, h, WHITE);
        break;
        }
    //////////////////////////////////////////////////////////////////
    case 3:
        {
        int32_t w = display.width();
        int32_t h = display.height();
        delta_x = 4;
        display.drawLine(0, 0, w, 0, WHITE);
        for (int32_t x=0; x<w/2; x+=delta_x) {
            display.drawLine(w/2+x, 0, w, 2*(w-2*x)*x/h, WHITE);
            display.drawLine(w/2-x, 0, 0, 2*(w-2*x)*x/h, WHITE);
        }
        break;
        }
    }
    //////////////////////////////////////////////////////////////////

    display.display();
}

/**************************************************
 * graphics_demo
 **************************************************/
#define GDLOGO_W 111
#define GDLOGO_H  48

 const uint8_t gdLogo[GDLOGO_H/8 * GDLOGO_W] = { 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0xE0, 0xE0, 0xF0, 0xF0, 0xF8, 0xF8, 0xF8, 0xFC, 0xFC, 0xFC, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0xFC, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0x7C, 0xFC, 0xFC, 0xFC, 0xF8, 0xF8, 0xF8, 0xF0, 0xF0, 0xE0, 0xE0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
    0x00, 0x00, 0xC0, 0xF0, 0xFC, 0xFE, 0xFF, 0xFF, 0x3F, 0x1F, 0x0F, 0x07, 0x03, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0xFF, 0xFF, 0xFE, 0xF8, 0xF0, 0xC0, 0x00, 0x00,  
    0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8,  
    0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F,  
    0x00, 0x01, 0x07, 0x0F, 0x3F, 0x7F, 0xFF, 0xFF, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0xC0, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xC0, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC, 0xFF, 0xFF, 0x7F, 0x3F, 0x0F, 0x07, 0x01, 0x00,  
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x07, 0x0F, 0x0F, 0x1F, 0x1F, 0x1F, 0x3F, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3E, 0x3F, 0x3F, 0x3F, 0x1F, 0x1F, 0x1F, 0x0F, 0x0F, 0x07, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

void drawBitmap(SSD1306 display, int16_t x, int16_t y, const uint8_t *bitmap, int16_t w, int16_t h, uint16_t color) {

  int16_t i, j = (w + 7) / 8;
  uint8_t byte;

  for(i=0; i<w; i++ ) {
    for(j=0; j<h; j++) {
      if(j & 7)
        byte >>= 1;
      else
        byte = bitmap[w*j/8  + i];
      if(byte & 1)
    display.drawPixel(x+i, y+j, color);
    }
  }
}


void testdrawchar(SSD1306 display) {
  display.setTextSize(1);
  display.setTextColor(WHITE);
  display.setCursor(0,0);

  for (uint8_t i=0; i < 168; i++) {
    if (i % 21 == 20)
        display.write('\n');
    if (i != '\n')
        display.write(i);
  }
  display.display();
}

void doText(SSD1306 display, bool both=true) {
    display.setTextSize(1);
    display.setTextColor(WHITE);
    display.setCursor(0,both ? 0 : 12);
    display.println("Hello, world!");
    if (both)
    display.setTextColor(BLACK, WHITE); // 'inverted' text
    display.println("3.141592");
    if (both) {
        display.setTextSize(2);
        display.setTextColor(WHITE);
        display.print("0x"); display.println("DEADBEEF");
    }
    display.display();
}
 
 
void graphics_demo(SSD1306 display) {
    display.setRotation(0);

    display.clearDisplay();
    drawBitmap(display, 8, 16, gdLogo, GDLOGO_W, GDLOGO_H, 2);
    //display.startscrolldiagleft(3, 0x0F);
    display.display();
    wait(8);
    display.stopscroll();

    display.setFont(NULL);
    display.clearDisplay();
    display.fillCircle(display.width()/2, display.height()/2, display.height()/2-1, WHITE);
    display.display();
    wait(2);

    display.clearDisplay();
    display.drawFastVLine(0, 16, 32, WHITE);
    display.drawFastHLine(0, 16, 32, WHITE);
    display.display();
    wait(2);
    
    display.clearDisplay();
    testdrawchar(display);
    wait(4);
    
    display.clearDisplay();
    doText(display);
    wait(4);
    
    display.clearDisplay();
    display.setFont(&FreeSans9pt7b);
    doText(display, false);
    wait(2);
    
    
    display.startscrollleft(8, 0x0F);
    wait(4);
}



/**************************************************
 * main
 **************************************************/
int main()
{
    int32_t count = 0;
    pc.baud(115200);
    pc.printf("SSD1306 I2C Demo\r\n");
    
    SSD1306 display = SSD1306();
    display.begin(true);
    
    while (true) {
        gpo = !gpo; // toggle pin
        led = !led; // toggle led
        wait(1);
        graphics_line_demo(display, count);
        //graphics_simple_demo(display);
        //graphics_speed_demo(display, (count%3)==0);
        //graphics_demo(display);

        pc.printf("Count: %d\r\n", count);

        count++;
    }
}