#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
USBMouse mouse;
DigitalIn b1(PTC7);
Timer timer;

int main(void) {
    
    int16_t x = 0;
    int16_t y = 0;
    uint8_t button=0;
    int cswitch=0;

    while (true) {
        
        x=-(acc.getAccX()*10);
        y=acc.getAccY()*10;
        
        if(b1==1)
        {
            button=1;
            mouse.click(button);
            wait(.05);
        }
        else
        {button=0;}
        
       
        if((cswitch==1)&&(x==0)&&(y==0))
           {
                timer.start();
                while((cswitch==1)&&(timer.read()<=2))
                {
                        x=-(acc.getAccX()*10);
                        y=acc.getAccY()*10;
                        if((x!=0)||(y!=0))
                            {
                                cswitch=0;
                                timer.stop();
                            }
                }
                if(timer.read()>=2)
                    {
                        mouse.click(1);
                        wait(.05);
                        mouse.click(1);
                        timer.stop();
                        timer.reset();
                        cswitch=0;
                    }
            }
        
        if((x!=0)||(y!=0))
            {cswitch=1;}

        x=-(acc.getAccX()*10);
        y=acc.getAccY()*10;
        mouse.move(x, y);

        wait(0.005);
    }
}
