#include "mbed.h"
#include "sx127x.h"

#define RADIO_RESET                                 PC_2 //NorAm_Mote Reset_sx
#define RADIO_MOSI                                  PB_15 //NorAm_Mote SPI2 Mosi
#define RADIO_MISO                                  PB_14 //NorAm_Mote SPI2 Miso
#define RADIO_SCLK                                  PB_13 //NorAm_Mote  SPI2 Clk
#define RADIO_NSS                                   PB_12 //NorAm_Mote SPI2 Nss

#define RADIO_DIO_0                                 PC_6 //NorAm_Mote DIO0 
#define RADIO_DIO_1                                 PC_10 //NorAm_Mote DIO1 
#define RADIO_DIO_2                                 PC_8 //NorAm_Mote DIO2 
#define RADIO_DIO_3                                 PB_4 //NorAm_Mote DIO3 
#define RADIO_DIO_4                                 PB_5 //NorAm_Mote DIO4 
#define RADIO_DIO_5                                 PB_6 //NorAm_Mote DIO5

#define RADIO_ANT_SWITCH_RX                         PC_4 //NorAm_Mote RFSwitch_CNTR_1
#define RADIO_ANT_SWITCH_TX                         PA_4 //NorAm_Mote RFSwitch_CNTR_2

DigitalOut myled(PA_5);
DigitalOut RFSwitch_CNTR_1(PC_4);
DigitalOut RFSwitch_CNTR_2(PC_13);
DigitalOut PA_HIGH_Power(PD_2);
AnalogIn batt_volt(A1);

SX127x  radio(  RADIO_MOSI,   \
                RADIO_MISO,   \
                RADIO_SCLK,   \
                RADIO_NSS,    \
                RADIO_RESET,  \
                RADIO_DIO_0,  \
                RADIO_DIO_1,  \
                RADIO_ANT_SWITCH_RX ,    \
                RADIO_ANT_SWITCH_TX );

int n=0;

int main() {
    RFSwitch_CNTR_1 = 1;
    RFSwitch_CNTR_2 = 0;
    PA_HIGH_Power = 0;
      
    radio.init();
    radio.hw_reset();
    radio.set_frf_MHz(915.0);
    //TX Control Registers
    
    radio.write_reg(0x01,0x23); //RegOpMode OOK, TX mode
    radio.write_reg(0x09,0x8F); //RegPaConfig PA_BOOST, Max Power
    radio.write_reg(0x0A,0x19); //RegPaRamp Std PLL, 40uS (default)
    radio.write_reg(0x0B,0x37); //RegOcp OCP Enabled, 240mA
    radio.write_reg(0x24,0x07); //RegOsc OFF
    radio.write_reg(0x30,0x90); //RegPacketConfig1 Continuous Mode
    radio.write_reg(0x31,0x00); //RegPacketCongig2 Payload Length
    radio.write_reg(0x5A,0x87); //RegPaDac High Power


    while(1) {

        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(0.8); // 800 msec

    }
}
