/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_WDOG_REGISTERS_H__
#define __HW_WDOG_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 WDOG
 *
 * Generation 2008 Watchdog Timer
 *
 * Registers defined in this header file:
 * - HW_WDOG_STCTRLH - Watchdog Status and Control Register High
 * - HW_WDOG_STCTRLL - Watchdog Status and Control Register Low
 * - HW_WDOG_TOVALH - Watchdog Time-out Value Register High
 * - HW_WDOG_TOVALL - Watchdog Time-out Value Register Low
 * - HW_WDOG_WINH - Watchdog Window Register High
 * - HW_WDOG_WINL - Watchdog Window Register Low
 * - HW_WDOG_REFRESH - Watchdog Refresh register
 * - HW_WDOG_UNLOCK - Watchdog Unlock register
 * - HW_WDOG_TMROUTH - Watchdog Timer Output Register High
 * - HW_WDOG_TMROUTL - Watchdog Timer Output Register Low
 * - HW_WDOG_RSTCNT - Watchdog Reset Count register
 * - HW_WDOG_PRESC - Watchdog Prescaler register
 *
 * - hw_wdog_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_WDOG_BASE
#define HW_WDOG_INSTANCE_COUNT (1U) //!< Number of instances of the WDOG module.
#define REGS_WDOG_BASE (0x40052000U) //!< Base address for WDOG.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_STCTRLH - Watchdog Status and Control Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_STCTRLH - Watchdog Status and Control Register High (RW)
 *
 * Reset value: 0x01D3U
 */
typedef union _hw_wdog_stctrlh
{
    uint16_t U;
    struct _hw_wdog_stctrlh_bitfields
    {
        uint16_t WDOGEN : 1;           //!< [0]
        uint16_t CLKSRC : 1;           //!< [1]
        uint16_t IRQRSTEN : 1;         //!< [2]
        uint16_t WINEN : 1;            //!< [3]
        uint16_t ALLOWUPDATE : 1;      //!< [4]
        uint16_t DBGEN : 1;            //!< [5]
        uint16_t STOPEN : 1;           //!< [6]
        uint16_t WAITEN : 1;           //!< [7]
        uint16_t RESERVED0 : 2;        //!< [9:8]
        uint16_t TESTWDOG : 1;         //!< [10]
        uint16_t TESTSEL : 1;          //!< [11]
        uint16_t BYTESEL : 2;          //!< [13:12]
        uint16_t DISTESTWDOG : 1;      //!< [14]
        uint16_t RESERVED1 : 1;        //!< [15]
    } B;
} hw_wdog_stctrlh_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_STCTRLH register
 */
//@{
#define HW_WDOG_STCTRLH_ADDR     (REGS_WDOG_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_STCTRLH          (*(__IO hw_wdog_stctrlh_t *) HW_WDOG_STCTRLH_ADDR)
#define HW_WDOG_STCTRLH_RD()     (HW_WDOG_STCTRLH.U)
#define HW_WDOG_STCTRLH_WR(v)    (HW_WDOG_STCTRLH.U = (v))
#define HW_WDOG_STCTRLH_SET(v)   (HW_WDOG_STCTRLH_WR(HW_WDOG_STCTRLH_RD() |  (v)))
#define HW_WDOG_STCTRLH_CLR(v)   (HW_WDOG_STCTRLH_WR(HW_WDOG_STCTRLH_RD() & ~(v)))
#define HW_WDOG_STCTRLH_TOG(v)   (HW_WDOG_STCTRLH_WR(HW_WDOG_STCTRLH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_STCTRLH bitfields
 */

/*!
 * @name Register WDOG_STCTRLH, field WDOGEN[0] (RW)
 *
 * Enables or disables the WDOG's operation. In the disabled state, the watchdog
 * timer is kept in the reset state, but the other exception conditions can
 * still trigger a reset/interrupt. A change in the value of this bit must be held
 * for more than one WDOG_CLK cycle for the WDOG to be enabled or disabled.
 *
 * Values:
 * - 0 - WDOG is disabled.
 * - 1 - WDOG is enabled.
 */
//@{
#define BP_WDOG_STCTRLH_WDOGEN (0U)        //!< Bit position for WDOG_STCTRLH_WDOGEN.
#define BM_WDOG_STCTRLH_WDOGEN (0x0001U)   //!< Bit mask for WDOG_STCTRLH_WDOGEN.
#define BS_WDOG_STCTRLH_WDOGEN (1U)        //!< Bit field size in bits for WDOG_STCTRLH_WDOGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_WDOGEN field.
#define BR_WDOG_STCTRLH_WDOGEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WDOGEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_WDOGEN.
#define BF_WDOG_STCTRLH_WDOGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_WDOGEN), uint16_t) & BM_WDOG_STCTRLH_WDOGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WDOGEN field to a new value.
#define BW_WDOG_STCTRLH_WDOGEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WDOGEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field CLKSRC[1] (RW)
 *
 * Selects clock source for the WDOG timer and other internal timing operations.
 *
 * Values:
 * - 0 - WDOG clock sourced from LPO .
 * - 1 - WDOG clock sourced from alternate clock source.
 */
//@{
#define BP_WDOG_STCTRLH_CLKSRC (1U)        //!< Bit position for WDOG_STCTRLH_CLKSRC.
#define BM_WDOG_STCTRLH_CLKSRC (0x0002U)   //!< Bit mask for WDOG_STCTRLH_CLKSRC.
#define BS_WDOG_STCTRLH_CLKSRC (1U)        //!< Bit field size in bits for WDOG_STCTRLH_CLKSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_CLKSRC field.
#define BR_WDOG_STCTRLH_CLKSRC (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_CLKSRC))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_CLKSRC.
#define BF_WDOG_STCTRLH_CLKSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_CLKSRC), uint16_t) & BM_WDOG_STCTRLH_CLKSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLKSRC field to a new value.
#define BW_WDOG_STCTRLH_CLKSRC(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_CLKSRC) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field IRQRSTEN[2] (RW)
 *
 * Used to enable the debug breadcrumbs feature. A change in this bit is updated
 * immediately, as opposed to updating after WCT.
 *
 * Values:
 * - 0 - WDOG time-out generates reset only.
 * - 1 - WDOG time-out initially generates an interrupt. After WCT, it generates
 *     a reset.
 */
//@{
#define BP_WDOG_STCTRLH_IRQRSTEN (2U)      //!< Bit position for WDOG_STCTRLH_IRQRSTEN.
#define BM_WDOG_STCTRLH_IRQRSTEN (0x0004U) //!< Bit mask for WDOG_STCTRLH_IRQRSTEN.
#define BS_WDOG_STCTRLH_IRQRSTEN (1U)      //!< Bit field size in bits for WDOG_STCTRLH_IRQRSTEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_IRQRSTEN field.
#define BR_WDOG_STCTRLH_IRQRSTEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_IRQRSTEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_IRQRSTEN.
#define BF_WDOG_STCTRLH_IRQRSTEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_IRQRSTEN), uint16_t) & BM_WDOG_STCTRLH_IRQRSTEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IRQRSTEN field to a new value.
#define BW_WDOG_STCTRLH_IRQRSTEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_IRQRSTEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field WINEN[3] (RW)
 *
 * Enables Windowing mode.
 *
 * Values:
 * - 0 - Windowing mode is disabled.
 * - 1 - Windowing mode is enabled.
 */
//@{
#define BP_WDOG_STCTRLH_WINEN (3U)         //!< Bit position for WDOG_STCTRLH_WINEN.
#define BM_WDOG_STCTRLH_WINEN (0x0008U)    //!< Bit mask for WDOG_STCTRLH_WINEN.
#define BS_WDOG_STCTRLH_WINEN (1U)         //!< Bit field size in bits for WDOG_STCTRLH_WINEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_WINEN field.
#define BR_WDOG_STCTRLH_WINEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WINEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_WINEN.
#define BF_WDOG_STCTRLH_WINEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_WINEN), uint16_t) & BM_WDOG_STCTRLH_WINEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WINEN field to a new value.
#define BW_WDOG_STCTRLH_WINEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WINEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field ALLOWUPDATE[4] (RW)
 *
 * Enables updates to watchdog write-once registers, after the reset-triggered
 * initial configuration window (WCT) closes, through unlock sequence.
 *
 * Values:
 * - 0 - No further updates allowed to WDOG write-once registers.
 * - 1 - WDOG write-once registers can be unlocked for updating.
 */
//@{
#define BP_WDOG_STCTRLH_ALLOWUPDATE (4U)   //!< Bit position for WDOG_STCTRLH_ALLOWUPDATE.
#define BM_WDOG_STCTRLH_ALLOWUPDATE (0x0010U) //!< Bit mask for WDOG_STCTRLH_ALLOWUPDATE.
#define BS_WDOG_STCTRLH_ALLOWUPDATE (1U)   //!< Bit field size in bits for WDOG_STCTRLH_ALLOWUPDATE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_ALLOWUPDATE field.
#define BR_WDOG_STCTRLH_ALLOWUPDATE (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_ALLOWUPDATE))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_ALLOWUPDATE.
#define BF_WDOG_STCTRLH_ALLOWUPDATE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_ALLOWUPDATE), uint16_t) & BM_WDOG_STCTRLH_ALLOWUPDATE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ALLOWUPDATE field to a new value.
#define BW_WDOG_STCTRLH_ALLOWUPDATE(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_ALLOWUPDATE) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field DBGEN[5] (RW)
 *
 * Enables or disables WDOG in Debug mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Debug mode.
 * - 1 - WDOG is enabled in CPU Debug mode.
 */
//@{
#define BP_WDOG_STCTRLH_DBGEN (5U)         //!< Bit position for WDOG_STCTRLH_DBGEN.
#define BM_WDOG_STCTRLH_DBGEN (0x0020U)    //!< Bit mask for WDOG_STCTRLH_DBGEN.
#define BS_WDOG_STCTRLH_DBGEN (1U)         //!< Bit field size in bits for WDOG_STCTRLH_DBGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_DBGEN field.
#define BR_WDOG_STCTRLH_DBGEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_DBGEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_DBGEN.
#define BF_WDOG_STCTRLH_DBGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_DBGEN), uint16_t) & BM_WDOG_STCTRLH_DBGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DBGEN field to a new value.
#define BW_WDOG_STCTRLH_DBGEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_DBGEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field STOPEN[6] (RW)
 *
 * Enables or disables WDOG in Stop mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Stop mode.
 * - 1 - WDOG is enabled in CPU Stop mode.
 */
//@{
#define BP_WDOG_STCTRLH_STOPEN (6U)        //!< Bit position for WDOG_STCTRLH_STOPEN.
#define BM_WDOG_STCTRLH_STOPEN (0x0040U)   //!< Bit mask for WDOG_STCTRLH_STOPEN.
#define BS_WDOG_STCTRLH_STOPEN (1U)        //!< Bit field size in bits for WDOG_STCTRLH_STOPEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_STOPEN field.
#define BR_WDOG_STCTRLH_STOPEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_STOPEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_STOPEN.
#define BF_WDOG_STCTRLH_STOPEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_STOPEN), uint16_t) & BM_WDOG_STCTRLH_STOPEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOPEN field to a new value.
#define BW_WDOG_STCTRLH_STOPEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_STOPEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field WAITEN[7] (RW)
 *
 * Enables or disables WDOG in Wait mode.
 *
 * Values:
 * - 0 - WDOG is disabled in CPU Wait mode.
 * - 1 - WDOG is enabled in CPU Wait mode.
 */
//@{
#define BP_WDOG_STCTRLH_WAITEN (7U)        //!< Bit position for WDOG_STCTRLH_WAITEN.
#define BM_WDOG_STCTRLH_WAITEN (0x0080U)   //!< Bit mask for WDOG_STCTRLH_WAITEN.
#define BS_WDOG_STCTRLH_WAITEN (1U)        //!< Bit field size in bits for WDOG_STCTRLH_WAITEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_WAITEN field.
#define BR_WDOG_STCTRLH_WAITEN (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WAITEN))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_WAITEN.
#define BF_WDOG_STCTRLH_WAITEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_WAITEN), uint16_t) & BM_WDOG_STCTRLH_WAITEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WAITEN field to a new value.
#define BW_WDOG_STCTRLH_WAITEN(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_WAITEN) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field TESTWDOG[10] (RW)
 *
 * Puts the watchdog in the functional test mode. In this mode, the watchdog
 * timer and the associated compare and reset generation logic is tested for correct
 * operation. The clock for the timer is switched from the main watchdog clock
 * to the fast clock input for watchdog functional test. The TESTSEL bit selects
 * the test to be run.
 */
//@{
#define BP_WDOG_STCTRLH_TESTWDOG (10U)     //!< Bit position for WDOG_STCTRLH_TESTWDOG.
#define BM_WDOG_STCTRLH_TESTWDOG (0x0400U) //!< Bit mask for WDOG_STCTRLH_TESTWDOG.
#define BS_WDOG_STCTRLH_TESTWDOG (1U)      //!< Bit field size in bits for WDOG_STCTRLH_TESTWDOG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_TESTWDOG field.
#define BR_WDOG_STCTRLH_TESTWDOG (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_TESTWDOG))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_TESTWDOG.
#define BF_WDOG_STCTRLH_TESTWDOG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_TESTWDOG), uint16_t) & BM_WDOG_STCTRLH_TESTWDOG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTWDOG field to a new value.
#define BW_WDOG_STCTRLH_TESTWDOG(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_TESTWDOG) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field TESTSEL[11] (RW)
 *
 * Effective only if TESTWDOG is set. Selects the test to be run on the watchdog
 * timer.
 *
 * Values:
 * - 0 - Quick test. The timer runs in normal operation. You can load a small
 *     time-out value to do a quick test.
 * - 1 - Byte test. Puts the timer in the byte test mode where individual bytes
 *     of the timer are enabled for operation and are compared for time-out
 *     against the corresponding byte of the programmed time-out value. Select the
 *     byte through BYTESEL[1:0] for testing.
 */
//@{
#define BP_WDOG_STCTRLH_TESTSEL (11U)      //!< Bit position for WDOG_STCTRLH_TESTSEL.
#define BM_WDOG_STCTRLH_TESTSEL (0x0800U)  //!< Bit mask for WDOG_STCTRLH_TESTSEL.
#define BS_WDOG_STCTRLH_TESTSEL (1U)       //!< Bit field size in bits for WDOG_STCTRLH_TESTSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_TESTSEL field.
#define BR_WDOG_STCTRLH_TESTSEL (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_TESTSEL))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_TESTSEL.
#define BF_WDOG_STCTRLH_TESTSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_TESTSEL), uint16_t) & BM_WDOG_STCTRLH_TESTSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TESTSEL field to a new value.
#define BW_WDOG_STCTRLH_TESTSEL(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_TESTSEL) = (v))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field BYTESEL[13:12] (RW)
 *
 * This 2-bit field selects the byte to be tested when the watchdog is in the
 * byte test mode.
 *
 * Values:
 * - 00 - Byte 0 selected
 * - 01 - Byte 1 selected
 * - 10 - Byte 2 selected
 * - 11 - Byte 3 selected
 */
//@{
#define BP_WDOG_STCTRLH_BYTESEL (12U)      //!< Bit position for WDOG_STCTRLH_BYTESEL.
#define BM_WDOG_STCTRLH_BYTESEL (0x3000U)  //!< Bit mask for WDOG_STCTRLH_BYTESEL.
#define BS_WDOG_STCTRLH_BYTESEL (2U)       //!< Bit field size in bits for WDOG_STCTRLH_BYTESEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_BYTESEL field.
#define BR_WDOG_STCTRLH_BYTESEL (HW_WDOG_STCTRLH.B.BYTESEL)
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_BYTESEL.
#define BF_WDOG_STCTRLH_BYTESEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_BYTESEL), uint16_t) & BM_WDOG_STCTRLH_BYTESEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BYTESEL field to a new value.
#define BW_WDOG_STCTRLH_BYTESEL(v) (HW_WDOG_STCTRLH_WR((HW_WDOG_STCTRLH_RD() & ~BM_WDOG_STCTRLH_BYTESEL) | BF_WDOG_STCTRLH_BYTESEL(v)))
#endif
//@}

/*!
 * @name Register WDOG_STCTRLH, field DISTESTWDOG[14] (RW)
 *
 * Allows the WDOG's functional test mode to be disabled permanently. After it
 * is set, it can only be cleared by a reset. It cannot be unlocked for editing
 * after it is set.
 *
 * Values:
 * - 0 - WDOG functional test mode is not disabled.
 * - 1 - WDOG functional test mode is disabled permanently until reset.
 */
//@{
#define BP_WDOG_STCTRLH_DISTESTWDOG (14U)  //!< Bit position for WDOG_STCTRLH_DISTESTWDOG.
#define BM_WDOG_STCTRLH_DISTESTWDOG (0x4000U) //!< Bit mask for WDOG_STCTRLH_DISTESTWDOG.
#define BS_WDOG_STCTRLH_DISTESTWDOG (1U)   //!< Bit field size in bits for WDOG_STCTRLH_DISTESTWDOG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLH_DISTESTWDOG field.
#define BR_WDOG_STCTRLH_DISTESTWDOG (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_DISTESTWDOG))
#endif

//! @brief Format value for bitfield WDOG_STCTRLH_DISTESTWDOG.
#define BF_WDOG_STCTRLH_DISTESTWDOG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLH_DISTESTWDOG), uint16_t) & BM_WDOG_STCTRLH_DISTESTWDOG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DISTESTWDOG field to a new value.
#define BW_WDOG_STCTRLH_DISTESTWDOG(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLH_ADDR, BP_WDOG_STCTRLH_DISTESTWDOG) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_STCTRLL - Watchdog Status and Control Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_STCTRLL - Watchdog Status and Control Register Low (RW)
 *
 * Reset value: 0x0001U
 */
typedef union _hw_wdog_stctrll
{
    uint16_t U;
    struct _hw_wdog_stctrll_bitfields
    {
        uint16_t RESERVED0 : 15;       //!< [14:0]
        uint16_t INTFLG : 1;           //!< [15]
    } B;
} hw_wdog_stctrll_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_STCTRLL register
 */
//@{
#define HW_WDOG_STCTRLL_ADDR     (REGS_WDOG_BASE + 0x2U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_STCTRLL          (*(__IO hw_wdog_stctrll_t *) HW_WDOG_STCTRLL_ADDR)
#define HW_WDOG_STCTRLL_RD()     (HW_WDOG_STCTRLL.U)
#define HW_WDOG_STCTRLL_WR(v)    (HW_WDOG_STCTRLL.U = (v))
#define HW_WDOG_STCTRLL_SET(v)   (HW_WDOG_STCTRLL_WR(HW_WDOG_STCTRLL_RD() |  (v)))
#define HW_WDOG_STCTRLL_CLR(v)   (HW_WDOG_STCTRLL_WR(HW_WDOG_STCTRLL_RD() & ~(v)))
#define HW_WDOG_STCTRLL_TOG(v)   (HW_WDOG_STCTRLL_WR(HW_WDOG_STCTRLL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_STCTRLL bitfields
 */

/*!
 * @name Register WDOG_STCTRLL, field INTFLG[15] (RW)
 *
 * Interrupt flag. It is set when an exception occurs. IRQRSTEN = 1 is a
 * precondition to set this flag. INTFLG = 1 results in an interrupt being issued
 * followed by a reset, WCT later. The interrupt can be cleared by writing 1 to this
 * bit. It also gets cleared on a system reset.
 */
//@{
#define BP_WDOG_STCTRLL_INTFLG (15U)       //!< Bit position for WDOG_STCTRLL_INTFLG.
#define BM_WDOG_STCTRLL_INTFLG (0x8000U)   //!< Bit mask for WDOG_STCTRLL_INTFLG.
#define BS_WDOG_STCTRLL_INTFLG (1U)        //!< Bit field size in bits for WDOG_STCTRLL_INTFLG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_STCTRLL_INTFLG field.
#define BR_WDOG_STCTRLL_INTFLG (BITBAND_ACCESS16(HW_WDOG_STCTRLL_ADDR, BP_WDOG_STCTRLL_INTFLG))
#endif

//! @brief Format value for bitfield WDOG_STCTRLL_INTFLG.
#define BF_WDOG_STCTRLL_INTFLG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_STCTRLL_INTFLG), uint16_t) & BM_WDOG_STCTRLL_INTFLG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INTFLG field to a new value.
#define BW_WDOG_STCTRLL_INTFLG(v) (BITBAND_ACCESS16(HW_WDOG_STCTRLL_ADDR, BP_WDOG_STCTRLL_INTFLG) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_TOVALH - Watchdog Time-out Value Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_TOVALH - Watchdog Time-out Value Register High (RW)
 *
 * Reset value: 0x004CU
 */
typedef union _hw_wdog_tovalh
{
    uint16_t U;
    struct _hw_wdog_tovalh_bitfields
    {
        uint16_t TOVALHIGH : 16;       //!< [15:0]
    } B;
} hw_wdog_tovalh_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_TOVALH register
 */
//@{
#define HW_WDOG_TOVALH_ADDR      (REGS_WDOG_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_TOVALH           (*(__IO hw_wdog_tovalh_t *) HW_WDOG_TOVALH_ADDR)
#define HW_WDOG_TOVALH_RD()      (HW_WDOG_TOVALH.U)
#define HW_WDOG_TOVALH_WR(v)     (HW_WDOG_TOVALH.U = (v))
#define HW_WDOG_TOVALH_SET(v)    (HW_WDOG_TOVALH_WR(HW_WDOG_TOVALH_RD() |  (v)))
#define HW_WDOG_TOVALH_CLR(v)    (HW_WDOG_TOVALH_WR(HW_WDOG_TOVALH_RD() & ~(v)))
#define HW_WDOG_TOVALH_TOG(v)    (HW_WDOG_TOVALH_WR(HW_WDOG_TOVALH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_TOVALH bitfields
 */

/*!
 * @name Register WDOG_TOVALH, field TOVALHIGH[15:0] (RW)
 *
 * Defines the upper 16 bits of the 32-bit time-out value for the watchdog
 * timer. It is defined in terms of cycles of the watchdog clock.
 */
//@{
#define BP_WDOG_TOVALH_TOVALHIGH (0U)      //!< Bit position for WDOG_TOVALH_TOVALHIGH.
#define BM_WDOG_TOVALH_TOVALHIGH (0xFFFFU) //!< Bit mask for WDOG_TOVALH_TOVALHIGH.
#define BS_WDOG_TOVALH_TOVALHIGH (16U)     //!< Bit field size in bits for WDOG_TOVALH_TOVALHIGH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_TOVALH_TOVALHIGH field.
#define BR_WDOG_TOVALH_TOVALHIGH (HW_WDOG_TOVALH.U)
#endif

//! @brief Format value for bitfield WDOG_TOVALH_TOVALHIGH.
#define BF_WDOG_TOVALH_TOVALHIGH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_TOVALH_TOVALHIGH), uint16_t) & BM_WDOG_TOVALH_TOVALHIGH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOVALHIGH field to a new value.
#define BW_WDOG_TOVALH_TOVALHIGH(v) (HW_WDOG_TOVALH_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_TOVALL - Watchdog Time-out Value Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_TOVALL - Watchdog Time-out Value Register Low (RW)
 *
 * Reset value: 0x4B4CU
 *
 * The time-out value of the watchdog must be set to a minimum of four watchdog
 * clock cycles. This is to take into account the delay in new settings taking
 * effect in the watchdog clock domain.
 */
typedef union _hw_wdog_tovall
{
    uint16_t U;
    struct _hw_wdog_tovall_bitfields
    {
        uint16_t TOVALLOW : 16;        //!< [15:0]
    } B;
} hw_wdog_tovall_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_TOVALL register
 */
//@{
#define HW_WDOG_TOVALL_ADDR      (REGS_WDOG_BASE + 0x6U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_TOVALL           (*(__IO hw_wdog_tovall_t *) HW_WDOG_TOVALL_ADDR)
#define HW_WDOG_TOVALL_RD()      (HW_WDOG_TOVALL.U)
#define HW_WDOG_TOVALL_WR(v)     (HW_WDOG_TOVALL.U = (v))
#define HW_WDOG_TOVALL_SET(v)    (HW_WDOG_TOVALL_WR(HW_WDOG_TOVALL_RD() |  (v)))
#define HW_WDOG_TOVALL_CLR(v)    (HW_WDOG_TOVALL_WR(HW_WDOG_TOVALL_RD() & ~(v)))
#define HW_WDOG_TOVALL_TOG(v)    (HW_WDOG_TOVALL_WR(HW_WDOG_TOVALL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_TOVALL bitfields
 */

/*!
 * @name Register WDOG_TOVALL, field TOVALLOW[15:0] (RW)
 *
 * Defines the lower 16 bits of the 32-bit time-out value for the watchdog
 * timer. It is defined in terms of cycles of the watchdog clock.
 */
//@{
#define BP_WDOG_TOVALL_TOVALLOW (0U)       //!< Bit position for WDOG_TOVALL_TOVALLOW.
#define BM_WDOG_TOVALL_TOVALLOW (0xFFFFU)  //!< Bit mask for WDOG_TOVALL_TOVALLOW.
#define BS_WDOG_TOVALL_TOVALLOW (16U)      //!< Bit field size in bits for WDOG_TOVALL_TOVALLOW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_TOVALL_TOVALLOW field.
#define BR_WDOG_TOVALL_TOVALLOW (HW_WDOG_TOVALL.U)
#endif

//! @brief Format value for bitfield WDOG_TOVALL_TOVALLOW.
#define BF_WDOG_TOVALL_TOVALLOW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_TOVALL_TOVALLOW), uint16_t) & BM_WDOG_TOVALL_TOVALLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOVALLOW field to a new value.
#define BW_WDOG_TOVALL_TOVALLOW(v) (HW_WDOG_TOVALL_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_WINH - Watchdog Window Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_WINH - Watchdog Window Register High (RW)
 *
 * Reset value: 0x0000U
 *
 * You must set the Window Register value lower than the Time-out Value Register.
 */
typedef union _hw_wdog_winh
{
    uint16_t U;
    struct _hw_wdog_winh_bitfields
    {
        uint16_t WINHIGH : 16;         //!< [15:0]
    } B;
} hw_wdog_winh_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_WINH register
 */
//@{
#define HW_WDOG_WINH_ADDR        (REGS_WDOG_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_WINH             (*(__IO hw_wdog_winh_t *) HW_WDOG_WINH_ADDR)
#define HW_WDOG_WINH_RD()        (HW_WDOG_WINH.U)
#define HW_WDOG_WINH_WR(v)       (HW_WDOG_WINH.U = (v))
#define HW_WDOG_WINH_SET(v)      (HW_WDOG_WINH_WR(HW_WDOG_WINH_RD() |  (v)))
#define HW_WDOG_WINH_CLR(v)      (HW_WDOG_WINH_WR(HW_WDOG_WINH_RD() & ~(v)))
#define HW_WDOG_WINH_TOG(v)      (HW_WDOG_WINH_WR(HW_WDOG_WINH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_WINH bitfields
 */

/*!
 * @name Register WDOG_WINH, field WINHIGH[15:0] (RW)
 *
 * Defines the upper 16 bits of the 32-bit window for the windowed mode of
 * operation of the watchdog. It is defined in terms of cycles of the watchdog clock.
 * In this mode, the watchdog can be refreshed only when the timer has reached a
 * value greater than or equal to this window length. A refresh outside this
 * window resets the system or if IRQRSTEN is set, it interrupts and then resets the
 * system.
 */
//@{
#define BP_WDOG_WINH_WINHIGH (0U)          //!< Bit position for WDOG_WINH_WINHIGH.
#define BM_WDOG_WINH_WINHIGH (0xFFFFU)     //!< Bit mask for WDOG_WINH_WINHIGH.
#define BS_WDOG_WINH_WINHIGH (16U)         //!< Bit field size in bits for WDOG_WINH_WINHIGH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_WINH_WINHIGH field.
#define BR_WDOG_WINH_WINHIGH (HW_WDOG_WINH.U)
#endif

//! @brief Format value for bitfield WDOG_WINH_WINHIGH.
#define BF_WDOG_WINH_WINHIGH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_WINH_WINHIGH), uint16_t) & BM_WDOG_WINH_WINHIGH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WINHIGH field to a new value.
#define BW_WDOG_WINH_WINHIGH(v) (HW_WDOG_WINH_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_WINL - Watchdog Window Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_WINL - Watchdog Window Register Low (RW)
 *
 * Reset value: 0x0010U
 *
 * You must set the Window Register value lower than the Time-out Value Register.
 */
typedef union _hw_wdog_winl
{
    uint16_t U;
    struct _hw_wdog_winl_bitfields
    {
        uint16_t WINLOW : 16;          //!< [15:0]
    } B;
} hw_wdog_winl_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_WINL register
 */
//@{
#define HW_WDOG_WINL_ADDR        (REGS_WDOG_BASE + 0xAU)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_WINL             (*(__IO hw_wdog_winl_t *) HW_WDOG_WINL_ADDR)
#define HW_WDOG_WINL_RD()        (HW_WDOG_WINL.U)
#define HW_WDOG_WINL_WR(v)       (HW_WDOG_WINL.U = (v))
#define HW_WDOG_WINL_SET(v)      (HW_WDOG_WINL_WR(HW_WDOG_WINL_RD() |  (v)))
#define HW_WDOG_WINL_CLR(v)      (HW_WDOG_WINL_WR(HW_WDOG_WINL_RD() & ~(v)))
#define HW_WDOG_WINL_TOG(v)      (HW_WDOG_WINL_WR(HW_WDOG_WINL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_WINL bitfields
 */

/*!
 * @name Register WDOG_WINL, field WINLOW[15:0] (RW)
 *
 * Defines the lower 16 bits of the 32-bit window for the windowed mode of
 * operation of the watchdog. It is defined in terms of cycles of the pre-scaled
 * watchdog clock. In this mode, the watchdog can be refreshed only when the timer
 * reaches a value greater than or equal to this window length value. A refresh
 * outside of this window resets the system or if IRQRSTEN is set, it interrupts and
 * then resets the system.
 */
//@{
#define BP_WDOG_WINL_WINLOW  (0U)          //!< Bit position for WDOG_WINL_WINLOW.
#define BM_WDOG_WINL_WINLOW  (0xFFFFU)     //!< Bit mask for WDOG_WINL_WINLOW.
#define BS_WDOG_WINL_WINLOW  (16U)         //!< Bit field size in bits for WDOG_WINL_WINLOW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_WINL_WINLOW field.
#define BR_WDOG_WINL_WINLOW  (HW_WDOG_WINL.U)
#endif

//! @brief Format value for bitfield WDOG_WINL_WINLOW.
#define BF_WDOG_WINL_WINLOW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_WINL_WINLOW), uint16_t) & BM_WDOG_WINL_WINLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WINLOW field to a new value.
#define BW_WDOG_WINL_WINLOW(v) (HW_WDOG_WINL_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_REFRESH - Watchdog Refresh register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_REFRESH - Watchdog Refresh register (RW)
 *
 * Reset value: 0xB480U
 */
typedef union _hw_wdog_refresh
{
    uint16_t U;
    struct _hw_wdog_refresh_bitfields
    {
        uint16_t WDOGREFRESH : 16;     //!< [15:0]
    } B;
} hw_wdog_refresh_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_REFRESH register
 */
//@{
#define HW_WDOG_REFRESH_ADDR     (REGS_WDOG_BASE + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_REFRESH          (*(__IO hw_wdog_refresh_t *) HW_WDOG_REFRESH_ADDR)
#define HW_WDOG_REFRESH_RD()     (HW_WDOG_REFRESH.U)
#define HW_WDOG_REFRESH_WR(v)    (HW_WDOG_REFRESH.U = (v))
#define HW_WDOG_REFRESH_SET(v)   (HW_WDOG_REFRESH_WR(HW_WDOG_REFRESH_RD() |  (v)))
#define HW_WDOG_REFRESH_CLR(v)   (HW_WDOG_REFRESH_WR(HW_WDOG_REFRESH_RD() & ~(v)))
#define HW_WDOG_REFRESH_TOG(v)   (HW_WDOG_REFRESH_WR(HW_WDOG_REFRESH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_REFRESH bitfields
 */

/*!
 * @name Register WDOG_REFRESH, field WDOGREFRESH[15:0] (RW)
 *
 * Watchdog refresh register. A sequence of 0xA602 followed by 0xB480 within 20
 * bus clock cycles written to this register refreshes the WDOG and prevents it
 * from resetting the system. Writing a value other than the above mentioned
 * sequence or if the sequence is longer than 20 bus cycles, resets the system, or if
 * IRQRSTEN is set, it interrupts and then resets the system.
 */
//@{
#define BP_WDOG_REFRESH_WDOGREFRESH (0U)   //!< Bit position for WDOG_REFRESH_WDOGREFRESH.
#define BM_WDOG_REFRESH_WDOGREFRESH (0xFFFFU) //!< Bit mask for WDOG_REFRESH_WDOGREFRESH.
#define BS_WDOG_REFRESH_WDOGREFRESH (16U)  //!< Bit field size in bits for WDOG_REFRESH_WDOGREFRESH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_REFRESH_WDOGREFRESH field.
#define BR_WDOG_REFRESH_WDOGREFRESH (HW_WDOG_REFRESH.U)
#endif

//! @brief Format value for bitfield WDOG_REFRESH_WDOGREFRESH.
#define BF_WDOG_REFRESH_WDOGREFRESH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_REFRESH_WDOGREFRESH), uint16_t) & BM_WDOG_REFRESH_WDOGREFRESH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WDOGREFRESH field to a new value.
#define BW_WDOG_REFRESH_WDOGREFRESH(v) (HW_WDOG_REFRESH_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_UNLOCK - Watchdog Unlock register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_UNLOCK - Watchdog Unlock register (RW)
 *
 * Reset value: 0xD928U
 */
typedef union _hw_wdog_unlock
{
    uint16_t U;
    struct _hw_wdog_unlock_bitfields
    {
        uint16_t WDOGUNLOCK : 16;      //!< [15:0]
    } B;
} hw_wdog_unlock_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_UNLOCK register
 */
//@{
#define HW_WDOG_UNLOCK_ADDR      (REGS_WDOG_BASE + 0xEU)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_UNLOCK           (*(__IO hw_wdog_unlock_t *) HW_WDOG_UNLOCK_ADDR)
#define HW_WDOG_UNLOCK_RD()      (HW_WDOG_UNLOCK.U)
#define HW_WDOG_UNLOCK_WR(v)     (HW_WDOG_UNLOCK.U = (v))
#define HW_WDOG_UNLOCK_SET(v)    (HW_WDOG_UNLOCK_WR(HW_WDOG_UNLOCK_RD() |  (v)))
#define HW_WDOG_UNLOCK_CLR(v)    (HW_WDOG_UNLOCK_WR(HW_WDOG_UNLOCK_RD() & ~(v)))
#define HW_WDOG_UNLOCK_TOG(v)    (HW_WDOG_UNLOCK_WR(HW_WDOG_UNLOCK_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_UNLOCK bitfields
 */

/*!
 * @name Register WDOG_UNLOCK, field WDOGUNLOCK[15:0] (RW)
 *
 * Writing the unlock sequence values to this register to makes the watchdog
 * write-once registers writable again. The required unlock sequence is 0xC520
 * followed by 0xD928 within 20 bus clock cycles. A valid unlock sequence opens a
 * window equal in length to the WCT within which you can update the registers.
 * Writing a value other than the above mentioned sequence or if the sequence is
 * longer than 20 bus cycles, resets the system or if IRQRSTEN is set, it interrupts
 * and then resets the system. The unlock sequence is effective only if
 * ALLOWUPDATE is set.
 */
//@{
#define BP_WDOG_UNLOCK_WDOGUNLOCK (0U)     //!< Bit position for WDOG_UNLOCK_WDOGUNLOCK.
#define BM_WDOG_UNLOCK_WDOGUNLOCK (0xFFFFU) //!< Bit mask for WDOG_UNLOCK_WDOGUNLOCK.
#define BS_WDOG_UNLOCK_WDOGUNLOCK (16U)    //!< Bit field size in bits for WDOG_UNLOCK_WDOGUNLOCK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_UNLOCK_WDOGUNLOCK field.
#define BR_WDOG_UNLOCK_WDOGUNLOCK (HW_WDOG_UNLOCK.U)
#endif

//! @brief Format value for bitfield WDOG_UNLOCK_WDOGUNLOCK.
#define BF_WDOG_UNLOCK_WDOGUNLOCK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_UNLOCK_WDOGUNLOCK), uint16_t) & BM_WDOG_UNLOCK_WDOGUNLOCK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WDOGUNLOCK field to a new value.
#define BW_WDOG_UNLOCK_WDOGUNLOCK(v) (HW_WDOG_UNLOCK_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_TMROUTH - Watchdog Timer Output Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_TMROUTH - Watchdog Timer Output Register High (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_wdog_tmrouth
{
    uint16_t U;
    struct _hw_wdog_tmrouth_bitfields
    {
        uint16_t TIMEROUTHIGH : 16;    //!< [15:0]
    } B;
} hw_wdog_tmrouth_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_TMROUTH register
 */
//@{
#define HW_WDOG_TMROUTH_ADDR     (REGS_WDOG_BASE + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_TMROUTH          (*(__IO hw_wdog_tmrouth_t *) HW_WDOG_TMROUTH_ADDR)
#define HW_WDOG_TMROUTH_RD()     (HW_WDOG_TMROUTH.U)
#define HW_WDOG_TMROUTH_WR(v)    (HW_WDOG_TMROUTH.U = (v))
#define HW_WDOG_TMROUTH_SET(v)   (HW_WDOG_TMROUTH_WR(HW_WDOG_TMROUTH_RD() |  (v)))
#define HW_WDOG_TMROUTH_CLR(v)   (HW_WDOG_TMROUTH_WR(HW_WDOG_TMROUTH_RD() & ~(v)))
#define HW_WDOG_TMROUTH_TOG(v)   (HW_WDOG_TMROUTH_WR(HW_WDOG_TMROUTH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_TMROUTH bitfields
 */

/*!
 * @name Register WDOG_TMROUTH, field TIMEROUTHIGH[15:0] (RW)
 *
 * Shows the value of the upper 16 bits of the watchdog timer.
 */
//@{
#define BP_WDOG_TMROUTH_TIMEROUTHIGH (0U)  //!< Bit position for WDOG_TMROUTH_TIMEROUTHIGH.
#define BM_WDOG_TMROUTH_TIMEROUTHIGH (0xFFFFU) //!< Bit mask for WDOG_TMROUTH_TIMEROUTHIGH.
#define BS_WDOG_TMROUTH_TIMEROUTHIGH (16U) //!< Bit field size in bits for WDOG_TMROUTH_TIMEROUTHIGH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_TMROUTH_TIMEROUTHIGH field.
#define BR_WDOG_TMROUTH_TIMEROUTHIGH (HW_WDOG_TMROUTH.U)
#endif

//! @brief Format value for bitfield WDOG_TMROUTH_TIMEROUTHIGH.
#define BF_WDOG_TMROUTH_TIMEROUTHIGH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_TMROUTH_TIMEROUTHIGH), uint16_t) & BM_WDOG_TMROUTH_TIMEROUTHIGH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMEROUTHIGH field to a new value.
#define BW_WDOG_TMROUTH_TIMEROUTHIGH(v) (HW_WDOG_TMROUTH_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_TMROUTL - Watchdog Timer Output Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_TMROUTL - Watchdog Timer Output Register Low (RW)
 *
 * Reset value: 0x0000U
 *
 * During Stop mode, the WDOG_TIMER_OUT will be caught at the pre-stop value of
 * the watchdog timer. After exiting Stop mode, a maximum delay of 1 WDOG_CLK
 * cycle + 3 bus clock cycles will occur before the WDOG_TIMER_OUT starts following
 * the watchdog timer.
 */
typedef union _hw_wdog_tmroutl
{
    uint16_t U;
    struct _hw_wdog_tmroutl_bitfields
    {
        uint16_t TIMEROUTLOW : 16;     //!< [15:0]
    } B;
} hw_wdog_tmroutl_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_TMROUTL register
 */
//@{
#define HW_WDOG_TMROUTL_ADDR     (REGS_WDOG_BASE + 0x12U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_TMROUTL          (*(__IO hw_wdog_tmroutl_t *) HW_WDOG_TMROUTL_ADDR)
#define HW_WDOG_TMROUTL_RD()     (HW_WDOG_TMROUTL.U)
#define HW_WDOG_TMROUTL_WR(v)    (HW_WDOG_TMROUTL.U = (v))
#define HW_WDOG_TMROUTL_SET(v)   (HW_WDOG_TMROUTL_WR(HW_WDOG_TMROUTL_RD() |  (v)))
#define HW_WDOG_TMROUTL_CLR(v)   (HW_WDOG_TMROUTL_WR(HW_WDOG_TMROUTL_RD() & ~(v)))
#define HW_WDOG_TMROUTL_TOG(v)   (HW_WDOG_TMROUTL_WR(HW_WDOG_TMROUTL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_TMROUTL bitfields
 */

/*!
 * @name Register WDOG_TMROUTL, field TIMEROUTLOW[15:0] (RW)
 *
 * Shows the value of the lower 16 bits of the watchdog timer.
 */
//@{
#define BP_WDOG_TMROUTL_TIMEROUTLOW (0U)   //!< Bit position for WDOG_TMROUTL_TIMEROUTLOW.
#define BM_WDOG_TMROUTL_TIMEROUTLOW (0xFFFFU) //!< Bit mask for WDOG_TMROUTL_TIMEROUTLOW.
#define BS_WDOG_TMROUTL_TIMEROUTLOW (16U)  //!< Bit field size in bits for WDOG_TMROUTL_TIMEROUTLOW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_TMROUTL_TIMEROUTLOW field.
#define BR_WDOG_TMROUTL_TIMEROUTLOW (HW_WDOG_TMROUTL.U)
#endif

//! @brief Format value for bitfield WDOG_TMROUTL_TIMEROUTLOW.
#define BF_WDOG_TMROUTL_TIMEROUTLOW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_TMROUTL_TIMEROUTLOW), uint16_t) & BM_WDOG_TMROUTL_TIMEROUTLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMEROUTLOW field to a new value.
#define BW_WDOG_TMROUTL_TIMEROUTLOW(v) (HW_WDOG_TMROUTL_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_RSTCNT - Watchdog Reset Count register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_RSTCNT - Watchdog Reset Count register (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_wdog_rstcnt
{
    uint16_t U;
    struct _hw_wdog_rstcnt_bitfields
    {
        uint16_t RSTCNT : 16;          //!< [15:0]
    } B;
} hw_wdog_rstcnt_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_RSTCNT register
 */
//@{
#define HW_WDOG_RSTCNT_ADDR      (REGS_WDOG_BASE + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_RSTCNT           (*(__IO hw_wdog_rstcnt_t *) HW_WDOG_RSTCNT_ADDR)
#define HW_WDOG_RSTCNT_RD()      (HW_WDOG_RSTCNT.U)
#define HW_WDOG_RSTCNT_WR(v)     (HW_WDOG_RSTCNT.U = (v))
#define HW_WDOG_RSTCNT_SET(v)    (HW_WDOG_RSTCNT_WR(HW_WDOG_RSTCNT_RD() |  (v)))
#define HW_WDOG_RSTCNT_CLR(v)    (HW_WDOG_RSTCNT_WR(HW_WDOG_RSTCNT_RD() & ~(v)))
#define HW_WDOG_RSTCNT_TOG(v)    (HW_WDOG_RSTCNT_WR(HW_WDOG_RSTCNT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_RSTCNT bitfields
 */

/*!
 * @name Register WDOG_RSTCNT, field RSTCNT[15:0] (RW)
 *
 * Counts the number of times the watchdog resets the system. This register is
 * reset only on a POR. Writing 1 to the bit to be cleared enables you to clear
 * the contents of this register.
 */
//@{
#define BP_WDOG_RSTCNT_RSTCNT (0U)         //!< Bit position for WDOG_RSTCNT_RSTCNT.
#define BM_WDOG_RSTCNT_RSTCNT (0xFFFFU)    //!< Bit mask for WDOG_RSTCNT_RSTCNT.
#define BS_WDOG_RSTCNT_RSTCNT (16U)        //!< Bit field size in bits for WDOG_RSTCNT_RSTCNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_RSTCNT_RSTCNT field.
#define BR_WDOG_RSTCNT_RSTCNT (HW_WDOG_RSTCNT.U)
#endif

//! @brief Format value for bitfield WDOG_RSTCNT_RSTCNT.
#define BF_WDOG_RSTCNT_RSTCNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_RSTCNT_RSTCNT), uint16_t) & BM_WDOG_RSTCNT_RSTCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTCNT field to a new value.
#define BW_WDOG_RSTCNT_RSTCNT(v) (HW_WDOG_RSTCNT_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_WDOG_PRESC - Watchdog Prescaler register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_WDOG_PRESC - Watchdog Prescaler register (RW)
 *
 * Reset value: 0x0400U
 */
typedef union _hw_wdog_presc
{
    uint16_t U;
    struct _hw_wdog_presc_bitfields
    {
        uint16_t RESERVED0 : 8;        //!< [7:0]
        uint16_t PRESCVAL : 3;         //!< [10:8]
        uint16_t RESERVED1 : 5;        //!< [15:11]
    } B;
} hw_wdog_presc_t;
#endif

/*!
 * @name Constants and macros for entire WDOG_PRESC register
 */
//@{
#define HW_WDOG_PRESC_ADDR       (REGS_WDOG_BASE + 0x16U)

#ifndef __LANGUAGE_ASM__
#define HW_WDOG_PRESC            (*(__IO hw_wdog_presc_t *) HW_WDOG_PRESC_ADDR)
#define HW_WDOG_PRESC_RD()       (HW_WDOG_PRESC.U)
#define HW_WDOG_PRESC_WR(v)      (HW_WDOG_PRESC.U = (v))
#define HW_WDOG_PRESC_SET(v)     (HW_WDOG_PRESC_WR(HW_WDOG_PRESC_RD() |  (v)))
#define HW_WDOG_PRESC_CLR(v)     (HW_WDOG_PRESC_WR(HW_WDOG_PRESC_RD() & ~(v)))
#define HW_WDOG_PRESC_TOG(v)     (HW_WDOG_PRESC_WR(HW_WDOG_PRESC_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual WDOG_PRESC bitfields
 */

/*!
 * @name Register WDOG_PRESC, field PRESCVAL[10:8] (RW)
 *
 * 3-bit prescaler for the watchdog clock source. A value of zero indicates no
 * division of the input WDOG clock. The watchdog clock is divided by (PRESCVAL +
 * 1) to provide the prescaled WDOG_CLK.
 */
//@{
#define BP_WDOG_PRESC_PRESCVAL (8U)        //!< Bit position for WDOG_PRESC_PRESCVAL.
#define BM_WDOG_PRESC_PRESCVAL (0x0700U)   //!< Bit mask for WDOG_PRESC_PRESCVAL.
#define BS_WDOG_PRESC_PRESCVAL (3U)        //!< Bit field size in bits for WDOG_PRESC_PRESCVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the WDOG_PRESC_PRESCVAL field.
#define BR_WDOG_PRESC_PRESCVAL (HW_WDOG_PRESC.B.PRESCVAL)
#endif

//! @brief Format value for bitfield WDOG_PRESC_PRESCVAL.
#define BF_WDOG_PRESC_PRESCVAL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint16_t) << BP_WDOG_PRESC_PRESCVAL), uint16_t) & BM_WDOG_PRESC_PRESCVAL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRESCVAL field to a new value.
#define BW_WDOG_PRESC_PRESCVAL(v) (HW_WDOG_PRESC_WR((HW_WDOG_PRESC_RD() & ~BM_WDOG_PRESC_PRESCVAL) | BF_WDOG_PRESC_PRESCVAL(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_wdog_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All WDOG module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_wdog
{
    __IO hw_wdog_stctrlh_t STCTRLH;        //!< [0x0] Watchdog Status and Control Register High
    __IO hw_wdog_stctrll_t STCTRLL;        //!< [0x2] Watchdog Status and Control Register Low
    __IO hw_wdog_tovalh_t TOVALH;          //!< [0x4] Watchdog Time-out Value Register High
    __IO hw_wdog_tovall_t TOVALL;          //!< [0x6] Watchdog Time-out Value Register Low
    __IO hw_wdog_winh_t WINH;              //!< [0x8] Watchdog Window Register High
    __IO hw_wdog_winl_t WINL;              //!< [0xA] Watchdog Window Register Low
    __IO hw_wdog_refresh_t REFRESH;        //!< [0xC] Watchdog Refresh register
    __IO hw_wdog_unlock_t UNLOCK;          //!< [0xE] Watchdog Unlock register
    __IO hw_wdog_tmrouth_t TMROUTH;        //!< [0x10] Watchdog Timer Output Register High
    __IO hw_wdog_tmroutl_t TMROUTL;        //!< [0x12] Watchdog Timer Output Register Low
    __IO hw_wdog_rstcnt_t RSTCNT;          //!< [0x14] Watchdog Reset Count register
    __IO hw_wdog_presc_t PRESC;            //!< [0x16] Watchdog Prescaler register
} hw_wdog_t;
#pragma pack()

//! @brief Macro to access all WDOG registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_WDOG</code>.
#define HW_WDOG        (*(hw_wdog_t *) REGS_WDOG_BASE)
#endif

#endif // __HW_WDOG_REGISTERS_H__
// v22/130726/0.9
// EOF
