/****************************************************/
/*     IAP Library for LPC1768   					*/
/* Target MCU  : NXP LPC1768 (ARM Cortex M3)        */
/*       	   : OSC : 12 MHz                     	*/
/* Create By   : fhn                                */
/* created     : 28 november 2011                   */
/* Function    : code for using IAP / read SN       */
/* 				 and write data into flash			*/
/****************************************************/
#ifndef __IAP_H
#define __IAP_H

#define	TARGET_SECTOR	29
#define START_TARGET_SECTOR	0x00078000

#define     USER_FLASH_AREA_START   START_TARGET_SECTOR
#define     USER_FLASH_AREA_SIZE    (FLASH_SECTOR_SIZE_16_TO_29 * 1)
#define     FLASH_SECTOR_SIZE_0_TO_15    ( 4 * 1024)
#define     FLASH_SECTOR_SIZE_16_TO_29   (32 * 1024)

#define IAP_ADDRESS 0x1FFF1FF1


/*** VARIABLES ***/
unsigned param_table[5];

typedef struct
{
  unsigned int ReturnCode;
  unsigned int Result[4];
}IAP_return_TypeDef;

IAP_return_TypeDef iap_return;


/*** PROTOTYEPES ***/
void iap_entry(unsigned param_tab[],unsigned result_tab[]);
void read_serial_number(void);
void blank_check_sector(int start, int end);
void erase_block_sector(int start, int end);
void prepare_write_block_sector(int start, int end);
void copy_ram_flash(char *src_addr, char *dest_addr, int size);
void compare_flash_ram(char *src_addr, char *dest_addr, int size);
void savedata_into_flash(char *mem,int mem_size);
void error_buzer(unsigned int beepnmb);


#endif


