/****************************************************/
/*     IAP Library for LPC1768   					*/
/* Target MCU  : NXP LPC1768 (ARM Cortex M3)        */
/*       	   : OSC : 12 MHz                     	*/
/* Create By   : fhn                                */
/* created     : 28 november 2011                   */
/* Function    : code for using IAP / read SN       */
/* 				 and write data into flash			*/
/****************************************************/
#include <stdio.h>
#include "iap.h"


void iap_entry(unsigned param_tab[],unsigned result_tab[])
{
	void (*iap)(unsigned [],unsigned []);
	iap = (void (*)(unsigned [],unsigned []))IAP_ADDRESS;
	iap(param_tab,result_tab);
}

void read_serial_number(void) //read serial via IAP
{
	char tmpbuf[256];

	param_table[0] = 54; //IAP command
	iap_entry(param_table,(unsigned int*)(&iap_return));
	if(iap_return.ReturnCode ==0) //return: CODE SUCCESS
	{
		printf("Part ID Number:");
		sprintf(tmpbuf, "%08X",iap_return.Result[0]);
		printf(tmpbuf);
	}
	else
	{
		//printf("Sorry, CPU Part Identification Number Read Error\n");
		printf("Sorry, Read Error");
	}
	param_table[0] = 58; //IAP command
	iap_entry(param_table,(unsigned int*)(&iap_return));
	if(iap_return.ReturnCode ==0) //return: CODE SUCCESS
	{
		printf("Serial Number:");
		sprintf(tmpbuf,"%08X %08X",iap_return.Result[0],iap_return.Result[1]);
		printf(tmpbu);
		sprintf(tmpbuf,"%08X %08X",iap_return.Result[2],iap_return.Result[3]);
		printf(tmpbuf);
	}
	else
	{
		printf("Sorry, CPU Serial Number Read Error\n");
	}
}


void blank_check_sector(int start, int end)
{
	param_table[0] = 53;	//5310 command code
	param_table[1] = (unsigned int) start;	// start Sector Number
	param_table[2] = (unsigned int) end;	// end sector number - should be equal or greater than start

	iap_entry(param_table,(unsigned int*)(&iap_return));
}

void erase_block_sector(int start, int end)
{
	param_table[0] = 52;	//5210 command code
	param_table[1] = (unsigned int) start;	// start Sector Number
	param_table[2] = (unsigned int) end;	// end sector number - should be equal or greater than start
	param_table[3] = 72000;	// cclk 72 MHz

	iap_entry(param_table,(unsigned int*)(&iap_return));
}

void prepare_write_block_sector(int start, int end)
{
	param_table[0] = 50;	//5210 command code
	param_table[1] = (unsigned int) start;	// start Sector Number
	param_table[2] = (unsigned int) end;	// end sector number - should be equal or greater than start

	iap_entry(param_table,(unsigned int*)(&iap_return));
}

void copy_ram_flash(char *src_addr, char *dest_addr, int size)
{
	param_table[0] = 51;	//5210 command code
	param_table[1] = (unsigned int) dest_addr;	// Destination flash address where data bytes are to be written. This address should be a 256 byte boundary.
	param_table[2] = (unsigned int) src_addr;	// Source RAM address from which data bytes are to be read. This address should be a word boundary.
	param_table[3] = (unsigned int) size;		// Number of bytes to be written. Should be 256 | 512 | 1024 | 4096.
	param_table[4] = (unsigned int) 72000;		// cclk 72 MHz

	iap_entry(param_table,(unsigned int*)(&iap_return));
}

void compare_flash_ram(char *src_addr, char *dest_addr, int size)
{
	param_table[0] = 56;	//5610 command code
	param_table[1] = (unsigned int) dest_addr;	//  Starting flash or RAM address of data bytes to be compared. This address should be a word boundary.
	param_table[2] = (unsigned int) src_addr;	// Starting flash or RAM address of data bytes to be compared. This	address should be a word boundary.
	param_table[3] = (unsigned int) size;		// Number of bytes to be compared; should be a multiple of 4.

	iap_entry(param_table,(unsigned int*)(&iap_return));
}

void savedata_into_flash(char *mem,int mem_size)
{
	blank_check_sector(TARGET_SECTOR,TARGET_SECTOR);

	// erase if needed
	if(iap_return.ReturnCode ==8) //return: SECTOR_NOT_BLANK
	{
		prepare_write_block_sector(TARGET_SECTOR,TARGET_SECTOR);
		if (iap_return.ReturnCode !=0)
		{
			error_buzer(iap_return.ReturnCode);	//will beep to indicate error
			return ;	//can't prepare memory for write... aborted
		}

		erase_block_sector(TARGET_SECTOR,TARGET_SECTOR);
		if (iap_return.ReturnCode !=0)
		{
			error_buzer(iap_return.ReturnCode);	//will beep to indicate error
			return ;	//can't erase... aborted
		}
	}

	// copy RAM to FLASH
	prepare_write_block_sector(TARGET_SECTOR,TARGET_SECTOR);
	if (iap_return.ReturnCode !=0)
	{
		error_buzer(iap_return.ReturnCode);	//will beep to indicate error
		return ;	//can't prepare memory for write... aborted
	}

	copy_ram_flash(mem,(char *)START_TARGET_SECTOR,mem_size);
	if (iap_return.ReturnCode !=0)
	{
		error_buzer(iap_return.ReturnCode);	//will beep to indicate error
		return ;	//can't prepare memory for write... aborted
	}

	compare_flash_ram(mem,(char *)START_TARGET_SECTOR,mem_size);
	if (iap_return.ReturnCode !=0)
	{
		error_buzer(iap_return.ReturnCode);	//will beep to indicate error
		return ;	//can't prepare memory for write... aborted
	}

}

void error_buzer(unsigned int beepnmb)
{

	unsigned int i=0;


  /* Start of Initial Buzzer Interface */
  LPC_PINCON->PINSEL7 &= ~(3UL<<20); 						// Reset P3.26 = GPIO
  LPC_GPIO3->FIOSET	  |=  (1UL<<26);						// P3.26 = 1 (OFF Buzzer)
  LPC_GPIO3->FIODIR   |=  (1UL<<26);						// P3.26 = Output (Buzzer)
  /* End of Initial Buzzer Interface */

  for (i=0;i<beepnmb;i++)
  {
	LPC_GPIO3->FIOCLR = (1UL<<26);  						//P3.26=0(ON-BUZZER)
	delay_ms(500);
	LPC_GPIO3->FIOSET = (1UL<<26);  						//P3.26=1(OFF-BUZZER)
  }
}
