#include "ModeA.h"

void mode_A() {
    
    lcd.clear();
    lcd.printString("Mode A",0,0);
    lcd.refresh();
    wait_ms(250); 

    int segments[10] = {}; // Enter your hex values here!
    int count = 0;
    
    update_display(count, segments[count]);

    while (button_a.read() == 0) {
        
        if(button_b.read() == 1){
            count++;
            update_display(count, segments[count]);
            wait_ms(250);
        }
        if(button_d.read() == 1){
            count--;
            update_display(count, segments[count]);
            wait_ms(250);
        }
        
        

    }

}

void update_display(int count, int hex){
    char count_string[14];
    sprintf(count_string, "Count = %d    ", count);
    lcd.printString(count_string,0,2);   
    char hex_string[14];
    sprintf(hex_string, "Hex: %#04x     ", hex);
    lcd.printString(hex_string,0,3);
    lcd.refresh();
    
}