/* WritingFiles

Simple example of using the local file system

Craig A. Evans

8/14

*/

#include "mbed.h"

// on-boards LEDs for visual feedback
BusOut leds(LED4,LED3,LED2,LED1);
LocalFileSystem local("local"); // create local filesystem

void writeDataToFile(int data);

int main()
{
    int counter = 0;  // variable to increment

    while (1) {
        leds = 15;   // turn on LEDs for feedback
        writeDataToFile(counter);  // write current value to disk
        counter++;   // increment counter
        leds = 0;    // turn off LEDs to signify file access has finished
        wait(1.0);   // small delay
    }

}

void writeDataToFile(int data)
{
    FILE *fp = fopen("/local/log.txt", "a");  // open 'log.txt' for appending
    // if the file doesn't exist it is created, if it exists, data is appended to the end
    fprintf(fp,"Counter = %i\n",data);  // print string to file
    fclose(fp);  // close file
}
