/**
@file Utils.h

@brief Header file containing various structs and convenience methods

@author Craig A. Evans
@date June 2015


*/

#ifndef UTILS_H
#define UTILS_H

// CONSTANTS

// used to convert RADIANS to DEGREES
#define RAD2DEG 57.2957795
#define PI 3.1415926536

// STRUCTS

// struct used to store coordinates in 3D space
typedef struct vector_t vector_t;
struct vector_t {
    float x;
    float y;
    float z;
};

typedef struct pose_t pose_t;
struct pose_t {
    float tx;  // translation in x
    float ty;  // translation in y
    float tz;  // translation in z
    float pitch;  // rotation around x
    float roll;   // rotation around y
    float yaw;    // rotation around z
};

/** Vector constructor (floats)
* @param x - x value
* @param y - y value
* @param z - z value
*/
vector_t create_vector(float x,float y,float z);

#endif