/* MeArm Lab 3 Task 1

(c) Dr Craig A. Evans, University of Leeds

July 2017

*/

#include "mbed.h"
#include "MeArm.h"

// create MeArm object - middle, left, right, claw
MeArm arm(p21,p22,p23,p24);

int main()
{
    //                             open , closed
    arm.set_claw_calibration_values(1450,2160);
    //                                  0 , 90
    arm.set_middle_calibration_values(1650,2700);
    arm.set_right_calibration_values(2000,1000);
    arm.set_left_calibration_values(1870,850);

    // x stays constant
    float x = 140.0;

    // arrays to store values in trajectory
    float y[20];
    float z[20];

    // loop through points in array
    for(int i = 0; i < 20; i++) {
        // this will create values in the range -100 to 100
        y[i] = -100.0 + (200.0*i)/(20-1);
        // scaled parabola - z = (y/10)^2 + 50
        z[i] = pow(y[i]/10.0,2.0)+50;
        // print to Cool Term to check - can plot in Excel
        printf("%f , %f\n",y[i],z[i]);
    }

    while(1) {

        // loop through each point from y=-100 to 100
        // and move the arm to each point
        for(int i = 0; i < 20; i++) {
            arm.goto_xyz(x,y[i],z[i]);
            // small delay before moving to next point
            wait_ms(50);
        }
        
        // then loop back in the opposite direction
        for(int i = 18; i > 0; i--) {
            arm.goto_xyz(x,y[i],z[i]);
            // small delay before moving to next point
            wait_ms(50);
        }
        
        // the loop then restarts so the arm will go back and forth along the trajectory
        
    }

}