/* MeArm Lab 1 Task 3

(c) Dr Craig A. Evans, University of Leeds

July 2017

*/

#include "mbed.h"
#include "MeArm.h"

// create MeArm object - middle, left, right, claw
MeArm arm(p21,p22,p23,p24);

AnalogIn m_pot(p17);

int main()
{
    //                             open , closed
    arm.set_claw_calibration_values(1450,2160);
    //                                  0 , 90
    arm.set_middle_calibration_values(1650,2700);
    arm.set_right_calibration_values(2000,1000);
    arm.set_left_calibration_values(1870,850);

  
    while(1) {
        
        // create x value in range 100 to 200 mm
        float x = 100.0 + 100.0*m_pot.read();
        float y = 0.0;
        float z = 100.0;   
        float claw_val = 1.0;   // 0.0 to 1.0
        
        arm.set_claw(claw_val);
        // move to co-ordinate
        arm.goto_xyz(x,y,z);

        wait(0.2);
        
    }
   
}