/* MeArm Lab 1 Task 1

(c) Dr Craig A. Evans, University of Leeds

July 2017

*/

#include "mbed.h"

// pins for potentiometers
AnalogIn m_pot(p17);
AnalogIn l_pot(p18);
AnalogIn r_pot(p19);

// PWM pins for servos
PwmOut m_servo(p21);
PwmOut l_servo(p22);
PwmOut r_servo(p23);

int main()
{

    m_servo.period_ms(20);  // 20 ms = 50 Hz
    // all PWM channels share the same period and so only need to set one of them

    // keep looping forever
    while(1) {

        // read val in range 0.0 to 1.0,
        float m_pot_val = m_pot.read();
        //  convert to -90 to +90
        float m_angle = -90.0+180.0*m_pot_val;

        // plug into linear equation to convert to pulse-width
        int m_pulse_us = int(1650.0 + 11.0*m_angle);  
        // move servo
        m_servo.pulsewidth_us(m_pulse_us);

        // ADD in code for left and right servos

        // delay as we don't want to update the servos too often
        wait_ms(200);
    }
}
