/*

2645_Ticker

Sample code from ELEC2645

Demonstrates how to use a ticker to generate a periodic timer interrupt

(c) Craig A. Evans, University of Leeds, Jan 2016

updated January 2020 - uses Gamepad2 peripherals

*/

#include "mbed.h"
#include "Gamepad.h"
#include "SoundData.h"

// Create objects for ticker and red LED
Ticker ticker;
Gamepad pad;

// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_timer_flag = 0;
volatile int g_sample = 0;

// function prototypes
void timer_isr();

int main()
{
    pad.init();
    // sample rate of music
    ticker.attach(&timer_isr,220e-6);

    while (1) {

        if (g_timer_flag == 1) {
            g_timer_flag = 0;

            // loop if reach end of samples
            if (g_sample >= NUM_ELEMENTS) {
                g_sample = 0;
            }
            // convert from 0 to 255 to 0.0 to 1.0
            float val = float(sound_data[g_sample])/ 256.0f;
            // write to DAC
            pad.write_dac(val);
            // move onto next sample
            g_sample++;

        }

        // put the MCU to sleep until an interrupt wakes it up
        sleep();
    }
}


// time-triggered interrupt
void timer_isr()
{
    g_timer_flag = 1;   // set flag in ISR
}
