/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "Joystick.h"
#include "N5110.h"


//VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(p14,p8,p9,p10,p11,p13,p21);

//                y     x  
Joystick joystick(p20,p19);

int main()
{
    // initialise the LCD and joystick
    lcd.init();
    lcd.setContrast(0.5);
    joystick.init();
    
    while (1) {
        // read the joystick to get the x- and y- values
        Vector2D coord = joystick.get_mapped_coord(); 
        printf("Coord = %f | %f\n",coord.x,coord.y);    
        
        lcd.clear();  // clear buffer at the start of the loop
        char buffer[14]={0};  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        sprintf(buffer,"x = %.3f",coord.x); // print formatted data to buffer
        lcd.printString(buffer,0,2);     // display on screen
        sprintf(buffer,"y = %.3f",coord.y); // print formatted data to buffer
        lcd.printString(buffer,0,3);     // display on screen
        lcd.refresh();  // need to fresh the screen to get the message to appear
        
        thread_sleep_for(200);
    }
}
