/* 

2645_InterruptIn

Sample code from ELEC2645 

Demonstrates how to use InterruptIn to generate an event-triggered interrupt

(c) Craig A. Evans, University of Leeds, Jan 2016
Updated January 2020

*/ 

#include "mbed.h"

// Create objects for button and LED
InterruptIn buttonA(PTC7);
DigitalOut led1(PTA2);

// flag - must be volatile as changes within ISR
// g_ prefix makes it easier to distinguish it as global
volatile int g_buttonA_flag = 0;

// function prototypes
void buttonA_isr();

int main()
{
    buttonA.mode(PullUp); // turn on internal pull-up resistor
    // pin will be 1 (3.3 V) when not pressed and 0 (0 V) when pressed
    
    // We therefore need to look for a falling edge on the pin to fire the interrupt
    // when the button is pressed
    buttonA.fall(&buttonA_isr);
 
    // the LED is a common anode - writing a 1 to the pin will turn the LED OFF
    led1 = 1;

    while (1) {

        // check if flag i.e. interrupt has occured
        if (g_buttonA_flag) {
            g_buttonA_flag = 0;  // if it has, clear the flag

            // send message over serial port - can observe in CoolTerm etc.
            printf("Execute task \n");

            led1 = !led1; // toggle LED
        }

        // put the MCU to sleep until an interrupt wakes it up
        sleep();

    }
}

// Button A event-triggered interrupt
void buttonA_isr()
{
    g_buttonA_flag = 1;   // set flag in ISR
}
