/* ELEC2645 Gamepad Test
 * 2nd Generation
 * January 2020
 * Dr Craig A. Evans & Joshua Davy
 */



// Includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"


// objects
Gamepad pad;
N5110 lcd;

void check_buttons();

int main()
{
    lcd.init();
    lcd.setContrast(0.5);
    pad.init();

    lcd.backLightOn();
    lcd.printString("Hello Gamepad!",0,0);
    lcd.refresh();
    pad.tone(1000.0,2.0);
    wait_ms(2000);
    
    lcd.clear();
    lcd.printString("Turn Pot 1",0,0);
    lcd.printString("  to set",0,1);
    lcd.printString(" contrast",0,2);
    lcd.refresh();
    
    // turn pot 1 during this 5 second period to tweak contrast
    for (int i = 0; i < 500; i++) {
        lcd.setContrast( pad.read_pot1());
        wait_ms(10);
    }

    lcd.clear();
    lcd.printString("LED test",0,0);
    lcd.refresh();
    
    // flash LEDs
    for (int i = 0; i < 20; i++) {
        pad.leds_on();
        wait_ms(200);
        pad.leds_off();
        wait_ms(200);
    }

    // PWM brightness (0 to 100%)
    for (float x = 0.0f; x <= 1.0f ; x+=0.1f) {
        pad.leds(x);
        wait_ms(500);
    }

    pad.leds_off();

    for (int n = 1; n <= 6; n++) {
        pad.led(n,1.0);  // led, full-brightness
        wait_ms(1000);
    }

    while(1) {
        pad.leds_off();
        lcd.clear();
        lcd.setContrast( pad.read_pot1());
        printf("%f , %f\n",pad.read_pot1(),pad.read_pot2());
        check_buttons();
        Vector2D coord = pad.get_mapped_coord();
        float x = coord.x;
        float y = coord.y;

        lcd.drawCircle(WIDTH/2+int(20*x),HEIGHT/2-int(20*y),3,FILL_BLACK);
        lcd.drawCircle(WIDTH/2,HEIGHT/2,20,FILL_TRANSPARENT);  // x,y,radius,transparent with outline

        lcd.refresh();
        wait_ms(100);
    }
}

void check_buttons()
{
    if ( pad.A_pressed())  {
        lcd.printChar('A',0,0);
        pad.led(1,1.0);
        pad.tone(1000.0,0.2);
        printf("A pressed\n");
    }
    if ( pad.B_pressed())  {
        lcd.printChar('B',0,1);
        pad.led(2,1.0);
        pad.tone(1000.0,0.2);
        printf("B pressed\n");
    }
    if ( pad.X_pressed())  {
        lcd.printChar('X',0,2);
        pad.led(3,1.0);
        pad.tone(1000.0,0.2);
        printf("X pressed\n");
    }
    if ( pad.Y_pressed() ) {
        lcd.printChar('Y',0,3);
        pad.led(4,1.0);
        pad.tone(1000.0,0.2);
        printf("Y pressed\n");
    }
    if ( pad.start_pressed()) {
        lcd.printChar('S',78,2);
        pad.led(5,1.0);
        pad.tone(1000.0,0.2);
        printf("Start pressed\n");
    }


}