/*
2645_FSM_Puffin

Sample code from ELEC2645

Demonstrates how to implement a puffin crossing using a FSM

(c) Craig A. Evans, University of Leeds, Jan 2016
Updated Janaury 2020 for Gamepad2
*/

#include "mbed.h"
// K64F on-board LEDs
BusOut k64f_leds(LED_RED, LED_GREEN, LED_BLUE);

// LEDs to display traffic light output
// LSB                       MSB
// car - green,amber, red  pedestrian - green, red
BusOut output(PTC3,PTC2,PTA2,PTC11,PTA1); 

// BusIn to read inputs simutaneously
// camera (button A) , pedestrian button (button B)
// LSB, MSB
BusIn input(PTC7,PTC9);

// struct for state
struct State {
    int output;  // output value
    float time;    // time in state
    int nextState[4];  // array of next states
};

State fsm[4] = {
    {0x..,5.0,{..,..,..,..}},  // 0 - cars stop, pedestrian walk               5 seconds
    {0x..,2.0,{..,..,..,..}},  // 1 - cars get ready to go, pedestrian stop    2 seconds
    {0x..,10.0,{..,..,..,..}}, // 2 - cars go, pedestrian stop                10 seconds
    {0x..,2.0,{..,..,..,..}}   // 3 - cars get ready to stop, pedestrian stop  2 seconds
};

int main()
{
    k64f_leds = 0b111;  // turn off K64F LEDs
    
    // turn on internal pull-up for buttons A and B
    input.mode(PullUp);
    
    int state = 2;  // start with cars green

    while(1) {
        output = fsm[state].output;  // set ouput depending on current state
        wait(fsm[state].time);       // wait in that state for desired time           
        state = fsm[state].nextState[input];  // read input (BusIn) and update curent state
    }
}
