#ifndef MAIN_H
#define MAIN_H

#include "m3pi.h"
#include "mbed.h"

// API objects
extern m3pi robot;

// LEDs on the Mbed board
extern BusOut leds;

// Buttons on the 3pi shield
extern DigitalIn button_A;
extern DigitalIn button_B;
extern DigitalIn button_X;
extern DigitalIn button_Y;
extern DigitalIn button_enter;
extern DigitalIn button_back;

// Blue potentiometers on the 3pi shield
extern AnalogIn pot_P;
extern AnalogIn pot_I;
extern AnalogIn pot_D;
extern AnalogIn pot_S;

// Globals

// Prototypes
void init();
void welcome();
void calibrate();
void wait_for_enter();
void repeat();

#endif