/* 3pi Lab 1 Example 2

(c) Dr Craig A. Evans, University of Leeds

June 2017

*/

#include "mbed.h"
#include "m3pi.h"

// API objects
m3pi robot;

// Function Prototypes
void init();

// Main Function
int main()
{
    init();

    // move cursor to position (0,0) - top-left
    robot.lcd_goto_xy(0,0);
    robot.lcd_print("Lab 1",5); // 5 is number of characters in message (max 8)
    robot.lcd_goto_xy(0,1);
    robot.lcd_print("Task 3",6);

    wait(2.0);

    // reset previous calibration values and run auto-calibrate routine
    robot.reset_calibration();
    // robot must be placed over a black line
    robot.auto_calibrate();

    // an array to store each of the sensor values
    unsigned int values[5]= {0};
    
    float dt = 1.0/10.0;  // we'll read the sensors 10 times a second

    // main loop - this runs forever
    while(1) {
        
        // clear the LCD so we can draw new information on every loop
        robot.lcd_clear();

        // read the sensor values and store in array
        // these values are 0 to 1000 (0 is white/1000 is black)
        robot.get_calibrated_values(values);
        
        // Can see the values using CoolTerm - select correct COM port
        for (int i=0; i< 5 ; i++) {
            printf("[%i] = %i | ",i,values[i]);    
        }
        printf("\n");
        
        // display a bar graph on the LCD
        robot.display_sensor_values(values,1);
        
        // in range -1 to 1, no error when line is at 0.0
        // number is negative when the line is to the left
        // number is positive when the line is to the right
        float line_position = robot.calc_line_position(values);

        // empty buffer to store values
        char buffer[6];
        sprintf(buffer,"%+.3f",line_position); // create message and store in array .3 means three decimal places
        // print line position on LCD
        robot.lcd_goto_xy(1,0);
        robot.lcd_print(buffer,6);

        // wait for a short time before repeating the loop
        wait(dt);

    }
}

// Functions
void init()
{
    robot.init();
}