/* 3pi Lab 1 Example 2

(c) Dr Craig A. Evans, University of Leeds

June 2017

*/

#include "mbed.h"
#include "m3pi.h"

// API objects
m3pi robot;
AnalogIn pot_P(p15);

// Function Prototypes
void init();

// Main Function
int main()
{
    init();
    
    // move cursor to position (0,0) - top-left
    robot.lcd_goto_xy(0,0);
    robot.lcd_print("Lab 1",5); // 5 is number of characters in message (max 8)
    robot.lcd_goto_xy(0,1);
    robot.lcd_print("Task 2",6);
    
    // we will update the motors 100 times per second
    float dt = 1.0/100.0;

    // main loop - this runs forever
    while(1) {

        // this returns a value in the range 0.0 to 1.0
        float pot_P_val = pot_P.read();
        
        // change to -1.0 to 1.0
        float motor_speed = 2.0*pot_P_val-1.0;
        // this gives full-speed backward (-1.0) to full-speed forward
        
        // set the speed of the left and right motors
        robot.motors(motor_speed,motor_speed);
        
        // wait for a short time before repeating the loop
        wait(dt);

    }
}

// Functions
void init()
{
    robot.init();
}