/* 3pi Lab 1 Example 1

(c) Dr Craig A. Evans, University of Leeds

June 2017

*/

#include "mbed.h"
#include "m3pi.h"

// API objects
m3pi robot;
DigitalIn button_enter(p24);
AnalogIn pot_S(p20);
BusOut leds(LED4,LED3,LED2,LED1);

// Global Variables
const char g_song[] = "!T240 L8 a gafaeada c+adaeafa >aa>bac#ada c#adaeaf4";
float speed = 0.0;

// Function Prototypes
void init();

// Main Function
int main()
{
    // call initialisation function - must do this first
    init();

    // move cursor to position (0,0) - top-left
    robot.lcd_goto_xy(0,0);
    robot.lcd_print("Lab 1",5); // 5 is number of characters in message (max 8)
    robot.lcd_goto_xy(0,1);
    robot.lcd_print("Task 1",6);

    // play song then leave a small delay for it to finish playing
    robot.play_music(g_song,sizeof(g_song));
    wait(5.0);

    // loop through 0 to 15, displaying the value in binary on the leds
    for (int value = 0; value < 16; value++) {
        leds = value;
        wait(0.1);
    }
    leds = 0;  // turn them all off

    // keep looping until button has been pressed
    while (button_enter.read() == 1) {

    }

    // main loop - this runs forever
    while(1) {

        // clear the screen
        robot.lcd_clear();
        // array to store message in
        char buffer[8];

        // check if enter button is pressed
        if (button_enter.read() == 0) { 
            speed = pot_S.read();  // if so, read speed potentiometer and store in variable
            sprintf(buffer,"S=%.3f",speed); // create message and store in array .3 means three decimal places
        }
        
        // go to bottom line of LCD
        robot.lcd_goto_xy(0,1);
        // print the message
        robot.lcd_print(buffer,7);

        // small delay
        wait(0.1);

    }
}

// Functions
void init()
{
    // initialise the robot
    robot.init();

    // turn on the pull-up resistor on the button
    // the button will read 1 when not pressed and 0 when pressed
    button_enter.mode(PullUp);

}