/* 3pi Example 2

(c) Dr Craig A. Evans, University of Leeds

June 2017

*/

#include "mbed.h"
#include "m3pi.h"

// API objects
m3pi buggy;
AnalogIn pot_P(p15);

// Function Prototypes
void init();

// Main Function
int main()
{
    init();
    
    // move cursor to position (0,0) - top-left
    buggy.lcd_goto_xy(0,0);
    // print on the LCD - the number 5 is the number of characters in the string
    buggy.lcd_print("Ex. 2",5);
    
    // we will update the motors 50 times per second
    float dt = 1.0/50.0;

    // main loop - this runs forever
    while(1) {

        // this returns a value in the range 0.0 to 1.0
        float pot_P_val = pot_P.read();
        
        // change to -1.0 to 1.0
        float motor_speed = 2.0*pot_P_val-1.0;
        // this gives full-speed backward (-1.0) to full-speed forward
        
        // set the speed of the left and right motors
        buggy.motors(motor_speed,motor_speed);
        
        // wait for a short time before repeating the loop
        wait(dt);

    }
}

// Functions
void init()
{
    buggy.init();
}